<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190627064714 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE if not exists zones (id INT AUTO_INCREMENT NOT NULL, country_code VARCHAR(10) NOT NULL, zone_name VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('DROP TABLE if exists country');
        $this->addSql('DROP TABLE if exists timezone');
        $this->addSql('DROP TABLE if exists zone');
        $this->addSql('ALTER TABLE user CHANGE roles roles JSON NOT NULL, CHANGE lname lname VARCHAR(60) DEFAULT NULL, CHANGE is_active is_active TINYINT(1) DEFAULT NULL, CHANGE active_by active_by INT DEFAULT NULL, CHANGE admission_number admission_number INT DEFAULT NULL');
        $this->addSql('ALTER TABLE app_settings CHANGE details details LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\'');
        $this->addSql('ALTER TABLE custom_fields CHANGE placeholder placeholder VARCHAR(100) DEFAULT NULL, CHANGE options options LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', CHANGE is_require is_require TINYINT(1) DEFAULT NULL, CHANGE visible_to visible_to VARCHAR(255) DEFAULT NULL, CHANGE visible_to_registration_form_of visible_to_registration_form_of VARCHAR(255) DEFAULT NULL, CHANGE allowed_extension allowed_extension VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE guardian CHANGE roles roles JSON NOT NULL, CHANGE phone phone VARCHAR(20) DEFAULT NULL');
        $this->addSql('ALTER TABLE student_guardians CHANGE phone phone VARCHAR(60) DEFAULT NULL, CHANGE roles roles JSON DEFAULT NULL');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE country (country_code CHAR(2) DEFAULT \'NULL\' COLLATE utf8_bin, country_name VARCHAR(45) DEFAULT \'NULL\' COLLATE utf8_bin, INDEX idx_country_code (country_code)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = MyISAM COMMENT = \'\' ');
        $this->addSql('CREATE TABLE timezone (zone_id INT NOT NULL, abbreviation VARCHAR(6) NOT NULL COLLATE utf8_bin, time_start NUMERIC(11, 0) NOT NULL, gmt_offset INT NOT NULL, dst CHAR(1) NOT NULL COLLATE utf8_bin, INDEX idx_time_start (time_start), INDEX idx_zone_id (zone_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = MyISAM COMMENT = \'\' ');
        $this->addSql('CREATE TABLE zone (zone_id INT AUTO_INCREMENT NOT NULL, country_code CHAR(2) NOT NULL COLLATE utf8_bin, zone_name VARCHAR(35) NOT NULL COLLATE utf8_bin, INDEX idx_country_code (country_code), INDEX idx_zone_name (zone_name), PRIMARY KEY(zone_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = MyISAM COMMENT = \'\' ');
        $this->addSql('DROP TABLE zones');
        $this->addSql('ALTER TABLE app_settings CHANGE details details LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:array)\'');
        $this->addSql('ALTER TABLE custom_fields CHANGE is_require is_require TINYINT(1) DEFAULT \'NULL\', CHANGE placeholder placeholder VARCHAR(100) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE options options LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:array)\', CHANGE visible_to visible_to VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE visible_to_registration_form_of visible_to_registration_form_of VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE allowed_extension allowed_extension VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci');
        $this->addSql('ALTER TABLE guardian CHANGE roles roles LONGTEXT NOT NULL COLLATE utf8mb4_bin, CHANGE phone phone VARCHAR(20) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci');
        $this->addSql('ALTER TABLE student_guardians CHANGE phone phone VARCHAR(60) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE roles roles LONGTEXT DEFAULT NULL COLLATE utf8mb4_bin');
        $this->addSql('ALTER TABLE user CHANGE roles roles LONGTEXT NOT NULL COLLATE utf8mb4_bin, CHANGE lname lname VARCHAR(60) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE is_active is_active TINYINT(1) DEFAULT \'NULL\', CHANGE active_by active_by INT DEFAULT NULL, CHANGE admission_number admission_number INT DEFAULT NULL');
    }
}
