<?php

namespace App\EventSubscriber;

use App\Entity\Guardian;
use App\Entity\User;
use App\Service\Guardian\GuardianService;
use Doctrine\ORM\Event\LifecycleEventArgs;
use phpDocumentor\Reflection\DocBlock\Tags\Deprecated;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Test\Constraint\ResponseStatusCodeSame;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\Event\GetResponseForExceptionEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Validator\Constraints\Json;

class AjaxSubscriber implements EventSubscriberInterface
{

    /**
     * @var ContainerInterface
     */
    private $container;
    /**
     * @var RouterInterface
     */
    private $router;
    /**
     * @var Security
     */
    private $security;

    ## ignore login check on some request
    const IgnoreSomeRequest = [
        '_wdt',
        ## when requesting to reset the password.
        'save_user_reset_form',
        ## update password request after linking on the forgot password link
        'update_password_request',
        ## registration request
        'save_user_registration_form',
    ];

    public function __construct(ContainerInterface $container, RouterInterface $router, Security $security)
    {
        $this->container = $container;
        $this->router = $router;
        $this->security = $security;
    }


    /**
     * @param GetResponseEvent $event
     *
     * @return JsonResponse
     */
    public function onControllerRequest($event)
    {

        /** @var Request $request */
        $request = $event->getRequest();


        if (in_array($request->attributes->get('_route'), self::IgnoreSomeRequest)) {
            ## ignore some ajax routes, like profiler routes.
        } else {
            /** @var User $User */
            $User = $this->security->getUser();

            ## if user is not logged in & request is ajax request then return access denied error
            if ($request->isXmlHttpRequest()) {
                ## if request is ajax
                if ($User->getCategory() == 'g' && !$User instanceof Guardian) {
                    ## if user is guardian
                    $event->setResponse(new Response($this->router->generate('user_login'), Response::HTTP_FORBIDDEN));
                } else if (!$User instanceof User && $User->getCategory() <> 'g') {
                    ## user is other than guardian
                    $event->setResponse(new Response($this->router->generate('user_login'), Response::HTTP_FORBIDDEN));
                }
            }

        }
    }

    public static function getSubscribedEvents()
    {
        return [
            ## on controller request.
            KernelEvents::RESPONSE => [['onControllerRequest', 30]],
        ];
    }

}
