<?php

namespace App\Entity;

use App\Repository\EmailTemplateEventsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\EmailTemplateEventsRepository")
 */
class EmailTemplateEvents
{

    public $dailyAttendanceEventId = 8;
    public $weeklyAttendanceEventId = 9;
    public $monthlyAttendanceEventId = 10;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $event_name;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\EmailTemplates", mappedBy="emailTemplateEvents", orphanRemoval=true)
     */
    private $trigger_template;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function __construct()
    {
        $this->trigger_template = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEventName(): ?string
    {
        return $this->event_name;
    }

    public function setEventName(string $event_name): self
    {
        $this->event_name = $event_name;

        return $this;
    }

    /**
     * @return Collection|EmailTemplates[]
     */
    public function getTriggerTemplate(): Collection
    {
        return $this->trigger_template;
    }

    public function addTriggerTemplate(EmailTemplates $triggerTemplate): self
    {
        if (!$this->trigger_template->contains($triggerTemplate)) {
            $this->trigger_template[] = $triggerTemplate;
            $triggerTemplate->setEmailTemplateEvents($this);
        }

        return $this;
    }

    public function removeTriggerTemplate(EmailTemplates $triggerTemplate): self
    {
        if ($this->trigger_template->contains($triggerTemplate)) {
            $this->trigger_template->removeElement($triggerTemplate);
            // set the owning side to null (unless already changed)
            if ($triggerTemplate->getEmailTemplateEvents() === $this) {
                $triggerTemplate->setEmailTemplateEvents(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }


    /**
     * @purpose::: Attendance Email Template
     * */


    public function getDailyAttendanceTemplate()
    {
//        return $emailTemplateEventsRepository->find($this->dailyAttendanceEventId);
    }

    public function getWeeklyAttendanceTemplate()
    {
//        return $emailTemplateEventsRepository->find($this->weeklyAttendanceEventId);
    }

    public function getMonthlyAttendanceTemplate()
    {
//        return $emailTemplateEventsRepository->find($this->monthlyAttendanceEventId);
    }
}
