<?php

namespace App\DataFixtures;

use App\Entity\SAnswersRegardingCF;
use App\Entity\TAnswerRegardingCF;
use App\Repository\TAnswerRegardingCFRepository;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;

class TAnswerFixtures extends Fixture implements DependentFixtureInterface
{
	private $faker;
    public function load(ObjectManager $manager)
    {
	    $this->faker = Factory::create();
	    for ( $x = 0; $x < 10; $x ++ ) {

		    $sanswer = new TAnswerRegardingCF();
		    $sanswer->setAnswers( $this->faker->sentence );
		    $sanswer->setCustomFields( $this->getReference( CustomFieldFixtures::CustomFieldRference . '_' . $x ) );
		    $sanswer->setUser( $this->getReference( UserFixtures::UserFixtureReference . $x ) );
		    $manager->persist( $sanswer );
	    }


	    $manager->flush();
    }

	/**
	 * This method must return an array of fixtures classes
	 * on which the implementing class depends on
	 *
	 * @return array
	 */
	public function getDependencies() {
		return [
			CustomFieldFixtures::class,
			UserFixtures::class,
		];
	}
}
