<?php

namespace App\Controller;

use App\Entity\BooksLibrary;
use App\Entity\LibraryAssigned;
use App\Entity\LibraryBookCopies;
use App\Entity\LibraryBooksAuthor;
use App\Entity\LibraryBooksCategory;
use App\Entity\LibrarySections;
use App\Repository\BooksLibraryRepository;
use App\Repository\LibraryAssignedRepository;
use App\Repository\LibraryBookCopiesRepository;
use App\Repository\LibraryBooksAuthorRepository;
use App\Repository\LibraryBooksCategoryRepository;
use App\Repository\LibrarySectionsRepository;
use App\Repository\UserRepository;
use App\Service\DefaultFunction;
use App\Service\LibraryService;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 * */
class LibraryController extends AbstractController
{

    /**
     * @var DefaultFunction
     */
    private $default_function;

    /**
     * @var LibraryBooksCategoryRepository
     */
    private $library_books_category_repository;

    /**
     * @var LibraryBooksAuthorRepository
     */
    Private $library_books_author_repository;

    /**
     * @var LibrarySectionsRepository
     */
    private $library_sections_repository;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var LibraryService
     */
    private $libraryService;
    /**
     * @var BooksLibraryRepository
     */
    private $books_library_repository;
    /**
     * @var LibraryBookCopiesRepository
     */
    private $library_book_copies_repository;
    /**
     * @var LibraryAssignedRepository
     */
    private $library_assigned_repository;
    /**
     * @var UserRepository
     */
    private $user_repository;

    /**
     * LibraryController constructor.
     *
     * @param LibraryBooksCategoryRepository $library_books_category_repository
     * @param EntityManagerInterface $entity_manager
     * @param DefaultFunction $default_function
     */

    public function __construct(UserRepository $user_repository, LibraryAssignedRepository $library_assigned_repository, LibraryBookCopiesRepository $library_book_copies_repository, BooksLibraryRepository $books_library_repository, LibraryBooksCategoryRepository $library_books_category_repository, LibraryBooksAuthorRepository $library_books_author_repository, LibrarySectionsRepository $library_sections_repository, EntityManagerInterface $entity_manager, LibraryService $libraryService)
    {
        $this->library_books_category_repository = $library_books_category_repository;
        $this->library_books_author_repository = $library_books_author_repository;
        $this->library_sections_repository = $library_sections_repository;
        $this->entity_manager = $entity_manager;
        $this->libraryService = $libraryService;
        $this->books_library_repository = $books_library_repository;
        $this->library_book_copies_repository = $library_book_copies_repository;
        $this->library_assigned_repository = $library_assigned_repository;
        $this->user_repository = $user_repository;
    }

    /**
     * @Route("/{_locale}/library/books-categories", name="category_area")
     *                                                     This method will show the whole
     *                                                    Book Category Section
     */
    public function books_category()
    {
        return $this->render('library/book_category.html.twig', [
            'category_list' => $this->library_books_category_repository->findAll(),
            'categoryForEdit' => new LibraryBooksCategory(),
        ]);
    }

    /**
     * @Route("/{_locale}/library/book-authors", name="author_area")
     *                                                    )
     */
    public function books_authors()
    {
        return $this->render('library/book_author.html.twig', [
            'author_list' => $this->library_books_author_repository->findAll(),
            'authorForEdit' => new LibraryBooksAuthor(),
        ]);
    }

    /**
     * @Route("/{_locale}/library/section", name="library_section_area")
     */
    public function library_sections()
    {
        return $this->render('library/library_sections.html.twig', [
            'sections_list' => $this->library_sections_repository->result_in_array(),
            'sections_list__tree_view' => $this->libraryService->generate_html_from__tree_view($this->libraryService->buildTree___view($this->library_sections_repository->result_in_array())),
            'library_sectionForEdit' => new LibrarySections(),
        ]);
    }

    /**
     * @Route("/{_locale}/library/books", name="book_library_")
     *
     */
    public function books_list_in_library()
    {
        return $this->generate___books_list_html(new BooksLibrary());
    }

    /**
     * @Route("/{_locale}/library/books/history", name="book_library_history__")
     *
     */
    public function history_of_books_assign_to_user()
    {
        return $this->render('library/library_history___of__book_assign.html.twig', [
            'library_book_lis' => $this->books_library_repository->findAll(),
        ]);
    }

    ## generate the books list html
    private function generate___books_list_html(BooksLibrary $Entity, $view = 'books_in_library_.html.twig', $viewMethod = 'render')
    {
        if (!$Entity instanceof BooksLibrary) {
            $Entity = new BooksLibrary();
        }

        return $this->$viewMethod('library/' . $view, [
            'books_in_library' => $Entity,
            'bookSect' => $this->library_sections_repository->findAll(),
            'bookCategory' => $this->library_books_category_repository->findAll(),
            'bookAuthName' => $this->library_books_author_repository->findAll(),
            'books__list' => $this->books_library_repository->findAll(),
            'book_copies' => $Entity->getLibraryBookCopies(),
        ]);
    }

    /**
     * @Route("{_locale}/library/requestHandler", name="requestHandler_library")
     */
    public function ajaxHandler(Request $request)
    {
        $query = $request->query->get('query');
        switch ($query) {
            case 'addNewCategory':
                ## add or edit new library category
                $returnValue = $this->libraryService->add_edit_category($request->request);
                break;
            case 'add_or_update_author':
                ## add or update library book author
                $returnValue = $this->libraryService->add_edit_book_author($request->request);
                break;
            case 'add_update_lib_sec':
                ## add or update the library sections
                $returnValue = $this->libraryService->add_edit_library_sections($request->request);
                break;
            case 'add_update_book_in_library':
                ## adding books to the library
                $returnValue = $this->libraryService->add_update_books_in_library($request->request);
                break;
            case 'get__data_to_update_book_in_library':
                $returnValue = null;

                ## get the book against the id.
                if (!empty($request->request->get('ref___'))) {
                    $returnValue = $this->libraryService->get_the_books__in_library($request->request->get('ref___'));
                }
                $returnValue = 'escape__fromErro_' . $this->generate___books_list_html($returnValue, 'books_in_library___add__.html.twig', 'renderView');
                break;
            case 'get__assign_book_to_user_form___html':
                $returnValue = 'escape__fromErro_' . $this->renderView('library/library_books_assigned_to__user.html.twig', [
                        'listOfStudent' => $this->user_repository->findBy([
                            'category' => 's',
                        ]),
                        'copy___Ref' => $request->request->get('ref___'),
                    ]);
                break;

            case 'book___assign_to__user':
                $returnValue = $this->libraryService->book_copy_assign_to_user($request->request);
                break;
            case 'return___book_by_student':
                $returnValue = $this->libraryService->return___book_by_student($request->request);
                break;
            Default:
                $returnValue = 'OK';
                break;
        }

        return new JsonResponse($returnValue, '200');
    }
}
