<?php


namespace App\Service\StudentsEnrollment;


use App\Entity\Classes;
use App\Entity\ClassSessionEnrolment;
use App\Entity\ClassSessionEnrolmentSubjects;
use App\Entity\User;
use App\Repository\ClassSessionEnrolmentRepository;
use App\Repository\ClassSessionEnrolmentSubjectsRepository;
use App\Service\accounts\InvoiceService;
use App\Service\DefaultFunction;
use App\Service\StudentClasses;
use App\Service\SubjectService;
use App\Service\UserService;
use Doctrine\ORM\EntityManager;
use Symfony\Component\HttpFoundation\ParameterBag;

class Enrollments
{

    private $errorArray = [];

    /**
     * @var ClassSessionEnrolmentSubjectsRepository
     */
    private $class_session_enrolment_subjects_repository;
    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $class_session_enrolment_repository;
    /**
     * @var StudentClasses
     */
    private $student_classes;
    /**
     * @var UserService
     */
    private $user_service;
    /**
     * @var EntityManager
     */
    private $entity_manager;
    /**
     * @var InvoiceService
     */
    private $invoice_service;
    /**
     * @var SubjectService
     */
    private $subject_service;

    public function __construct(
        UserService $user_service,
        StudentClasses $student_classes,
        ClassSessionEnrolmentSubjectsRepository $class_session_enrolment_subjects_repository,
        DefaultFunction $default_function,
        ClassSessionEnrolmentRepository $class_session_enrolment_repository
    ) {
        $this->class_session_enrolment_subjects_repository = $class_session_enrolment_subjects_repository;
        $this->default_function = $default_function;
        $this->class_session_enrolment_repository = $class_session_enrolment_repository;
        $this->student_classes = $student_classes;
        $this->user_service = $user_service;
    }


    /**
     * ================ CLASS SESSION ENROLLMENT SUBJECTS
     *
     * */

    ## get the enrolled user on base of subjects
    public function getEnrolledUserOnBaseOfSubjects(ParameterBag $bag)
    {
        try {
            ## because it always return object becauase of many to many relation.
            $ClassSessionSubjectEnrollment = $this->class_session_enrolment_subjects_repository->get__EnrolledStudentList(
                $bag->get('s___ref')
            );
            if ($ClassSessionSubjectEnrollment instanceof ClassSessionEnrolmentSubjects) {
                $response = $ClassSessionSubjectEnrollment->getClassSessionEntrolment()->getUserId();
            } else {
                $response = $ClassSessionSubjectEnrollment;
            }
        } catch (\Exception $exception) {
            $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
        }

        if (empty($this->errorArray)) {
            return $response;
        } else {
            return $this->errorArray;
        }

    }

    ## get class session enrolment subject
    public function getClassSessionEnrolmentSubject(int $ref)
    {
        $response = 'Enrol Subject reference not found';
        if (!empty($ref)) {
            try {
                $response = $this->class_session_enrolment_subjects_repository->find($ref);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    /**
     * =============== CLASS SESSION ENROLLMENT
     * */
    ## get the user list for the attendance which is enrolled in the class
    public function getListOfUserBasedOnClassEnrollments(ParameterBag $bag)
    {
        try {
            $ClassSessionEnrollment = $this->class_session_enrolment_repository->get__EntrolledStudentList(
                $bag->get('class__ref')
            );
            if ($ClassSessionEnrollment instanceof ClassSessionEnrolment) {
                $response = $ClassSessionEnrollment->getUserId();
            } else {
                $response = $ClassSessionEnrollment;
            }
        } catch (\Exception $exception) {
            $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
        }


        if (empty($this->errorArray)) {
            return $response;
        } else {
            return $this->errorArray;
        }

    }

    ## get class session enrollment of specific user.
    public function get___classSessionEnrollmentOfUser(ParameterBag $request)
    {
        try {
            $ClassSessionEnrollment = $this->class_session_enrolment_repository->findOneBy(
                [
                    'class_session' => $request->get('c___'),
                    'user_id' => $request->get('id'),
                    'is_deleted' => $request->get('is_deleted', false),
                ]
            );
        } catch (\Exception $exception) {
            $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
        }
        if (empty($this->errorArray)) {
            return $ClassSessionEnrollment;
        } else {
            return $this->errorArray;
        }
    }

    ## get class enrolment
    public function get__class_session_enrolment(int $reference)
    {
        $response = null;
        if (!empty($reference)) {
            try {
                $response = $this->class_session_enrolment_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;

    }

    ## validate class session enrolment
    public function validateAddEditClassSessionEnrolment(ParameterBag $bag)
    {
        $response = [];

        ## studentRef
        if (empty($bag->get('studentRef'))) {
            $response = $this->default_function->push_error($response, 'Student Reference is not found');
        }

        ## class Ref
        if (empty($bag->get('classRef'))) {
            $response = $this->default_function->push_error($response, 'Class Reference is not found');
        }

        return $response;
    }

    ## get classes of  users
    public function getEnrolledClassesOfUsers(array $users)
    {
        $bag = new ParameterBag();
        $bag->set('userArray', $users);

        return $this->class_session_enrolment_repository->search($bag);
    }

    ## save class session enrolment
    //	public function addEditClassSessionEnrolment( ParameterBag $bag ) {
    //		$response = [];
    //
    //		## validation response
    //		if ( ! empty( $validationResponse = $this->validateAddEditClassSessionEnrolment( $bag ) ) ) {
    //			return $validationResponse;
    //		}
    //
    //		## decide what to do add or edit.
    //		$Entity = null;
    //		if ( ! empty( $bag->get( 'classSessionEnrolmentRef' ) ) ) {
    //			try {
    //				$Entity = $this->get__class_session_enrolment( $bag->get( 'classSessionEnrolmentRef' ) );
    //			} catch ( \Exception $exception ) {
    //				$response = $exception->getMessage();
    //			}
    //		}
    //
    //		## return response, if we have error.
    //		if ( ! empty( $response ) ) {
    //			return $response;
    //		}
    //
    //		##
    //		if ( ! $Entity instanceof ClassSessionEnrolment ) {
    //			$Entity = new ClassSessionEnrolment();
    //		}
    //
    //		## get the class.
    //		$class = $this->student_classes->get_the_class( $bag->get( 'classRef' ) );
    //
    //		## if class not found
    //		if ( ! $class instanceof Classes ) {
    //			$response = $this->default_function->push_error( $response, 'Class not found' );
    //			$response = $this->default_function->push_error( $response, $class );
    //		}
    //
    //		## get the user
    //		$User = $this->user_service->pre__userCheck( $bag );
    //
    //		## if user not found
    //		if ( ! $User instanceof User ) {
    //			$response = $this->default_function->push_error( $response, 'Student not found' );
    //			$response = $this->default_function->push_error( $response, $User );
    //		}
    //
    //		## return response, if we have error.
    //		if ( ! empty( $response ) ) {
    //			return $response;
    //		}
    //
    //		try {
    //			## save the student class enrolment
    //			$ClassSessionEnrollment = new ClassSessionEnrolment();
    //			$ClassSessionEnrollment->setUserId( $User );
    //			$ClassSessionEnrollment->setFee( $class->getFee() );
    //			$ClassSessionEnrollment->setNotes( '' );
    //			$ClassSessionEnrollment->setClassSession( $class );
    //			$ClassSessionEnrollment->setAttendanceType( $class->getAttendanceType() );
    //
    //			$this->entity_manager->persist( $ClassSessionEnrollment );
    //			$this->entity_manager->flush();
    //
    //			## generate invoice, when enrolment is done.
    //			$Bag__ = new ParameterBag();
    //			$Bag__->set( 'class', $class->getId() );
    //			$Bag__->set( 'studentRf', $User->getId() );
    //			$this->invoice_service->generateInvoiceWhileStudentEnrolmentInClass( $Bag__ );
    //
    //			## subject enrollment
    //			$this->subject_service->student___enrollmentInSubjects( $value, $ClassSessionEnrollment );
    //
    //			$response = 'OK';
    //		} catch ( \Exception $exception ) {
    //			$response = $this->default_function->push_error( $response, $exception->getMessage() );
    //		}
    //
    //		return $response;
    //
    //	}

}
