<?php


namespace App\Service\Students\Grade;


use App\Entity\GradeCategories;
use App\Repository\GradeCategoriesRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

class GradeCategoriesService extends CommonGradeProcedures
{

    /**
     * @var GradeCategoriesRepository
     */
    private $gradeCategoriesRepository;
    /**
     * @var EntityManagerInterface
     */
    private $entityManager;

    public function __construct(
        GradeCategoriesRepository $gradeCategoriesRepository,
        EntityManagerInterface $entityManager
    ) {
        $this->gradeCategoriesRepository = $gradeCategoriesRepository;
        $this->entityManager = $entityManager;
    }

    /**
     *
     * @param $categoryID
     *
     * @return \App\Entity\GradeCategories|string|null
     */
    public function getGradeCategory($categoryID = null)
    {
        $response = null;
        try {
            if (!empty($categoryID)) {
                $response = $this->gradeCategoriesRepository->find($categoryID);
            }
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }

    /**
     *  Get all grade Categories.
     * */
    public function getGradeCategories()
    {
        return $this->gradeCategoriesRepository->findAll();
    }


    /**
     * @param ParameterBag $request
     * Purpose: Save the grade category
     *
     * @return string|null
     */
    public function saveGradeCategory(ParameterBag $request)
    {
        $returnResponse = null;
        if (!empty($returnResponse = $this->validateGradeCategory($request))) {
            return $returnResponse;
        }
        $GradeCategory = $this->getGradeCategory($request->get('grdCat'));
        if (!$GradeCategory instanceof GradeCategories) {
            $GradeCategory = new GradeCategories();
        }
        try {
            $GradeCategory->setGradeCategoryDesc($request->get('grdCat_name'));
            $GradeCategory->setGradeCategoryName($request->get('grdCat_des'));
            $this->entityManager->persist($GradeCategory);
            $this->entityManager->flush();
            $returnResponse = 'OK';
        } catch (\Exception $exception) {
            $returnResponse = $exception->getMessage();
        }

        return $returnResponse;
    }

    /**
     * @param ParameterBag $request
     * purpose: validate the grade
     *
     * @return string
     */
    private function validateGradeCategory(ParameterBag $request)
    {
        if (empty($request->get('grdCat_name'))) {
            return 'Grade Category is missing';
        }
    }


}