<?php

namespace App\Repository;

use App\Entity\WhoCanUpdateCustomField;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method WhoCanUpdateCustomField|null find( $id, $lockMode = null, $lockVersion = null )
 * @method WhoCanUpdateCustomField|null findOneBy( array $criteria, array $orderBy = null )
 * @method WhoCanUpdateCustomField[]    findAll()
 * @method WhoCanUpdateCustomField[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class WhoCanUpdateCustomFieldRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, WhoCanUpdateCustomField::class );
	}


	## list of custom field which specific user is not able to edit.
	## this will for the user, ex. student teacher and admins (employee)
	public function listOfNonEditableField( $userID ) {
		return $this->createQueryBuilder( 'who_can_update_custom_field' )
		            ->leftJoin( 'who_can_update_custom_field.user_reference', 'user_reference' )
		            ->leftJoin( 'who_can_update_custom_field.custom_field_ref', 'custom_field_ref' )
		            ->addSelect( 'custom_field_ref.id' )
		            ->andWhere( 'user_reference.id = :userId' )
		            ->andWhere( 'custom_field_ref IS NOT NULL' )
		            ->setParameter( 'userId', $userID )
		            ->getQuery()
		            ->getScalarResult();
	}


	// /**
	//  * @return WhoCanUpdateCustomField[] Returns an array of WhoCanUpdateCustomField objects
	//  */
	/*
	public function findByExampleField($value)
	{
		return $this->createQueryBuilder('w')
			->andWhere('w.exampleField = :val')
			->setParameter('val', $value)
			->orderBy('w.id', 'ASC')
			->setMaxResults(10)
			->getQuery()
			->getResult()
		;
	}
	*/

	/*
	public function findOneBySomeField($value): ?WhoCanUpdateCustomField
	{
		return $this->createQueryBuilder('w')
			->andWhere('w.exampleField = :val')
			->setParameter('val', $value)
			->getQuery()
			->getOneOrNullResult()
		;
	}
	*/
}
