<?php

namespace App\Repository;

use App\Entity\Session;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method Session|null find($id, $lockMode = null, $lockVersion = null)
 * @method Session|null findOneBy(array $criteria, array $orderBy = null)
 * @method Session[]    findAll()
 * @method Session[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class SessionRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, Session::class);
    }

    public function duplicationCheck(\Symfony\Component\HttpFoundation\ParameterBag $bagDuplication)
    {
        ## query Builder
        $queryBuilder = $this->createQueryBuilder('session');

        if (!empty($bagDuplication->get('name'))) {
            $queryBuilder->andWhere('session.name = :name')->setParameter('name', $bagDuplication->get('name'));
        }

        if (!empty($bagDuplication->get('whereNotIn'))) {
            $queryBuilder->andWhere('session.id <> :notCheck')->setParameter('notCheck', $bagDuplication->get('whereNotIn'));
        }

        $queryBuilder->andWhere('session.is_deleted = false');
        return $queryBuilder->getQuery()->getResult();

    }

    ## get list of all sessions.
    public function listOfSession(bool $parse__YesNoToBoolean)
    {
        ## session query builder
        $queryBuilder = $this->createQueryBuilder('session');

        ## ignore delete records
        if (!$parse__YesNoToBoolean) {
            $queryBuilder = $queryBuilder->andWhere('session.is_deleted = 0');
        }
        return $queryBuilder->orderBy('session.is_deleted', 'ASC')->getQuery()->getResult();
    }

}
