<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Security\Core\User\EquatableInterface;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * @ORM\Entity(repositoryClass="App\Repository\GuardianRepository")
 */
class Guardian implements UserInterface
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;


    /**
     * @ORM\Column(type="json")
     */
    private $roles = [];

    /**
     * @var string The hashed password
     * @ORM\Column(type="string")
     */
    private $password;

    /**
     * @ORM\Column(type="string", length=20, nullable=true)
     */
    private $phone;

    /**
     * @ORM\ManyToMany(targetEntity="App\Entity\User", inversedBy="guardians")
     */
    private $student_reference;
    private $salt;

    /**
     * @ORM\ManyToMany(targetEntity="App\Entity\WhoCanUpdateCustomField", mappedBy="guardian_ref")
     */
    private $whoCanUpdateCustomFields;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InternalChatGroupsGuardian", mappedBy="guardians")
     */
    private $internal_chat_groups__involvements;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $fname;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $lname;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $guardian_email;

    /**
     * @ORM\Column(type="string", length=3)
     */
    private $guardian_relation;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_active;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    /**
     * @ORM\Column(type="string", length=1)
     */
    private $category = 'g';

    /**
     * @ORM\Column(type="integer")
     */
    private $gender = 1;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ScheduleMessage", mappedBy="guardian")
     */
    private $scheduleMessages;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Tokens", mappedBy="guardian")
     */
    private $tokens;

    public function __construct()
    {
        /*$name, $salt, array $roles
        $this->name  = $name;
        $this->salt  = $salt;
        $this->roles = $roles;*/

        $this->student_reference = new ArrayCollection();
        $this->whoCanUpdateCustomFields = new ArrayCollection();
        $this->internal_chat_groups__involvements = new ArrayCollection();
        $this->scheduleMessages = new ArrayCollection();
        $this->tokens = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * A visual identifier that represents this user.
     *
     * @see UserInterface
     */
    public function getUsername(): string
    {
        return (string)$this->getFname().' '.$this->getLname();
    }

    /**
     * Get the user's full name
     *
     * @see UserInterface
     */
    public function getFullName(): string
    {
        return $this->fname.' '.$this->lname;
    }

    /**
     * @see UserInterface
     */
    public function getRoles(): array
    {
        $roles = $this->roles;
        // guarantee every user at least has ROLE_USER
        $roles[] = 'ROLE_USER';

        return array_unique($roles);
    }

    public function setRoles(array $roles): self
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * @see UserInterface
     */
    public function getPassword(): string
    {
        return (string)$this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(?string $phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getStudentReference(): Collection
    {
        return $this->student_reference;
    }

    public function addStudentReference(User $studentReference): self
    {
        if (!$this->student_reference->contains($studentReference)) {
            $this->student_reference[] = $studentReference;
        }

        return $this;
    }

    public function removeStudentReference(User $studentReference): self
    {
        if ($this->student_reference->contains($studentReference)) {
            $this->student_reference->removeElement($studentReference);
        }

        return $this;
    }

    /**
     * The equality comparison should neither be done by referential equality
     * nor by comparing identities (i.e. getId() === getId()).
     *
     * However, you do not need to compare every attribute, but only those that
     * are relevant for assessing whether re-authentication is required.
     *
     * @return bool
     */
    public function isEqualTo(UserInterface $user)
    {
        if (!$user instanceof Guardian) {
            return false;
        }

        if ($this->password !== $user->getPassword()) {
            return false;
        }

        if ($this->salt !== $user->getSalt()) {
            return false;
        }

        if ($this->name !== $user->getUsername()) {
            return false;
        }

        return true;
    }

    /**
     * Returns the salt that was originally used to encode the password.
     *
     * This can return null if the password was not encoded using a salt.
     *
     * @return string|null The salt
     */
    public function getSalt()
    {
        return $this->salt;
    }

    /**
     * Removes sensitive data from the user.
     *
     * This is important if, at any given point, sensitive information like
     * the plain-text password is stored on this object.
     */
    public function eraseCredentials()
    {
        // TODO: Implement eraseCredentials() method.
        //$this->password = null;
    }

    /**
     * @return Collection|WhoCanUpdateCustomField[]
     */
    public function getWhoCanUpdateCustomFields(): Collection
    {
        return $this->whoCanUpdateCustomFields;
    }

    public function addWhoCanUpdateCustomField(WhoCanUpdateCustomField $whoCanUpdateCustomField): self
    {
        if (!$this->whoCanUpdateCustomFields->contains($whoCanUpdateCustomField)) {
            $this->whoCanUpdateCustomFields[] = $whoCanUpdateCustomField;
            $whoCanUpdateCustomField->addGuardianRef($this);
        }

        return $this;
    }

    public function removeWhoCanUpdateCustomField(WhoCanUpdateCustomField $whoCanUpdateCustomField): self
    {
        if ($this->whoCanUpdateCustomFields->contains($whoCanUpdateCustomField)) {
            $this->whoCanUpdateCustomFields->removeElement($whoCanUpdateCustomField);
            $whoCanUpdateCustomField->removeGuardianRef($this);
        }

        return $this;
    }

    /**
     * @return Collection|InternalChatGroupsGuardian[]
     */
    public function getInternalChatGroupsInvolvements(): Collection
    {
        return $this->internal_chat_groups__involvements;
    }

    public function addInternalChatGroupsInvolvement(InternalChatGroupsGuardian $internalChatGroupsInvolvement): self
    {
        if (!$this->internal_chat_groups__involvements->contains($internalChatGroupsInvolvement)) {
            $this->internal_chat_groups__involvements[] = $internalChatGroupsInvolvement;
            $internalChatGroupsInvolvement->setGuardians($this);
        }

        return $this;
    }

    public function removeInternalChatGroupsInvolvement(InternalChatGroupsGuardian $internalChatGroupsInvolvement): self
    {
        if ($this->internal_chat_groups__involvements->contains($internalChatGroupsInvolvement)) {
            $this->internal_chat_groups__involvements->removeElement($internalChatGroupsInvolvement);
            // set the owning side to null (unless already changed)
            if ($internalChatGroupsInvolvement->getGuardians() === $this) {
                $internalChatGroupsInvolvement->setGuardians(null);
            }
        }

        return $this;
    }

    public function getFname(): ?string
    {
        return $this->fname;
    }

    public function setFname(string $fname): self
    {
        $this->fname = $fname;

        return $this;
    }

    public function getLname(): ?string
    {
        return $this->lname;
    }

    public function setLname(string $lname): self
    {
        $this->lname = $lname;

        return $this;
    }

    public function getGuardianEmail(): ?string
    {
        return $this->guardian_email;
    }

    public function setGuardianEmail(string $guardian_email): self
    {
        $this->guardian_email = $guardian_email;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->getGuardianEmail();
    }

    public function setEmail(string $guardian_email): self
    {
        return $this->setGuardianEmail($guardian_email);
    }

    public function getGuardianRelation(): ?string
    {
        return $this->guardian_relation;
    }

    public function getGuardianRelationInWords(): ?string
    {
        $guardianRelationInWords = 'Father';
        if ($this->guardian_relation == 'g') {
            $guardianRelationInWords = 'Guardian';
        } else {
            if ($this->guardian_relation == 'm') {
                $guardianRelationInWords = 'Mother';
            }
        }

        return $guardianRelationInWords;
    }

    public function setGuardianRelation(string $guardian_relation): self
    {
        $this->guardian_relation = $guardian_relation;

        return $this;
    }

    public function getIsActive(): ?bool
    {
        return $this->is_active;
    }

    public function setIsActive(bool $is_active): self
    {
        $this->is_active = $is_active;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    public function getCategory(): ?string
    {
        return $this->category;
    }

    public function setCategory(string $category): self
    {
        $this->category = $category;

        return $this;
    }

    public function getGender(): ?int
    {
        return $this->gender;
    }

    public function setGender(int $gender): self
    {
        $this->gender = $gender;

        return $this;
    }

    /**
     * @return Collection|ScheduleMessage[]
     */
    public function getScheduleMessages(): Collection
    {
        return $this->scheduleMessages;
    }

    public function addScheduleMessage(ScheduleMessage $scheduleMessage): self
    {
        if (!$this->scheduleMessages->contains($scheduleMessage)) {
            $this->scheduleMessages[] = $scheduleMessage;
            $scheduleMessage->setGuardian($this);
        }

        return $this;
    }

    public function removeScheduleMessage(ScheduleMessage $scheduleMessage): self
    {
        if ($this->scheduleMessages->contains($scheduleMessage)) {
            $this->scheduleMessages->removeElement($scheduleMessage);
            // set the owning side to null (unless already changed)
            if ($scheduleMessage->getGuardian() === $this) {
                $scheduleMessage->setGuardian(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Tokens[]
     */
    public function getTokens(): Collection
    {
        return $this->tokens;
    }

    public function addToken(Tokens $token): self
    {
        if (!$this->tokens->contains($token)) {
            $this->tokens[] = $token;
            $token->setGuardian($this);
        }

        return $this;
    }

    public function removeToken(Tokens $token): self
    {
        if ($this->tokens->contains($token)) {
            $this->tokens->removeElement($token);
            // set the owning side to null (unless already changed)
            if ($token->getGuardian() === $this) {
                $token->setGuardian(null);
            }
        }

        return $this;
    }
}
