<?php

namespace App\Entity;

use App\Repository\EmailTemplateEventsRepository;
use App\Service\SMSGateways\OperationalionalGatewayClass;
use App\Service\TriggerNotifications;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ExamsClassesStudentRepository")
 */
class ExamsClassesStudent
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $ecs_gain_marks;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=false)
     */
    private $exam_did_by;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $remarks;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Subjects", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=true)
     * ## Deprecated
     */
    private $subject;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=true)
     * ## Deprecated
     */
    private $classes;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ExamsClasses", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=false)
     */
    private $exams_classes;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubject", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=true)
     * ## Deprecated
     */
    private $class_subject;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEcsGainMarks(): ?int
    {
        return $this->ecs_gain_marks;
    }

    public function setEcsGainMarks(int $ecs_gain_marks): self
    {
        $this->ecs_gain_marks = $ecs_gain_marks;

        return $this;
    }

    public function getExamDidBy(): ?User
    {
        return $this->exam_did_by;
    }

    public function setExamDidBy(?User $exam_did_by): self
    {
        $this->exam_did_by = $exam_did_by;

        return $this;
    }

    public function getRemarks(): ?string
    {
        return $this->remarks;
    }

    public function setRemarks(?string $remarks): self
    {
        $this->remarks = $remarks;

        return $this;
    }

    public function getSubject(): ?Subjects
    {
        return $this->subject;
    }

    public function setSubject(?Subjects $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    public function getClasses(): ?Classes
    {
        return $this->classes;
    }

    public function setClasses(?Classes $classes): self
    {
        $this->classes = $classes;

        return $this;
    }

    public function getExamsClasses(): ?ExamsClasses
    {
        return $this->exams_classes;
    }

    public function setExamsClasses(?ExamsClasses $exams_classes): self
    {
        $this->exams_classes = $exams_classes;

        return $this;
    }

    public function getClassSubject(): ?ClassSubject
    {
        return $this->class_subject;
    }

    public function setClassSubject(?ClassSubject $class_subject): self
    {
        $this->class_subject = $class_subject;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    public function getMarksAbbrevation()
    {

    }

    public function sendSMSAboutGainMarks(
        ExamsClasses $examsClasses,
        TriggerNotifications $triggerNotifications
    ) {
        $getGuardians = $this->getExamDidBy()->getGuardians()->toArray();
        $examAttendStatus = 'Present';

        switch ($this->getEcsGainMarks()) {
            case -2:
                $examAttendStatus = 'Absent';
                $ExamGotMessage = $this->getExamDidBy()->getFullName().' is absent in '.$examsClasses->getClass(
                    )->getName().' subject of '.$examsClasses->getClassSubject()->getSubjectName().' class';
                break;
            case -1:
                $examAttendStatus = ' Un-visible';
                $ExamGotMessage = $this->getExamDidBy()->getFullName(
                    ).' was not setting in exam of '.$examsClasses->getClass()->getName(
                    ).' subject of '.$examsClasses->getClassSubject()->getSubjectName().' class';
                break;
            case 0:
            default:
                $ExamGotMessage = $this->getExamDidBy()->getFullName().' obtain '.$this->getEcsGainMarks(
                    ).' Marks in  '.$examsClasses->getClass()->getName().' subject of '.$examsClasses->getClassSubject(
                    )->getSubjectName().' class';

        }


        foreach ($getGuardians as $gKey => $gValue) {
            /** @var Guardian $gValue */
            $args = [
                'event_name' => 'EXAM',
                'user' => $this->getExamDidBy(),
                'notification_type' => 'exam_marks',
                'examClassStudent' => $this,
                'guardian' => $gValue,
                'phone' => $gValue->getPhone(),
                'receiver' => $gValue->getEmail(),
                'class_name' => $examsClasses->getClass()->getName(),
                'exam_at' => date_format($examsClasses->getEcDate(), 'Y-m-d H:s'),
                'total_marks' => $examsClasses->getExamTotalMarks(),
                'subject_name' => $examsClasses->getClassSubject()->getSubjectName(),
                'exam_attend_status' => $examAttendStatus,
            ];
            $triggerNotifications->triggerNotifications($args);
        }


    }


    public function multipleExamReportTable($examReport)
    {
        $table = '
<table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable">
     
                <td align="center" valign="top">
               
                    <table border="1" cellpadding="20" cellspacing="0" width="600" id="emailContainer">
                    
                    <tr>
                        <th align="center" valign="top">Exam name</th>
                        <th align="center" valign="top">Class</th>
                        <th align="center" valign="top">Subject</th>
                        <th align="center" valign="top">Obtain Marks</th>
                        <th align="center" valign="top">Passing Marks</th>
                        <th align="center" valign="top">Subject Total Marks</th>
                    </tr>
                    
';
        foreach ($examReport as $exm) {
            $table .= '<tr>';

            if ($exm instanceof ExamsClassesStudent) {

                // Exam name
                $table .= '<td align="center" valign="top">';

                if (!empty($exm->getExamsClasses()->getExam()->getExamName())) {
                    $table .= $exm->getExamsClasses()->getExam()->getExamName();
                } else {
                    $table .= 'Exam';
                }

                $table .= '</td>';


                $table .= '<td align="center" valign="top">';

                if (!empty($exm->getExamsClasses()->getClass()->getName())) {
                    $table .= $exm->getExamsClasses()->getClass()->getName();
                } else {
                    $table .= 'Class';
                }

                $table .= '</td>';


                $table .= '<td align="center" valign="top">';

                if (!empty($exm->getExamsClasses()->getClassSubject()->getSubjectName())) {
                    $table .= $exm->getExamsClasses()->getClassSubject()->getSubjectName();
                } else {
                    $table .= 'Class';
                }

                $table .= '</td>';


                $table .= '<td align="center" valign="top">';

                if (!empty($exm->getEcsGainMarks())) {
                    $table .= $exm->getEcsGainMarks();
                } else {
                    $table .= '';
                }

                $table .= '</td>';


                $table .= '<td align="center" valign="top">';

                if (!empty($exm->getExamsClasses()->getExamPassingMarks())) {
                    $table .= $exm->getExamsClasses()->getExamPassingMarks();
                } else {
                    $table .= '';
                }

                $table .= '</td>';


                $table .= '<td align="center" valign="top">';

                if (!empty($exm->getExamsClasses()->getExamTotalMarks())) {
                    $table .= $exm->getExamsClasses()->getExamTotalMarks();
                } else {
                    $table .= '';
                }

                $table .= '</td>';

            }


            $table .= '</tr>';
        }


        $table .= '            </table>
                </td>
            </tr>
        </table>';

        return $table;
    }

    public function sendOnlyEmailAboutExamReport(
        TriggerNotifications $triggerNotification,
        $bulkExamReport,
        $Student
    ) {

        $getGuardians = $Student->getGuardians()->toArray();

        foreach ($getGuardians as $gKey => $gValue) {

            /** @var Guardian $gValue */

            $args = [
                'event_name' => 'CLASS_EXAM_REPORT',
                'user' => $Student,
                'notification_type' => 'bulk_exam_report',
                'attendance' => $this,
                'guardian' => $gValue,
                'receiver' => $gValue->getEmail(),
                's_marks_class_table' => $this->multipleExamReportTable($bulkExamReport),
            ];
            $triggerNotification->triggerNotifications($args);
        }
    }


}
