<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassSessionEnrolmentSubjectsRepository")
 */
class ClassSessionEnrolmentSubjects
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $fee;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $notes;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSessionEnrolment", inversedBy="classSessionEnrolmentSubjects")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $class_session_entrolment;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubject", inversedBy="class_session_enrolment_subject")
     * @ORM\JoinColumn(nullable=false)
     */
    private $classSubject;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Attendance", mappedBy="class_session_enrolment_subject")
     */
    private $attendances;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function __construct()
    {
        $this->attendances = new ArrayCollection();
    }


    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFee(): ?float
    {
        return $this->fee;
    }

    public function setFee(?float $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    public function getNotes(): ?string
    {
        return $this->notes;
    }

    public function setNotes(string $notes): self
    {
        $this->notes = $notes;

        return $this;
    }

    public function getClassSessionEntrolment(): ?ClassSessionEnrolment
    {
        return $this->class_session_entrolment;
    }

    public function setClassSessionEntrolment(?ClassSessionEnrolment $class_session_entrolment): self
    {
        $this->class_session_entrolment = $class_session_entrolment;

        return $this;
    }

    public function getClassSubject(): ?ClassSubject
    {
        return $this->classSubject;
    }

    public function setClassSubject(?ClassSubject $classSubject): self
    {
        $this->classSubject = $classSubject;

        return $this;
    }

    /**
     * @return Collection|Attendance[]
     */
    public function getAttendances(): Collection
    {
        return $this->attendances;
    }

    public function addAttendance(Attendance $attendance): self
    {
        if (!$this->attendances->contains($attendance)) {
            $this->attendances[] = $attendance;
            $attendance->setClassSessionEnrolmentSubject($this);
        }

        return $this;
    }

    public function removeAttendance(Attendance $attendance): self
    {
        if ($this->attendances->contains($attendance)) {
            $this->attendances->removeElement($attendance);
            // set the owning side to null (unless already changed)
            if ($attendance->getClassSessionEnrolmentSubject() === $this) {
                $attendance->setClassSessionEnrolmentSubject(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
