<?php

namespace App\Entity;

use App\Repository\EmailTemplateEventsRepository;
use App\Service\SMSGateways\OperationalionalGatewayClass;
use App\Service\TriggerNotifications;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpKernel\KernelInterface;


/**
 * @ORM\Entity(repositoryClass="App\Repository\AttendanceRepository")
 */
class Attendance
{


    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $comments;

    /**
     * @ORM\Column(type="datetime")
     */
    private $datetime_in;

    /**
     * @ORM\Column(type="datetime")
     */
    private $datetime_out;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="attendances")
     * @ORM\JoinColumn(nullable=false)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\AttendanceStatus", inversedBy="attendances")
     * @ORM\JoinColumn(nullable=false)
     */
    private $attendance_status;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSessionEnrolmentSubjects", inversedBy="attendances")
     * @ORM\JoinColumn(nullable=true)
     */
    private $class_session_enrolment_subject;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="attendance_did_by")
     * @ORM\JoinColumn(nullable=false)
     */
    private $blame_user;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSessionEnrolment", inversedBy="attendances")
     * @ORM\JoinColumn(nullable=true)
     */
    private $class_session_enrolment;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $attendance_status_type;

    /**
     * @var \DateTime $created
     *
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(type="datetime")
     */
    private $created;

    /**
     * @var \DateTime $updated
     *
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(type="datetime")
     */
    private $updated;


    public function getId(): ?int
    {
        return $this->id;
    }

    public function getComments(): ?string
    {
        return $this->comments;
    }

    public function setComments(?string $comments): self
    {
        $this->comments = $comments;

        return $this;
    }

    public function getDatetimeIn(): ?\DateTimeInterface
    {
        return $this->datetime_in;
    }

    public function setDatetimeIn(\DateTimeInterface $datetime_in): self
    {
        $this->datetime_in = $datetime_in;

        return $this;
    }

    public function getDatetimeOut(): ?\DateTimeInterface
    {
        return $this->datetime_out;
    }

    public function setDatetimeOut(\DateTimeInterface $datetime_out): self
    {
        $this->datetime_out = $datetime_out;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getAttendanceStatus(): ?AttendanceStatus
    {
        return $this->attendance_status;
    }

    public function setAttendanceStatus(?AttendanceStatus $attendance_status): self
    {
        $this->attendance_status = $attendance_status;

        return $this;
    }

    public function getClassSessionEnrolmentSubject(): ?ClassSessionEnrolmentSubjects
    {
        return $this->class_session_enrolment_subject;
    }

    public function setClassSessionEnrolmentSubject(?ClassSessionEnrolmentSubjects $class_session_enrolment_subject
    ): self {
        $this->class_session_enrolment_subject = $class_session_enrolment_subject;

        return $this;
    }

    public function getBlameUser(): ?User
    {
        return $this->blame_user;
    }

    public function setBlameUser(?User $blame_user): self
    {
        $this->blame_user = $blame_user;

        return $this;
    }

    public function getClassSessionEnrolment(): ?ClassSessionEnrolment
    {
        return $this->class_session_enrolment;
    }

    public function setClassSessionEnrolment(?ClassSessionEnrolment $class_session_enrolment): self
    {
        $this->class_session_enrolment = $class_session_enrolment;

        return $this;
    }

    public function getAttendanceStatusType(): ?int
    {
        return $this->attendance_status_type;
    }

    public function setAttendanceStatusType(?int $attendance_status_type): self
    {
        $this->attendance_status_type = $attendance_status_type;

        return $this;
    }

    public function getAttendanceStatusTypeName(): ?string
    {
        return $this->attendance_status_type == 1 ? 'Present' : 'Absent';
    }

    /**
     * @return \DateTime
     */
    public function getCreated(): \DateTime
    {
        return $this->created;
    }

    /**
     * @param \DateTime $created
     */
    public function setCreated(\DateTime $created): void
    {
        $this->created = $created;
    }

    /**
     * @return \DateTime
     */
    public function getUpdated(): \DateTime
    {
        return $this->updated;
    }

    /**
     * @param \DateTime $updated
     */
    public function setUpdated(\DateTime $updated): void
    {
        $this->updated = $updated;
    }

    public function sendSMSAboutAttendance(
        TriggerNotifications $triggerNotification
    ) {

        $getGuardians = $this->getUser()->getGuardians()->toArray();

        foreach ($getGuardians as $gKey => $gValue) {

            /** @var Guardian $gValue */

            $args = [
                'event_name' => 'DAILY_ATTENDANCE',
                'user' => $this->getUser(),
                'notification_type' => 'daily_attendance',
                'attendance' => $this,
                'guardian' => $gValue,
                'attendance_status_name' => $this->getAttendanceStatusTypeName(),
                'phone' => $gValue->getPhone(),
                'receiver' => $gValue->getEmail(),
            ];
            $triggerNotification->triggerNotifications($args);
        }
    }


    public function multipleAttendanceTable($AttendnaceList)
    {
        $table = '
<table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" id="bodyTable">
     
                <td align="center" valign="top">
               
                    <table border="1" cellpadding="20" cellspacing="0" width="600" id="emailContainer">
                    
                    <tr>
                        <th align="center" valign="top">Class</th>
                        <th align="center" valign="top">Subject</th>
                        <th align="center" valign="top">Attendance Status</th>
                        <th align="center" valign="top">Check In Time</th>
                    </tr>
                    
';
        foreach ($AttendnaceList as $attedance) {
            $table .= '<tr>';


            // Class name
            $table .= '<td align="center" valign="top">';

            if ($attedance instanceof Attendance) {
                if (!empty($attedance->getClassSessionEnrolment()->getClassSession()->getName())) {
                    $table .= $attedance->getClassSessionEnrolment()->getClassSession()->getName();
                } else {
                    $table .= 'Class';
                }
            }

            $table .= '</td>';


            // Class name
            $table .= '<td align="center" valign="top">';

            if ($attedance instanceof Attendance) {
                if ($attedance->getClassSessionEnrolmentSubject() instanceof ClassSessionEnrolmentSubjects && !empty(
                    $attedance->getClassSessionEnrolmentSubject()->getClassSubject()->getSubjectName()
                    )) {
                    $table .= $attedance->getClassSessionEnrolmentSubject()->getClassSubject()->getSubjectName();
                } else {
                    $table .= '';
                }
            }

            $table .= '</td>';

            $table .= '<td align="center" valign="top">';

            // Attendance Status
            if ($attedance instanceof Attendance) {
                if (!empty($attedance->getAttendanceStatus()->getName())) {
                    $table .= $attedance->getAttendanceStatus()->getName();
                }
            }

            $table .= '</td>';


            // Attendance at

            $table .= '<td align="center" valign="top">';

            if ($attedance instanceof Attendance) {
                $table .= date_format($attedance->getDatetimeIn(), 'Y-M-d');
            }

            $table .= '</td>';

            $table .= '</tr>';
        }


        $table .= '            </table>
                </td>
            </tr>
        </table>';

        return $table;
    }

    public function sendOnlyEmailAboutAttendance(
        TriggerNotifications $triggerNotification,
        $bulkAttendance,
        $Student
    ) {

        $getGuardians = $Student->getGuardians()->toArray();

        foreach ($getGuardians as $gKey => $gValue) {

            /** @var Guardian $gValue */

            $args = [
                'event_name' => 'CLASS_ATTENDANCE',
                'user' => $Student,
                'notification_type' => 'bulk_attendance_report',
                'attendance' => $this,
                'guardian' => $gValue,
                'attendance_status_name' => $this->getAttendanceStatusTypeName(),
                'phone' => $gValue->getPhone(),
                'receiver' => $gValue->getEmail(),
                's_attendance_class_table' => $this->multipleAttendanceTable($bulkAttendance),
            ];

            $triggerNotification->triggerNotifications($args);
        }
    }


    /**
     * ================== Attendance Template Messages
     */


    /**
     *  *
     * @param EmailTemplateEventsRepository $emailTemplateEventsRepository
     * @return
     */
    public function getDailyAttendanceShortMessage(EmailTemplateEventsRepository $emailTemplateEventsRepository)
    {
        return $emailTemplateEventsRepository->find(8)->getTriggerTemplate()->first()->getShortEmailTemplates(
        )->getContent();
    }

}
