<?php

namespace App\Controller;

use App\Entity\ClassSubject;
use App\Entity\Subjects;
use App\Repository\SubjectsRepository;
use App\Service\DefaultFunction;
use App\Service\StudentClasses;
use App\Service\StudentSession;
use App\Service\SubjectService;
use App\Service\UserService;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Config\Definition\Exception\Exception;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response as ResponseAlias;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @IsGranted("ROLE_USER")
 *
 */
class SubjectController extends AbstractController
{

    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var SubjectsRepository
     */
    private $subject_repository;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var SubjectService
     */
    private $subject_service;

    public function __construct(
        SubjectsRepository $subject_repository,
        DefaultFunction $default_function,
        EntityManagerInterface $entity_manager,
        SubjectService $subject_service
    ) {
        $this->subject_repository = $subject_repository;
        $this->default_function = $default_function;
        $this->entity_manager = $entity_manager;
        $this->subject_service = $subject_service;
    }

    /**
     * @Route("/{_locale}/subject", name="subject")
     * This method will show list of Subjects
     */
    public function index()
    {
        ##If We want to display all subjects
//        $SubjectList = $this->subject_repository->findBy([], ['is_deleted' => 'ASC']);
        $SubjectList = $this->subject_service->listOfSubjects();

        return $this->render(
            'subject/index.html.twig',
            [
                'subject_list' => $SubjectList,
            ]
        );
    }

    /**
     * @Route("/{_locale}/subject/add/{id}", name="add_subject",defaults={"id"=null})
     *
     * Method is used to add or edit the subjects.
     */
    public function add_subject($id)
    {
        $subjectForEdit = new Subjects();

        if ($id) {
            try {
                ## if client request for the subject edit
                $subjectForEdit = $this->subject_repository->find($id);
            } catch (Exception $exception) {
            }
        }

        ## if user request for that field which is not in database
        if (!$subjectForEdit instanceof Subjects) {
            $subjectForEdit = new Subjects();
        }

        return $this->render(
            'subject/addSubject.html.twig',
            [
                'subjectForEdit' => $subjectForEdit,
            ]
        );
    }

    /**
     * @Route("/{_locale}/class/subjects", name="classes_subjects")
     *
     * Get Class Subjects.
     * @param StudentSession $studentSession
     * @param StudentClasses $studentClasses
     * @param Request $request
     * @return ResponseAlias
     */
    public function class_subjects(StudentSession $studentSession, StudentClasses $studentClasses, Request $request)
    {
//        dd($this->subject_service->listOfClassSubjects($request->request));

        return $this->render(
            'subject/class_subject.html.twig',
            [
                'classSubjects' => $this->subject_service->listOfClassSubjects($request->query),
                'sessions' => $studentSession->getAllSessions(),
                'classes' => $studentClasses->getAllClasses(),
            ]
        );
    }

    /**
     * @Route("{_locale}/subject/requestHandler/{query}", name="requestHandler_student_subject")
     */
    public function ajaxHandler(Request $request, UserService $user_service, $query = null)
    {
        ## if user is not logged in the redirect the user to login page.
        $returnValue = 'OK';

        if (empty($query)) {
            ## get the query variable from the get request.
            $query = $request->query->get('query');
        }

        switch ($query) {
            case 'addNewSubject':
                //Save new Subject
                $returnValue = $this->subject_service->save__subject($request->request);
                break;
            case 'delete_subject':
                #delete selected Subject
                try {
                    #get selected subject
                    $subject_ = $this->subject_service->get__Subject($request->request->get('target'));
                    if ($subject_ instanceof Subjects) {
                        $this->entity_manager->remove($subject_);
                        $this->entity_manager->flush();
                        ## return success response.
                        $returnValue = 'OK';
                    }
                } catch (Exception $e) {
                    $returnValue = $e->getMessage();
                }
                break;
            /**
             * @deprecated
             */
            ## loadClassSubject which is associated with the subject
            case 'loadClassSubjectDetails':
                $ClassSubject = $this->subject_service->get__ClassSubject((int)$request->request->get('referece_'));
                if ($ClassSubject instanceof ClassSubject) {
                    $returnValue = [];
                    $returnValue['totalMarks'] = $ClassSubject->getMarks();
                    $returnValue['passMarks'] = $ClassSubject->getPassMarks();
                    $returnValue = 'escape__fromErro_'.json_encode($returnValue);
                } else {
                    $returnValue = $ClassSubject;
                }
                break;
            case 'DCST':
                ## delete Class subject template
                $returnValue = $this->subject_service->deleteClassSubjectTemplate(
                    (int)$request->request->get('ref'),
                    true
                );
                break;
            case 'DS':
                ## delete subject from subject table.
                $returnValue = $this->subject_service->deleteSubject((int)$request->request->get('rOO'), true);
                break;
            case 'DClassSubject':
                ## delete ClassSubject
                $returnValue = $this->subject_service->deleteClassSubject((int)$request->request->get('rOO'), true);
                break;
            Default:
                $returnValue = 'No route found';
                break;

        }

        return new JsonResponse($returnValue, 200);
    }

}
