<?php


namespace App\Service\Exams;


use App\Entity\Classes;
use App\Entity\ClassSessionEnrolment;
use App\Entity\ClassSubject;
use App\Entity\Examiners;
use App\Entity\Exams;
use App\Entity\ExamsClasses;
use App\Entity\ExamsClassesStudent;
use App\Entity\Subjects;
use App\Entity\User;
use App\Repository\ClassSessionEnrolmentRepository;
use App\Repository\ExaminersRepository;
use App\Repository\ExamsClassesRepository;
use App\Repository\ExamsClassesStudentRepository;
use App\Repository\ExamsRepository;
use App\Repository\UserRepository;
use App\Service\DefaultFunction;
use App\Service\StudentClasses;
use App\Service\SubjectService;
use App\Service\UserService;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Twig\Tests\Extension\Subject;
use Symfony\Component\HttpFoundation\ParameterBag;
use Twig\Environment;

class ExamsService
{


    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var ExamsRepository
     */
    private $exams_repository;
    /**
     * @var ExamsClassesRepository
     */
    private $exams_classes_repository;
    /**
     * @var ExamsClassesStudentRepository
     */
    private $exams_classes_student_repository;
    /**
     * @var ExaminersRepository
     */
    private $examiners_repository;
    /**
     * @var UserService
     */
    private $user_service;
    /**
     * @var SubjectService
     */
    private $subject_service;
    /**
     * @var Environment
     */
    private $environment;
    /**
     * @var StudentClasses
     */
    private $student_classes;
    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $classSessionEnrolmentRepository;

    ## 0 means student is present but got zero mark
    ## -2 Leave blank student is absent
    ## -1 Student is present but not appeard in test/exam

    public function __construct(DefaultFunction $default_function, SubjectService $subject_service, StudentClasses $student_classes, Environment $environment, UserService $user_service, EntityManagerInterface $entity_manager, ExamsRepository $exams_repository, ExamsClassesRepository $exams_classes_repository, ExamsClassesStudentRepository $exams_classes_student_repository, ExaminersRepository $examiners_repository, ClassSessionEnrolmentRepository $classSessionEnrolmentRepository)
    {
        $this->default_function = $default_function;
        $this->entity_manager = $entity_manager;
        $this->exams_repository = $exams_repository;
        $this->exams_classes_repository = $exams_classes_repository;
        $this->exams_classes_student_repository = $exams_classes_student_repository;
        $this->examiners_repository = $examiners_repository;
        $this->user_service = $user_service;
        $this->subject_service = $subject_service;
        $this->environment = $environment;
        $this->student_classes = $student_classes;
        $this->classSessionEnrolmentRepository = $classSessionEnrolmentRepository;
    }

    /**
     * Exams
     * */

    ## validate exams before save
    public function validate_exams(ParameterBag $parameter_bag)
    {
        $response = [];
        ## name should not empty.
        if (empty($parameter_bag->get('n__'))) {
            $response = $this->default_function->push_error($response, 'Exams name should not be empty');
        }

        return $response;
    }

    ## get the exams
    public function get__exams($reference = null, $ColumnName = null, $ColumnValue = null)
    {
        $response = 'Invalid exam reference';

        try {
            if (!empty($ColumnName) && !empty($ColumnValue)) {
                ## find by column value
                $response = $this->exams_repository->findOneBy([$ColumnName => $ColumnValue]);
            } else {
                ## find by id.
                $response = $this->exams_repository->find($reference);
            }

        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }


        return $response;
    }

    ## save data in exams
    public function save__exams(ParameterBag $bag)
    {
        $response = [];

        ## validate exams.
        if (!empty($validation_response = $this->validate_exams($bag))) {
            return $validation_response;
        }


        ## decide what to do, edit or add record.
        if (empty($bag->get('ex___Ed'))) {
            $Entity = new \App\Entity\Exams();
        } else {
            $Entity = $this->get__exams($bag->get('ex___Ed'));
            if (!$Entity instanceof \App\Entity\Exams) {
                $Entity = new \App\Entity\Exams();
            }
        }

        ## Examination should not be duplicate.
        ## save name of exam
        $ExamExistence = $this->get__exams(null, 'exam_name', $bag->get('n__'));
        if ($ExamExistence instanceof Exams) {
            return $bag->get('n__') . ',  exam is already exits, Please try some other name';
        }

        ## set name
        $Entity->setExamName($bag->get('n__'));
        ## set exam details
        $Entity->setExamDetails($bag->get('e___d'));

        try {
            $this->entity_manager->persist($Entity);
            $this->entity_manager->flush();
//            $response = 'escape__fromErro_' . $Entity->getId() . '_af_d_f_____' . $this->environment->render('examination/_exams_list_view.html.twig', ['exams' => [$Entity],]);
            $response = 'OK';
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }


        return $response;
    }

    /**
     * Exams Classes
     * */

    ## get the exams
    public function get__examClass(int $reference)
    {
        $response = 'Invalid class reference';
        if (!empty($reference)) {
            try {
                $response = $this->exams_classes_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    ## validate exams classes
    public function validate_examsClasses(ParameterBag $parameter_bag)
    {
        $response = [];

        ## exam name reference
        if (empty($parameter_bag->get('ex__mRF'))) {
            $response = $this->default_function->push_error($response, 'Exam should not be null');
        }

        ## subject reference
        if (empty($parameter_bag->get('exC__sbI'))) {
            $response = $this->default_function->push_error($response, 'Please select subject of which this exam');
        }

        ## class reference
        if (empty($parameter_bag->get('exC__cLs'))) {
            $response = $this->default_function->push_error($response, 'Please select class of which this exam');
        }

        ## exam date
        if (empty($parameter_bag->get('ex__d'))) {
            $response = $this->default_function->push_error($response, 'Exam date should not be null');
        }

        ## exam start time
        if (empty($parameter_bag->get('ex__St'))) {
            $response = $this->default_function->push_error($response, 'Exam start time should not be null');
        }

        ## exam end time
        if (empty($parameter_bag->get('ex__Et'))) {
            $response = $this->default_function->push_error($response, 'Exam end time should not be null');
        }


        ## exams total marks
        if (empty($parameter_bag->get('ex__tM'))) {
            $response = $this->default_function->push_error($response, 'Exam Total marks should not be null');
        }

        ## exams passing marks
        if (empty($parameter_bag->get('ex__PM'))) {
            $response = $this->default_function->push_error($response, 'Exam Passing marks should not be null');
        }

        ## if passing marks are greater than total marks then thrown an error
        if ($parameter_bag->get('ex__PM') > $parameter_bag->get('ex__tM')) {
            $response = $this->default_function->push_error($response, 'Passing marks can\'t be greater then total marks');
        }


        return $response;
    }

    ## save exam schedule
    public function save__exam_schedule(ParameterBag $bag)
    {
        $response = [];

        ## validate examClass.
        if (!empty($validation_response = $this->validate_examsClasses($bag))) {
            return $validation_response;
        }

        ## Duplication check.
        $duplicationResponse = $this->exams_classes_repository->saveClassExamDuplicationCheck((int)$bag->get('ex__mRF'), (int)$bag->get('exC__sbI'), (int)$bag->get('exC__cLs'), (string)$bag->get('ex__d'), (int)$bag->get('exm_C__Ed'));

        ## if records are matched and find already added value in the database then return him back.
        if (count($duplicationResponse) > 0) {
            return $response = $this->default_function->push_error($response, 'Duplication Error: exam with this name of same class, subject and at same date has been added');
        }


        ## decide what to do, edit or add record.
        if (empty($bag->get('exm_C__Ed'))) {
            $Entity = new ExamsClasses();
        } else {
            $Entity = $this->get__examClass($bag->get('exm_C__Ed'));
            if (!$Entity instanceof ExamsClasses) {
                $Entity = new ExamsClasses();
            }
        }

        ## get the exam reference
        $Exam = $this->get__exams($bag->get('ex__mRF'));
        if (!$Exam instanceof \App\Entity\Exams) {
            $response = $this->default_function->push_error($response, $Exam);
        }

        ## get subject reference
        $ClassSubject = $this->subject_service->get__ClassSubject($bag->get('exC__sbI'));
        if (!$ClassSubject instanceof ClassSubject) {
            $response = $this->default_function->push_error($response, 'Invalid subject reference');
            $response = $this->default_function->push_error($response, $ClassSubject);
        }

        ## get the class reference and save into the exam.
        $Classes = $this->student_classes->get_the_class($bag->get('exC__cLs'));
        if (!$Classes instanceof Classes) {
            $response = $this->default_function->push_error($response, 'Invalid class reference');
            $response = $this->default_function->push_error($response, $Classes);
        }

        ## checker
        if (!empty($bag->get('exC__ch'))) {
            $Checker = $this->user_service->get__user($bag->get('exC__ch'));
            if (!$Checker instanceof User) {
                $response = $this->default_function->push_error($response, $Checker);
            } else {
                $Entity->setExamChecker($Checker);
            }
        }

        ## if error, then send him back
        if (!empty($response)) {
            return $response;
        }

        try {
            ## save exam reference
            $Entity->setExam($Exam);
            ## save subject
            $Entity->setClassSubject($ClassSubject);
            ## exam date
            $Entity->setEcDate($this->default_function->convert_datetimeStringIntoObject($bag->get('ex__d')));
            ## exam start time
            $Entity->setExamStartTime($this->default_function->convert_datetimeStringIntoObject($bag->get('ex__St')));
            ## exam end time
            $Entity->setExamEndTime($this->default_function->convert_datetimeStringIntoObject($bag->get('ex__Et')));
            ## exam location
            $Entity->setExamLocation($bag->get('ex__Loc'));
            ## exams total marks
            $Entity->setExamTotalMarks((int)$bag->get('ex__tM'));
            ## exams passing marks.
            $Entity->setExamPassingMarks((int)$bag->get('ex__PM'));
            ## exam is held or not.
            $Entity->setExamHel($this->default_function->parse__boolean($bag->get('')));
            ## marks entered at
            $Entity->setExamMarksEnteredAt($this->default_function->convert_datetimeStringIntoObject($bag->get('')));
            ## add class reference
            $Entity->setClass($Classes);

            ## Save in the database
            $this->entity_manager->persist($Entity);
            $this->entity_manager->flush();

            ## Save the examiner
            if (!empty($bag->get('exaMner__teacher'))) {
                foreach ($bag->get('exaMner__teacher') as $Teacher) {

                    $ExaminerBag = new ParameterBag();
                    $ExaminerBag->set('exc_c_rf', $Entity->getId());
                    $ExaminerBag->set('exc__urf', $Teacher);
                    $examinerResponse = $this->save__examiner($ExaminerBag);

                    if ($examinerResponse <> 'OK') {
                        // if examiner is not saved then push an error.
                        $response = $this->default_function->push_error($response, $examinerResponse);
                    }
                }
            }


            ## place the students in the exam class table, which are enrolled in the selected class.
            ## add student to the exam class student.
            ## when we create exam class schedule then we select a class, when we do select it will put all student of that exams and place them to the exam class student
            ## They will remember this key
            $ExamClassStudentBag = new ParameterBag();
            $ExamClassStudentBag->set('ex_cS__Ed', $Entity->getId());
            $ExamClassStudentBag->set('exc_cs_obtM', -2);


            ## get the enrolled student in the selected class.
            $searchStudentEnrolmentBag = new ParameterBag();
            $searchStudentEnrolmentBag->set('ClassEnrolmentDeleted', 0);
            $searchStudentEnrolmentBag->set('class', $Entity->getClass()->getId());
            $searchStudentEnrolmentBag->set('subject', $Entity->getClassSubject()->getId());
            $searchStudentEnrolmentBag->set('ClassEnrolmentSubjectDeleted', 0);
            $studentEnrolments = $this->classSessionEnrolmentRepository->search($searchStudentEnrolmentBag);

            if (is_array($studentEnrolments)) {
                ## if found some students in the Class Enrolment
                foreach ($studentEnrolments as $key => $value) {
                    ## student ref
                    /** @var ClassSessionEnrolment $value */
                    $ExamClassStudentBag->set('exc_cs_s', $value->getUserId()->getId());
                    ## save them to the exam class student
                    $fe = $this->save__examsClassesStudent($ExamClassStudentBag);
                }
            }


            if (empty($response)) {
                $response = 'OK';
            }

            //$response = 'escape__fromErro_' . $Entity->getId() . '_af_d_f_____' . $this->environment->render( 'examination/_exams_schedule_list_view.html.twig', [ 'exams_schedule' => [ $Entity ], ] );
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }


    /**
     * Examiners
     * */

    ## validate examiners
    public function validate_examiner(ParameterBag $parameter_bag)
    {
        $response = [];
        ## exams class reference should not be null.
        if (empty($parameter_bag->get('exc_c_rf'))) {
            $response = $this->default_function->push_error($response, 'Please attach Class which exam want\'s to attach');
        }

        ## user reference should not be null
        if (empty($parameter_bag->get('exc__urf'))) {
            $response = $this->default_function->push_error($response, 'Invalidate examiner reference');
        }

        return $response;
    }

    ## get the examiner
    public function get__examiner(int $reference)
    {
        $response = 'Invalid examination reference';
        if (!empty($reference)) {
            try {
                $response = $this->examiners_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    ## save data in examiners
    public function save__examiner(ParameterBag $bag)
    {
        $response = [];

        ## validate examiners.
        if (!empty($validation_response = $this->validate_examiner($bag))) {
            return $validation_response;
        }


        ## decide what to do, edit or add record.
        if (empty($bag->get('exm___Ed'))) {
            $Entity = new Examiners();
        } else {
            $Entity = $this->get__examiner($bag->get('exm___Ed'));
            if (!$Entity instanceof Examiners) {
                $Entity = new Examiners();
            }
        }

        ## get user reference.
        $User = $this->user_service->get__user($bag->get('exc__urf'));
        if (!$User instanceof User) {
            $response = $this->default_function->push_error($response, $User);
        }

        ## get exam class reference
        $ExamClass = $this->get__examClass($bag->get('exc_c_rf'));
        if (!$ExamClass instanceof ExamsClasses) {
            $response = $this->default_function->push_error($response, $ExamClass);
        }

        ## if we've error then send error.
        if (!empty($response)) {
            return $response;
        }

        try {
            ## save name of examiner data
            $Entity->setUser($User);
            $Entity->setExamsClasses($ExamClass);
            $this->entity_manager->persist($Entity);
            $this->entity_manager->flush();
            $response = 'OK';
            //  $response = 'escape__fromErro_' . $Entity->getId() . '_af_d_f_____' . $this->environment->render('examination/_examiners_list_view.html.twig', ['examiners' => [$Entity],]);
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }


        return $response;
    }


    /**
     * Exams classes student - exams result sheet.
     * */

    ## validate exam class student
    public function validate_examsClassStudent(ParameterBag $parameter_bag)
    {
        $response = [];
        ## exams class reference should not be null.
        ## deprecated 08-oct-2019
        //		if ( empty( $parameter_bag->get( 'exc_cs_ex' ) ) ) {
        //			$response = $this->default_function->push_error( $response, 'Please attach Class which exam want\'s to attach' );
        //		}

        ## adding exams schedule reference.
//        if (empty($parameter_bag->get('exc_cs_exES'))) {
//            $response = $this->default_function->push_error($response, 'Exam reference is invalid');
//        }

        ## attached to the exam schedule.
        ## class - exam sheet of which class
//        if (empty($parameter_bag->get('exC__cLs'))) {
//            $response = $this->default_function->push_error($response, 'Please select class');
//        }

        ## subject - exam sheet of which subject
//        if (empty($parameter_bag->get('exc_cs_srf'))) {
//            $response = $this->default_function->push_error($response, 'Please select subject of which class it is.');
//        }


        if(empty($parameter_bag->get('ex_cS__Ed'))){
            $response = $this->default_function->push_error($response, 'Exam Class reference is missing');
        }

        ## obtain marks
        if (empty($parameter_bag->get('exc_cs_obtM'))) {
            $response = $this->default_function->push_error($response, 'Please type obtains marks by student');
        }

        ## please select student
        if (empty($parameter_bag->get('exc_cs_s'))) {
            $response = $this->default_function->push_error($response, 'Please select student');
        }

        return $response;
    }

    ## get the exam sheet
    public function get__examClassStudent(int $reference)
    {
        $response = 'Invalid exam sheet reference';
        if (!empty($reference)) {
            try {
                $response = $this->exams_classes_student_repository->find($reference);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    ## save data in exams
    public function save__examsClassesStudent(ParameterBag $bag)
    {
        $response = [];

        ## validate exams.
        if (!empty($validation_response = $this->validate_examsClassStudent($bag))) {
            return $validation_response;
        }


        ## get the ExamClass with the validation check
        $ExamClass = $this->get__examClass((int)$bag->get('ex_cS__Ed'));
        if (!$ExamClass instanceof ExamsClasses) {
            $response = $this->default_function->push_error($response, $ExamClass);
            $response = $this->default_function->push_error($response, 'Invalid exam name');
        } else if ($ExamClass->getExamTotalMarks() < $bag->get('exc_cs_obtM')) {
            $response = $this->default_function->push_error($response, 'Student cannot obtain marks greater than Total Marks');
        }

        if (!empty($response)) {
            return $response;
        }

        $Entity = null;
        ## decide what to do, edit or add record -- for now not usefull
        if (!empty($bag->get('ecs__ref'))) {
            $Entity = $this->get__examClassStudent((int)$bag->get('ecs__ref'));
        }

        ## duplication check  or get the examClassSubject with the reference of the exam_did_by_id and exams_classes_id
        $Entity = $this->exams_classes_student_repository->examClassDuplicationCheck((int)$bag->get('exc_cs_s'), (int)$bag->get('ex_cS__Ed'));
        $Entity = !empty($Entity[0]) ? $Entity[0] : null;

        if (!$Entity instanceof ExamsClassesStudent) {
            $Entity = new ExamsClassesStudent();
        }

        ## get user
        $User = $this->user_service->get__user($bag->get('exc_cs_s'));
        if (!$User instanceof User) {
            $response = $this->default_function->push_error($response, $User);
            $response = $this->default_function->push_error($response, 'Invalid user reference');
        }

        ## get exam reference.
        ## deprecated 08-oct-2019
        //		$Exam = $this->get__exams( $bag->get( 'exc_cs_ex' ) );
        //		if ( ! $Exam instanceof Exams ) {
        //			$response = $this->default_function->push_error( $response, $Exam );
        //		}

        ## get subject reference.
        //		$classSubject = $this->subject_service->get__ClassSubject( $bag->get( 'exc_cs_srf' ) );
        //		if ( ! $classSubject instanceof ClassSubject ) {
        //			$response = $this->default_function->push_error( $response, $classSubject );
        //			$response = $this->default_function->push_error( $response, 'Invalid Class subject' );
        //		}

        ## get Class
        ## get the class reference and save into the exam.
        //		$Classes = $this->student_classes->get_the_class( $bag->get( 'exC__cLs' ) );
        //		if ( ! $Classes instanceof Classes ) {
        //			$response = $this->default_function->push_error( $response, 'Invalid class reference' );
        //			$response = $this->default_function->push_error( $response, $Classes );
        //		}

        if (!empty($response)) {
            return $response;
        }

        try {

            ## deprecated 08-oct-2019
            //$Entity->setSubject( $Subject );

            $Entity->setExamDidBy($User);
            $Entity->setRemarks($bag->get('exc_cs_rMks'));
            $Entity->setEcsGainMarks($bag->get('exc_cs_obtM'));
            $Entity->setExamsClasses($ExamClass);

            ## deprecated 08-oct-2019
            //$Entity->setClasses( $Classes );
            //$Entity->setExamsClasses()

            $this->entity_manager->persist($Entity);
            $this->entity_manager->flush();
            //$response = 'escape__fromErro_' . $Entity->getId() . '_af_d_f_____' . $this->environment->render('examination/_marks_exams_list_view.html.twig', ['examsMarkingResult' => [$Entity],]);
            $response = 'OK';
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }


        return $response;
    }

    ## bulk exam class student
    public function save__bulkExamClassesStudent(ParameterBag $bag)
    {
        $response = [];

        if (is_array($bag->get('stR'))) {
            for ($variable = 0; $variable < count($bag->get('stR')); $variable++) {
                    $bag->set('exc_cs_s', !empty($bag->get('stR')[$variable]) ? $bag->get('stR')[$variable] : 0);
                    $bag->set('ecs__ref', !empty($bag->get('ecs__ref__')[$variable]) ? $bag->get('ecs__ref__')[$variable] : 0);
                    $bag->set('exc_cs_obtM', !empty($bag->get('mObt')[$variable]) ? $bag->get('mObt')[$variable] : -2);
                    $response = $this->default_function->push_error($response, $this->save__examsClassesStudent($bag));
            }

            $response = $this->default_function->purify_success_error_response_in_bulk_operation($response);
        }

        return $response;
    }


}