<?php

namespace App\Repository;

use App\Entity\TAnswerRegardingCF;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method TAnswerRegardingCF|null find( $id, $lockMode = null, $lockVersion = null )
 * @method TAnswerRegardingCF|null findOneBy( array $criteria, array $orderBy = null )
 * @method TAnswerRegardingCF[]    findAll()
 * @method TAnswerRegardingCF[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class TAnswerRegardingCFRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, TAnswerRegardingCF::class );
	}

	/**
	 * @param $fieldId
	 * @param $userId
	 *
	 * This method is used to get the specific field answer based on the speciftc user.
	 *
	 * @return mixed
	 */
	public function getTheFieldAnswer( $fieldId, $userId ) {
		try {
			return $this->createQueryBuilder( 'sanswers_regarding_cf' )
			            ->leftJoin( 'sanswers_regarding_cf.CustomFields', 'custom_fields' )
			            ->leftJoin( 'sanswers_regarding_cf.User', 'user' )
			            ->andWhere( 'user.id = :userId' )
			            ->andWhere( 'custom_fields.id = :fieldId' )
			            ->setParameter( 'fieldId', $fieldId )
			            ->setParameter( 'userId', $userId )
			            ->getQuery()
			            ->getSingleResult();
		} catch ( \Exception $exception ) {
			return $exception->getMessage();
		}
	}

	// /**
	//  * @return TAnswerRegardingCF[] Returns an array of TAnswerRegardingCF objects
	//  */
	/*
	public function findByExampleField($value)
	{
		return $this->createQueryBuilder('t')
			->andWhere('t.exampleField = :val')
			->setParameter('val', $value)
			->orderBy('t.id', 'ASC')
			->setMaxResults(10)
			->getQuery()
			->getResult()
		;
	}
	*/

	/*
	public function findOneBySomeField($value): ?TAnswerRegardingCF
	{
		return $this->createQueryBuilder('t')
			->andWhere('t.exampleField = :val')
			->setParameter('val', $value)
			->getQuery()
			->getOneOrNullResult()
		;
	}
	*/
}
