<?php

namespace App\Repository;

use App\Entity\StudentFee;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method StudentFee|null find($id, $lockMode = null, $lockVersion = null)
 * @method StudentFee|null findOneBy(array $criteria, array $orderBy = null)
 * @method StudentFee[]    findAll()
 * @method StudentFee[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class StudentFeeRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, StudentFee::class);
    }


    ## Duplication check
    public function duplicationCheck(ParameterBag $bag)
    {
        ## query Builder
        $queryBuilder = $this->createQueryBuilder('student_fee');

        if (!empty($bag->get('name'))) {
            $queryBuilder->andWhere('student_fee.name = :name')->setParameter('name', $bag->get('name'));
        }

        if (!empty($bag->get('whereNotIn'))) {
            $queryBuilder->andWhere('student_fee.id <> :notCheck')->setParameter('notCheck', $bag->get('whereNotIn'));
        }

        $queryBuilder->andWhere('student_fee.is_deleted = false');

        return $queryBuilder->getQuery()->getResult();

    }

    ## find all non deleted records
    public function findAllNonDeleted()
    {
        return $this->createQueryBuilder('subject_fee')->where('subject_fee.is_deleted = false')->getQuery()->getResult();
    }

}
