<?php

namespace App\Repository;

use App\Entity\ExamsClassesStudent;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method ExamsClassesStudent|null find($id, $lockMode = null, $lockVersion = null)
 * @method ExamsClassesStudent|null findOneBy(array $criteria, array $orderBy = null)
 * @method ExamsClassesStudent[]    findAll()
 * @method ExamsClassesStudent[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ExamsClassesStudentRepository extends ServiceEntityRepository
{

    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ExamsClassesStudent::class);
    }

    ## get student based exams results.
    public function getStudentBasedExamReport(int $studentReference)
    {
        return $this->createQueryBuilder('exams_classes_student')## get the exams details.
        ->leftJoin('exams_classes_student.exam', 'exam')
            ->addSelect('exam')## getting the exam schedule due to the need of total marks and passing marks.
            ->leftJoin('exam.examsClasses', 'examsClasses')
            ->addSelect('examsClasses')
            ->where('exams_classes_student.exam_did_by = :student')
            ->setParameter('student', $studentReference)
            ->getQuery()
            ->getResult();
    }

    public function advanceSearch(ParameterBag $bag)
    {

        $queryBuilder = $this->createQueryBuilder('examsClassStudent')->leftJoin(
            'examsClassStudent.exams_classes',
            'exams_classes'
        );

        if ($bag->get('userArray')) {
            $queryBuilder->add(
                'where',
                $queryBuilder->expr()->in('examsClassStudent.exam_did_by', $bag->get('userArray'))
            );
        }


        ## search on the base of single user
        if (!empty($bag->get('student__based'))) {
            $queryBuilder->andWhere('examsClassStudent.exam_did_by = :studentRef')->setParameter(
                'studentRef',
                $bag->get('student__based')
            );
        }

        ## attendance  from - to time.
        if (!empty($bag->get('exam_markingDate'))) {
            ## Convert string into an array
            $examDate = explode(' / ', $bag->get('exam_markingDate'));


            ## if array is created and duration date is exits then search in database
            if (is_array($examDate) && !empty($examDate[0] && !empty($examDate[1]))) {
                ## InTime Search
                ## used in the duration
                $queryBuilder->andWhere('exams_classes.ec_date BETWEEN :attendanceFrom and :attendanceTo');
                $queryBuilder->setParameter('attendanceFrom', date('Y-m-d', strtotime(trim($examDate[0]))).'%');
                $queryBuilder->setParameter('attendanceTo', date('Y-m-d', strtotime(trim($examDate[1]))).'%');

            } else {
                if (is_array($examDate) && !empty($examDate[0] && empty($examDate[1]))) {
                    ## for only single date
                    $queryBuilder->where('attendance.ec_date like :attendanceMarkingDate');
                    $queryBuilder->setParameter(
                        'attendanceMarkingDate',
                        date('Y-m-d', strtotime(trim($examDate[0]))).'%'
                    );
                }
            }
        }

        ## return the result.
        return $queryBuilder->getQuery()->getResult();
    }

    ## duplication check
    public function examClassDuplicationCheck(int $examDidBy, int $examClassID)
    {
        return $this->createQueryBuilder('examsClassStudent')
            ->andWhere('examsClassStudent.exam_did_by = :examsDidByRef')
            ->andWhere('examsClassStudent.exams_classes = :examsClassRef')
            ->setParameter('examsDidByRef', $examDidBy)
            ->setParameter('examsClassRef', $examClassID)
            ->getQuery()->getResult();

    }
}
