<?php


namespace App\Service\PrintService;


use App\Service\Constants;
use App\Service\FileManagment;
use Knp\Snappy\Pdf;
use Symfony\Component\HttpFoundation\ParameterBag;
use Twig\Environment;
use Knp\Bundle\SnappyBundle\Snappy\Response\PdfResponse;


class PrintService
{

    /**
     * @var Environment
     */
    private $environment;
    /**
     * @var Pdf
     */
    private $pdf;
    /**
     * @var FileManagment
     */
    private $fileManagment;

    public function __construct(Environment $environment, Pdf $pdf, FileManagment $fileManagment)
    {
        $this->environment = $environment;
        $this->pdf = $pdf;
        $this->fileManagment = $fileManagment;
    }


    /*
     *
     *   return new Response(
            $this->get('knp_snappy.pdf')->getOutputFromHtml($html, array(
                'orientation' => 'landscape',
                'enable-javascript' => true,
                'javascript-delay' => 1000,
                'no-stop-slow-scripts' => true,
                'no-background' => false,~
                'lowquality' => false,
                'encoding' => 'utf-8',
                'images' => true,
                'cookie' => array(),
                'dpi' => 300,
                'image-dpi' => 300,
                'enable-external-links' => true,
                'enable-internal-links' => true
            )),
            200,
            array(
                'Content-Type'          => 'application/pdf',
                'Content-Disposition'   => 'attachment; filename="report.pdf"'
            )
        );
     *
     * */


    ## Print document.
    public function outPutManager(ParameterBag $bag)
    {
        $template = $bag->get('templateFile');
        $parameters = $bag->get('templateArguments');

        ## make directory if not exits.
        $this->fileManagment->make_directory($bag->get('destinationDir'));

        $destinationFile = $bag->get('destinationDir') . DIRECTORY_SEPARATOR . date('Y-M-D') . '-' . time() . '.pdf';

        ## if requested to print the document
        //$pageHtml = $this->environment->renderView($template, (array)$parameters);
        //dump($pageHtml);
        $pageHtml = $this->pdf->getOutputFromHtml('<h1>Hello ncie once </h1>');
        //return new PdfResponse($pageHtml, $destinationFile);
    }

}