<?php

namespace App\Repository;

use App\Entity\Tokens;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method Tokens|null find($id, $lockMode = null, $lockVersion = null)
 * @method Tokens|null findOneBy(array $criteria, array $orderBy = null)
 * @method Tokens[]    findAll()
 * @method Tokens[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TokensRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, Tokens::class);
    }


    /**
     * @param ParameterBag $bag
     * @return mixed
     */
    public function search(ParameterBag $bag)
    {
        $query = $this->createQueryBuilder('tokens');

        ## token name
        if (!empty($bag->get('token'))) {
            $query->where('tokens.token_name = :tokenD')->setParameter('tokenD', $bag->get('token'));
        }

        ## user reference
        if (!empty($bag->get('user'))) {
            $query->where('tokens.user = :userId')->setParameter('userId', $bag->get('user'));
        }

        ## guardian ref
        if (!empty($bag->get('guardian'))) {
            $query->where('tokens.guardian = :guardianId')->setParameter('guardianId', $bag->get('guardian'));
        }


        return $query->getQuery()->getResult();
    }
}
