<?php

namespace App\Repository;

use App\Entity\ClassGrade;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method ClassGrade|null find($id, $lockMode = null, $lockVersion = null)
 * @method ClassGrade|null findOneBy(array $criteria, array $orderBy = null)
 * @method ClassGrade[]    findAll()
 * @method ClassGrade[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ClassGradeRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, ClassGrade::class);
    }

    /**
     * @param int|null $classGradeId
     * @param $gradeName
     * @param $gradeMarks
     * @return bool
     */
    public function gradeCategoryGradeNameGradeMarksDuplicationCheck(
        ?int $classGradeId,
        $gradeName,
        $gradeMarks
    ) {
        $queryResult = $this->createQueryBuilder('class_grade')->leftJoin(
            'class_grade.class',
            'class'
        )->where('class.id = :classId')->setParameter(
            'classId',
            $classGradeId
        )->andWhere(
            'class_grade.class_grade_name = :gradeName'
        )->setParameter('gradeName', $gradeName)->andWhere('class_grade.class_marks_equal_or_greater_than = :marks')
            ->setParameter(
                'marks',
                $gradeMarks
            )->getQuery()->getResult();

        $response = false;
        if (count($queryResult)) {
            $response = true;
        }

        return $response;
    }


    ## delete all grade based on the Class
    public function deleteGradeOnBaseOfClass(int $classId)
    {
        return $this->createQueryBuilder('class_grade')->delete()->where('class_grade.class = :classId')->setParameter(
            'classId',
            $classId
        )->getQuery()->getResult();
    }

    ## get the list of all grades.
    public function getGradesList(\Symfony\Component\HttpFoundation\ParameterBag $bag = null)
    {
        $queryBuilder = $this->createQueryBuilder('class_grade');
        $queryBuilder->leftJoin('class_grade.class', 'class')->addSelect('class');
        $queryBuilder->leftJoin('class.session', 'session')->addSelect('session');
        $queryBuilder->leftJoin('class_grade.student_grade_category', 'studentGradeCategory')->addSelect(
            'studentGradeCategory'
        );

        if ($bag instanceof ParameterBag) {
            if ($bag->get('session')) {
                $queryBuilder->andWhere('session.id = :session')->setParameter('session', $bag->get('session'));
            }
            if ($bag->get('class')) {
                $queryBuilder->andWhere('class.id = :class')->setParameter('class', $bag->get('class'));
            }
        }

        return $queryBuilder->getQuery()->getResult();
    }
}
