<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassSessionEnrolmentRepository")
 */
class ClassSessionEnrolment
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $fee;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $notes;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="classSessionEnrolments")
     */
    private $user_id;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="classSessionEnrolments")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class_session;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSessionEnrolmentSubjects", mappedBy="class_session_entrolment",
     *                                                                         orphanRemoval=true)
     */
    private $classSessionEnrolmentSubjects;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Attendance", mappedBy="class_session_enrolment")
     */
    private $attendances;

    /**
     * @ORM\Column(type="smallint")
     */
    private $attendance_type;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSessionEnrolmentFeeSchedule", mappedBy="class_session_enrolment")
     */
    private $classSessionEnrolmentFeeSchedules;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Invoices", mappedBy="class_session_enrolment")
     */
    private $invoices;

    public function __construct()
    {
        $this->classSessionEnrolmentSubjects = new ArrayCollection();
        $this->attendances = new ArrayCollection();
        $this->classSessionEnrolmentFeeSchedules = new ArrayCollection();
        $this->invoices = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFee(): ?float
    {
        return $this->fee;
    }

    public function setFee(?float $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    public function getNotes(): ?string
    {
        return $this->notes;
    }

    public function setNotes(?string $notes): self
    {
        $this->notes = $notes;

        return $this;
    }

    public function getUserId(): ?User
    {
        return $this->user_id;
    }

    public function setUserId(?User $user_id): self
    {
        $this->user_id = $user_id;

        return $this;
    }

    public function getClassSession(): ?Classes
    {
        return $this->class_session;
    }

    public function setClassSession(?Classes $class_session): self
    {
        $this->class_session = $class_session;

        return $this;
    }

    /**
     * @return Collection|ClassSessionEnrolmentSubjects[]
     */
    public function getClassSessionEnrolmentSubjects(): Collection
    {
        return $this->classSessionEnrolmentSubjects;
    }

    public function addClassSessionEnrolmentSubject(ClassSessionEnrolmentSubjects $classSessionEnrolmentSubject): self
    {
        if (!$this->classSessionEnrolmentSubjects->contains($classSessionEnrolmentSubject)) {
            $this->classSessionEnrolmentSubjects[] = $classSessionEnrolmentSubject;
            $classSessionEnrolmentSubject->setClassSessionEntrolment($this);
        }

        return $this;
    }

    public function removeClassSessionEnrolmentSubject(ClassSessionEnrolmentSubjects $classSessionEnrolmentSubject): self
    {
        if ($this->classSessionEnrolmentSubjects->contains($classSessionEnrolmentSubject)) {
            $this->classSessionEnrolmentSubjects->removeElement($classSessionEnrolmentSubject);
            // set the owning side to null (unless already changed)
            if ($classSessionEnrolmentSubject->getClassSessionEntrolment() === $this) {
                $classSessionEnrolmentSubject->setClassSessionEntrolment(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Attendance[]
     */
    public function getAttendances(): Collection
    {
        return $this->attendances;
    }

    public function addAttendance(Attendance $attendance): self
    {
        if (!$this->attendances->contains($attendance)) {
            $this->attendances[] = $attendance;
            $attendance->setClassSessionEnrolment($this);
        }

        return $this;
    }

    public function removeAttendance(Attendance $attendance): self
    {
        if ($this->attendances->contains($attendance)) {
            $this->attendances->removeElement($attendance);
            // set the owning side to null (unless already changed)
            if ($attendance->getClassSessionEnrolment() === $this) {
                $attendance->setClassSessionEnrolment(null);
            }
        }

        return $this;
    }

    public function getAttendanceType(): ?int
    {
        return $this->attendance_type;
    }

    public function setAttendanceType(int $attendance_type): self
    {
        $this->attendance_type = $attendance_type;

        return $this;
    }

    /**
     * @return Collection|ClassSessionEnrolmentFeeSchedule[]
     */
    public function getClassSessionEnrolmentFeeSchedules(): Collection
    {
        return $this->classSessionEnrolmentFeeSchedules;
    }

    public function addClassSessionEnrolmentFeeSchedule(ClassSessionEnrolmentFeeSchedule $classSessionEnrolmentFeeSchedule): self
    {
        if (!$this->classSessionEnrolmentFeeSchedules->contains($classSessionEnrolmentFeeSchedule)) {
            $this->classSessionEnrolmentFeeSchedules[] = $classSessionEnrolmentFeeSchedule;
            $classSessionEnrolmentFeeSchedule->setClassSessionEnrolment($this);
        }

        return $this;
    }

    public function removeClassSessionEnrolmentFeeSchedule(ClassSessionEnrolmentFeeSchedule $classSessionEnrolmentFeeSchedule): self
    {
        if ($this->classSessionEnrolmentFeeSchedules->contains($classSessionEnrolmentFeeSchedule)) {
            $this->classSessionEnrolmentFeeSchedules->removeElement($classSessionEnrolmentFeeSchedule);
            // set the owning side to null (unless already changed)
            if ($classSessionEnrolmentFeeSchedule->getClassSessionEnrolment() === $this) {
                $classSessionEnrolmentFeeSchedule->setClassSessionEnrolment(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    /**
     * @return Collection|Invoices[]
     */
    public function getInvoices(): Collection
    {
        return $this->invoices;
    }

    public function addInvoice(Invoices $invoice): self
    {
        if (!$this->invoices->contains($invoice)) {
            $this->invoices[] = $invoice;
            $invoice->setClassSessionEnrolment($this);
        }

        return $this;
    }

    public function removeInvoice(Invoices $invoice): self
    {
        if ($this->invoices->contains($invoice)) {
            $this->invoices->removeElement($invoice);
            // set the owning side to null (unless already changed)
            if ($invoice->getClassSessionEnrolment() === $this) {
                $invoice->setClassSessionEnrolment(null);
            }
        }

        return $this;
    }
}
