<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\Timestampable;
use Symfony\Component\Validator\Constraints as Assert;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Entity(repositoryClass="App\Repository\TokensRepository")
 */
class Tokens
{
    use Timestampable;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     */
    private $token_name;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_used = 0;

    /**
     * @ORM\Column(type="datetime")
     * @Gedmo\Timestampable(on="create")
     */
    private $created_at;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     */
    private $expire_at;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $generation_event;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="tokens")
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Guardian", inversedBy="tokens")
     */
    private $guardian;

    public function __construct()
    {
        if (empty($this->token_name)) {
            try {
                $this->token_name = bin2hex(random_bytes(60));
            } catch (\Exception $e) {
                $this->token_name = hash(getenv('APP_SECRET'), getenv('APP_ENV'));
            }
        }
        if (empty($this->expire_at)) {
            $this->expire_at = new \DateTime('+5 hours');
        }
        if (empty($this->generation_event)) {
            $this->generation_event = 'apiAuth';
        }
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTokenName(): ?string
    {
        return $this->token_name;
    }

    public function setTokenName(string $token_name): self
    {
        $this->token_name = $token_name;

        return $this;
    }

    public function getIsUsed(): ?bool
    {
        return $this->is_used;
    }

    public function setIsUsed(bool $is_used): self
    {
        $this->is_used = $is_used;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeInterface
    {
        return $this->created_at;
    }

    public function setCreatedAt(\DateTimeInterface $created_at): self
    {
        $this->created_at = $created_at;

        return $this;
    }

    public function getExpireAt(): ?\DateTimeInterface
    {
        return $this->expire_at;
    }

    public function setExpireAt(?\DateTimeInterface $expire_at): self
    {
        $this->expire_at = $expire_at;

        return $this;
    }

    public function getGenerationEvent(): ?string
    {
        return $this->generation_event;
    }

    public function setGenerationEvent(string $generation_event): self
    {
        $this->generation_event = $generation_event;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getGuardian(): ?Guardian
    {
        return $this->guardian;
    }

    public function setGuardian(?Guardian $guardian): self
    {
        $this->guardian = $guardian;

        return $this;
    }
}
