<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\SAnswersRegardingCFRepository")
 */
class SAnswersRegardingCF {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\CustomFields", inversedBy="sAnswersRegardingCFs")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $CustomFields;

	/**
	 * @ORM\Column(type="string", length=200)
	 */
	private $answers;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="sAnswersRegardingCFs")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $User;


	public function getId(): ?int {
		return $this->id;
	}

	public function getCustomFields(): ?CustomFields {
		return $this->CustomFields;
	}

	public function setCustomFields( ?CustomFields $CustomFields ): self {
		$this->CustomFields = $CustomFields;

		return $this;
	}

	public function getAnswers(): ?string {
		return $this->answers;
	}

	public function setAnswers( string $answers ): self {
		$this->answers = $answers;

		return $this;
	}

	public function getUser(): ?User {
		return $this->User;
	}

	public function setUser( ?User $User ): self {
		$this->User = $User;

		return $this;
	}
}
