<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InventoryCategoryRepository")
 */
class InventoryCategory
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=50)
     */
    private $invt_cat_name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $invt_cat_notes;

    /**
     * @ORM\Column(type="string", length=10, nullable=true)
     */
    private $invt_cat_code;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InventoryStock", mappedBy="invt_cat")
     */
    private $inventoryStocks;

    public function __construct()
    {
        $this->inventoryStocks = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getInvtCatName(): ?string
    {
        return $this->invt_cat_name;
    }

    public function setInvtCatName(string $invt_cat_name): self
    {
        $this->invt_cat_name = $invt_cat_name;

        return $this;
    }

    public function getInvtCatNotes(): ?string
    {
        return $this->invt_cat_notes;
    }

    public function setInvtCatNotes(?string $invt_cat_notes): self
    {
        $this->invt_cat_notes = $invt_cat_notes;

        return $this;
    }

    public function getInvtCatCode(): ?string
    {
        return $this->invt_cat_code;
    }

    public function setInvtCatCode(?string $invt_cat_code): self
    {
        $this->invt_cat_code = $invt_cat_code;

        return $this;
    }

    /**
     * @return Collection|InventoryStock[]
     */
    public function getInventoryStocks(): Collection
    {
        return $this->inventoryStocks;
    }

    public function addInventoryStock(InventoryStock $inventoryStock): self
    {
        if (!$this->inventoryStocks->contains($inventoryStock)) {
            $this->inventoryStocks[] = $inventoryStock;
            $inventoryStock->setInvtCat($this);
        }

        return $this;
    }

    public function removeInventoryStock(InventoryStock $inventoryStock): self
    {
        if ($this->inventoryStocks->contains($inventoryStock)) {
            $this->inventoryStocks->removeElement($inventoryStock);
            // set the owning side to null (unless already changed)
            if ($inventoryStock->getInvtCat() === $this) {
                $inventoryStock->setInvtCat(null);
            }
        }

        return $this;
    }
}
