<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\GradeCategoriesRepository")
 */
class GradeCategories
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $grade_category_name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $grade_category_desc;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\StudentGrades", mappedBy="student_grade_category")
     */
    private $studentGrades;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassGradeTemplate", mappedBy="student_grade_category")
     */
    private $classGradeTemplates;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassGrade", mappedBy="student_grade_category")
     */
    private $classGrades;

    public function __construct()
    {
        $this->studentGrades = new ArrayCollection();
        $this->classGradeTemplates = new ArrayCollection();
        $this->classGrades = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getGradeCategoryName(): ?string
    {
        return $this->grade_category_name;
    }

    public function setGradeCategoryName(string $grade_category_name): self
    {
        $this->grade_category_name = $grade_category_name;

        return $this;
    }

    public function getGradeCategoryDesc(): ?string
    {
        return $this->grade_category_desc;
    }

    public function setGradeCategoryDesc(?string $grade_category_desc): self
    {
        $this->grade_category_desc = $grade_category_desc;

        return $this;
    }

    /**
     * @return Collection|StudentGrades[]
     */
    public function getStudentGrades(): Collection
    {
        return $this->studentGrades;
    }

    public function addStudentGrade(StudentGrades $studentGrade): self
    {
        if (!$this->studentGrades->contains($studentGrade)) {
            $this->studentGrades[] = $studentGrade;
            $studentGrade->setStudentGradeCategory($this);
        }

        return $this;
    }

    public function removeStudentGrade(StudentGrades $studentGrade): self
    {
        if ($this->studentGrades->contains($studentGrade)) {
            $this->studentGrades->removeElement($studentGrade);
            // set the owning side to null (unless already changed)
            if ($studentGrade->getStudentGradeCategory() === $this) {
                $studentGrade->setStudentGradeCategory(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassGradeTemplate[]
     */
    public function getClassGradeTemplates(): Collection
    {
        return $this->classGradeTemplates;
    }

    public function addClassGradeTemplate(ClassGradeTemplate $classGradeTemplate): self
    {
        if (!$this->classGradeTemplates->contains($classGradeTemplate)) {
            $this->classGradeTemplates[] = $classGradeTemplate;
            $classGradeTemplate->setStudentGradeCategory($this);
        }

        return $this;
    }

    public function removeClassGradeTemplate(ClassGradeTemplate $classGradeTemplate): self
    {
        if ($this->classGradeTemplates->contains($classGradeTemplate)) {
            $this->classGradeTemplates->removeElement($classGradeTemplate);
            // set the owning side to null (unless already changed)
            if ($classGradeTemplate->getStudentGradeCategory() === $this) {
                $classGradeTemplate->setStudentGradeCategory(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassGrade[]
     */
    public function getClassGrades(): Collection
    {
        return $this->classGrades;
    }

    public function addClassGrade(ClassGrade $classGrade): self
    {
        if (!$this->classGrades->contains($classGrade)) {
            $this->classGrades[] = $classGrade;
            $classGrade->setStudentGradeCategory($this);
        }

        return $this;
    }

    public function removeClassGrade(ClassGrade $classGrade): self
    {
        if ($this->classGrades->contains($classGrade)) {
            $this->classGrades->removeElement($classGrade);
            // set the owning side to null (unless already changed)
            if ($classGrade->getStudentGradeCategory() === $this) {
                $classGrade->setStudentGradeCategory(null);
            }
        }

        return $this;
    }
}
