<?php


namespace App\Service\Teacher;


use App\Entity\AllocateTeacherToClassAndSubjects;
use App\Entity\Classes;
use App\Entity\ClassSubject;
use App\Entity\Subjects;
use App\Entity\User;
use App\Repository\AllocateTeacherToClassAndSubjectsRepository;
use App\Service\AppSettings;
use App\Service\DefaultFunction;
use App\Service\UserService;
use Doctrine\ORM\EntityManagerInterface;
use mysql_xdevapi\Exception;
use Symfony\Component\HttpFoundation\ParameterBag;

class teacherAllocationService
{

    /**
     * @var DefaultFunction
     */
    private $defaultFunction;
    /**
     * @var AllocateTeacherToClassAndSubjectsRepository
     */
    private $allocateTeacherToClassAndSubjectsRepository;
    /**
     * @var UserService
     */
    private $userService;
    /**
     * @var EntityManagerInterface
     */
    private $entityManager;
    /**
     * @var AppSettings
     */
    private $appSettings;

    public function __construct(
        DefaultFunction $defaultFunction,
        AllocateTeacherToClassAndSubjectsRepository $allocateTeacherToClassAndSubjectsRepository,
        UserService $userService,
        EntityManagerInterface $entityManager,
        AppSettings $appSettings
    ) {
        $this->defaultFunction = $defaultFunction;
        $this->allocateTeacherToClassAndSubjectsRepository = $allocateTeacherToClassAndSubjectsRepository;
        $this->userService = $userService;
        $this->entityManager = $entityManager;
        $this->appSettings = $appSettings;
    }


    /**
     * Common Functions
     * */

    /**
     * @param int|null $teacherAllocationNumber
     * @param null $key
     * @param null $value
     *
     * @return AllocateTeacherToClassAndSubjects|AllocateTeacherToClassAndSubjects[]|string|null
     * PURPOSE: Get the teacher from the database
     */

    public function get_teacher_allocation(int $teacherAllocationNumber = null, $key = null, $value = null)
    {
        $response = null;
        try {
            if (!empty($teacherAllocationNumber)) {
                $response = $this->allocateTeacherToClassAndSubjectsRepository->find($teacherAllocationNumber);
            } else {
                if (!empty($key) && !empty($value)) {
                    $response = $this->allocateTeacherToClassAndSubjectsRepository->findBy([$key => $value]);
                }
            }
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }

    ## Purpose remove teacher allocation
    public function delete_teacher_from_allocation(int $teacherAllocationNumber, $markAsDelete = true)
    {
        $response = $allocatedTeacher = $this->get_teacher_allocation($teacherAllocationNumber);
        if ($allocatedTeacher instanceof AllocateTeacherToClassAndSubjects) {
            if ($markAsDelete) {
                $allocatedTeacher->setIsDeleted(true);
                $this->entityManager->persist($allocatedTeacher);
                $this->entityManager->flush();
                $response = 'OK';
            }
        }

        return $response;
    }

    ## update teacher
    public function updateTeacherAllocation(ParameterBag $bag)
    {
        $Entity = null;
        ## found the teacher in the database
        if (!empty($bag->get('alloC__ref'))) {
            $Entity = $this->get_teacher_allocation($bag->get('alloC__ref'));
        }

        ## if not found then thrown an exception
        if (!$Entity instanceof AllocateTeacherToClassAndSubjects) {
            return 'Teacher is not found in the database';
        }

        try {

            ## convert set assigned date to
            if (!empty($bag->get('setAssignedTo'))) {
                $Entity->setAssignToDate(
                    $this->defaultFunction->convert_datetimeStringIntoObject($bag->get('setAssignedTo'))
                );
            }

            ## convert set assigned date from
            if (!empty($bag->get('setAssignedFrom'))) {
                $Entity->setAssignFromDate(
                    $this->defaultFunction->convert_datetimeStringIntoObject($bag->get('setAssignedFrom'))
                );
            }

            ## save changes in the database
            $this->entityManager->persist($Entity);
            $this->entityManager->flush();

            $response = 'OK';
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }

    ## get teachers list from student ref
    public function getTeacherFromStudentRef(array $studentList)
    {
        $returnAr = [];
        foreach ($studentList as $key => $value) {
            if ($value instanceof User) {
                foreach ($value->getClassSessionEnrolments()->toArray() as $key2 => $value2) {
                    /** @var Classes $Classes */
                    $Classes = $value2->getClassSession();
                    /** @var AllocateTeacherToClassAndSubjects $value3 */
                    foreach ($Classes->getAllocateTeacherToClassAndSubjects()->toArray() as $key3 => $value3) {
                        $returnAr[$value3->getTeacher()->getId()] = $value3->getTeacher();
                    }
                }
            }
        }

        return $returnAr;
    }


    /**
     *  Assign teacher to the Class Room
     * */

    public function assign_teacher_to_Class_validationCheck(ParameterBag $bag)
    {
        $response = [];
        if (empty($bag->get('teacher'))) {
            $response = $this->defaultFunction->push_error($response, 'Teacher is missing');
        }

        return $response;
    }

    ## assign teacher to the Class
    public function assign_teacher_to_Class(ParameterBag $bag, Classes $classes = null)
    {
        $response = [];
        ## if error came up then return back with the message
        if (!empty($validationResponse = $this->assign_teacher_to_Class_validationCheck($bag))) {
            return $validationResponse;
        }

        ## duplication check
        $Entity = null;
        try {
            /**@var AllocateTeacherToClassAndSubjects $Entity */
            $Entity = $this->allocateTeacherToClassAndSubjectsRepository->duplicationCheck(
                $bag->get('teacher'),
                $classes->getId(),
                null
            );
            if ($Entity instanceof AllocateTeacherToClassAndSubjects && $Entity->getIsDeleted() === true) {
                $Entity->setIsDeleted(false);
            }

        } catch (\Exception $exception) {
            $Entity = null;
        }

        if (!$Entity instanceof AllocateTeacherToClassAndSubjects) {
            if (!empty($bag->get('alloC__ref'))) {
                $Entity = $this->get_teacher_allocation($bag->get('alloC__ref'));
            }

            if (!$Entity instanceof AllocateTeacherToClassAndSubjects) {
                $Entity = new AllocateTeacherToClassAndSubjects();
            }
        }
        ## get the teacher assign
        $this->get_teacher_allocation($bag->get('teacher'));
        $bag__ = new ParameterBag();
        $bag__->set('id', $bag->get('teacher'));
        $Teacher = $this->userService->pre__userCheck($bag__);
        if (!$Teacher instanceof User) {
            $response = $this->defaultFunction->push_error(
                $response,
                'Teacher is valid and active member of the School'
            );
            $response = $this->defaultFunction->push_error($response, $Teacher);
        }

        if (!empty($response)) {
            return $response;
        }

        try {
            $Entity->setAssignFromDate($this->defaultFunction->convert_datetimeStringIntoObject(null));
            $Entity->setAssignToDate($this->defaultFunction->convert_datetimeStringIntoObject(null));
            $Entity->setClass($classes);
            $Entity->setTeacher($Teacher);
            $this->entityManager->persist($Entity);
            $this->entityManager->flush();

            $response = 'OK';
        } catch (\Exception $exception) {
            $response = $this->defaultFunction->push_error($response, $exception->getMessage());
        }

        return $response;

    }

    ## assign bulk teachers to the Class
    public function bulk_assign_teacher_to_class(ParameterBag $bag, Classes $classes = null)
    {
        $response = [];
        for ($x = 0; count($bag->get('teacherList')) > $x; $x++) {
            if (!empty($bag->get('teacherList')[$x])) {
                $bag__ = new ParameterBag();
                $bag__->set('teacher', $bag->get('teacherList')[$x]);
                $response = $this->assign_teacher_to_Class($bag__, $classes);
            }
        }
        $response = $this->defaultFunction->purify_success_error_response_in_bulk_operation($response);

        return $response;
    }

    /**
     * Assign teacher to the Subject
     * */

    public function assign_teacher_to_subjectValidationCheck(ParameterBag $bag)
    {
        $response = [];
        if (empty($bag->get('teacher'))) {
            $response = $this->defaultFunction->push_error($response, 'Teacher is missing');
        }

        return $response;
    }

    ## assign teacher to the subject
    public function assign_teacher_to_subject(ParameterBag $bag, Classes $classes, ClassSubject $classSubject)
    {
        $response = [];
        ## if error came up then return back with the message
        if (!empty($validationResponse = $this->assign_teacher_to_subjectValidationCheck($bag))) {
            return $validationResponse;
        }

        ## duplication check
        $Entity = null;
        try {
            /** @var AllocateTeacherToClassAndSubjects $Entity */
            $Entity = $this->allocateTeacherToClassAndSubjectsRepository->duplicationCheck(
                $bag->get('teacher'),
                $classes->getId(),
                $classSubject->getId()
            );
            if ($Entity instanceof AllocateTeacherToClassAndSubjects && $Entity->getIsDeleted() === true) {
                $Entity->setIsDeleted(false);
            }
        } catch (\Exception $exception) {
            $Entity = null;
        }

        if (!$Entity instanceof AllocateTeacherToClassAndSubjects) {
            if (!empty($bag->get('alloC__ref'))) {
                $Entity = $this->get_teacher_allocation($bag->get('alloC__ref'));
            }

            if (!$Entity instanceof AllocateTeacherToClassAndSubjects) {
                $Entity = new AllocateTeacherToClassAndSubjects();
            }
        }
        ## get the teacher assign
        $this->get_teacher_allocation($bag->get('teacher'));
        $bag__ = new ParameterBag();
        $bag__->set('id', $bag->get('teacher'));
        $Teacher = $this->userService->pre__userCheck($bag__);
        if (!$Teacher instanceof User) {
            $response = $this->defaultFunction->push_error(
                $response,
                'Teacher is valid and active member of the School'
            );
            $response = $this->defaultFunction->push_error($response, $Teacher);
        }

        if (!empty($response)) {
            return $response;
        }

        try {
            $Entity->setAssignFromDate($this->defaultFunction->convert_datetimeStringIntoObject(null));
            $Entity->setAssignToDate($this->defaultFunction->convert_datetimeStringIntoObject(null));
            $Entity->setClass($classes);
            $Entity->setTeacher($Teacher);
            $Entity->setClassSubject($classSubject);
            $this->entityManager->persist($Entity);
            $this->entityManager->flush();

            $response = 'OK';
        } catch (\Exception $exception) {
            $response = $this->defaultFunction->push_error($response, $exception->getMessage());
        }

        return $response;

    }

    ## adding bulk teacher to the subjects
    public function bulk_assign_teacher_to_subject(
        ParameterBag $bag,
        Classes $classes = null,
        ClassSubject $classSubject = null
    ) {
        $response = [];
        for ($x = 0; count($bag->get('teacherList')) > $x; $x++) {
            if (!empty($bag->get('teacherList')[$x])) {
                $bag__ = new ParameterBag();
                $bag__->set('teacher', $bag->get('teacherList')[$x]);
                $response = $this->assign_teacher_to_subject($bag__, $classes, $classSubject);
            }
        }
        $response = $this->defaultFunction->purify_success_error_response_in_bulk_operation($response);

        return $response;
    }

    ## get all allocate teachers to class and subjects
    public function getAllAllocatedSubjectAndClassToTeacher(ParameterBag $bag = null)
    {
        ## get details from settings
        $showDeleteRecords = $this->appSettings->getAppSettingsFromSessions('show_deleted_records');

        return $this->allocateTeacherToClassAndSubjectsRepository->listOfAllocatedTeacher(
            $this->defaultFunction->parse__YesNoToBoolean($showDeleteRecords),
            $bag
        );
    }

}
