<?php

declare( strict_types=1 );

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190818112047 extends AbstractMigration {

	public function getDescription(): string {
		return '';
	}

	public function up( Schema $schema ): void {
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf( $this->connection->getDatabasePlatform()
		                                 ->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.' );

		$this->addSql( 'CREATE TABLE internal_chat_groups (id INT AUTO_INCREMENT NOT NULL, icg_created_by_id INT NOT NULL, icg_admin_id INT NOT NULL, icg_name VARCHAR(60) NOT NULL, icg_description VARCHAR(255) DEFAULT NULL, INDEX IDX_A2DE4ED4DCDBEB8D (icg_created_by_id), INDEX IDX_A2DE4ED498C1AC18 (icg_admin_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB' );
		$this->addSql( 'CREATE TABLE internal_chat_groups_guardian (id INT AUTO_INCREMENT NOT NULL, icg_id INT NOT NULL, guardians_id INT NOT NULL, INDEX IDX_905C2D227F5A2134 (icg_id), INDEX IDX_905C2D227B598B0 (guardians_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB' );
		$this->addSql( 'CREATE TABLE internal_chat_group_users (id INT AUTO_INCREMENT NOT NULL, icg_id INT NOT NULL, involved_users_id INT NOT NULL, INDEX IDX_787550627F5A2134 (icg_id), INDEX IDX_78755062355B50F1 (involved_users_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB' );
		$this->addSql( 'CREATE TABLE student_guardians (id INT AUTO_INCREMENT NOT NULL, student_id INT NOT NULL, name VARCHAR(60) NOT NULL, phone VARCHAR(60) DEFAULT NULL, password VARCHAR(255) NOT NULL, roles JSON DEFAULT NULL, INDEX IDX_6705E390CB944F1A (student_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB' );
		$this->addSql( 'ALTER TABLE internal_chat_groups ADD CONSTRAINT FK_A2DE4ED4DCDBEB8D FOREIGN KEY (icg_created_by_id) REFERENCES user (id)' );
		$this->addSql( 'ALTER TABLE internal_chat_groups ADD CONSTRAINT FK_A2DE4ED498C1AC18 FOREIGN KEY (icg_admin_id) REFERENCES user (id)' );
		$this->addSql( 'ALTER TABLE internal_chat_groups_guardian ADD CONSTRAINT FK_905C2D227F5A2134 FOREIGN KEY (icg_id) REFERENCES internal_chat_groups (id)' );
		$this->addSql( 'ALTER TABLE internal_chat_groups_guardian ADD CONSTRAINT FK_905C2D227B598B0 FOREIGN KEY (guardians_id) REFERENCES guardian (id)' );
		$this->addSql( 'ALTER TABLE internal_chat_group_users ADD CONSTRAINT FK_787550627F5A2134 FOREIGN KEY (icg_id) REFERENCES internal_chat_groups (id)' );
		$this->addSql( 'ALTER TABLE internal_chat_group_users ADD CONSTRAINT FK_78755062355B50F1 FOREIGN KEY (involved_users_id) REFERENCES user (id)' );
		$this->addSql( 'ALTER TABLE student_guardians ADD CONSTRAINT FK_6705E390CB944F1A FOREIGN KEY (student_id) REFERENCES user (id)' );
		$this->addSql( 'ALTER TABLE user CHANGE email email VARCHAR(180) DEFAULT NULL, CHANGE roles roles JSON NOT NULL, CHANGE lname lname VARCHAR(60) DEFAULT NULL, CHANGE is_active is_active TINYINT(1) DEFAULT NULL, CHANGE active_by active_by INT DEFAULT NULL, CHANGE admission_number admission_number INT DEFAULT NULL, CHANGE is_deleted is_deleted TINYINT(1) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE app_settings CHANGE details details LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\'' );
		$this->addSql( 'ALTER TABLE attendance CHANGE class_session_enrolment_subject_id class_session_enrolment_subject_id INT DEFAULT NULL, CHANGE class_session_enrolment_id class_session_enrolment_id INT DEFAULT NULL, CHANGE comments comments VARCHAR(255) DEFAULT NULL, CHANGE attendance_status_type attendance_status_type SMALLINT DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE attendance_status CHANGE description description VARCHAR(255) DEFAULT NULL, CHANGE type type SMALLINT DEFAULT NULL, CHANGE enable enable TINYINT(1) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE books_library CHANGE library_sections_id library_sections_id INT DEFAULT NULL, CHANGE book_description book_description VARCHAR(255) DEFAULT NULL, CHANGE book_cost book_cost SMALLINT DEFAULT NULL, CHANGE book_fine_per_hour book_fine_per_hour SMALLINT DEFAULT NULL, CHANGE book_deposit_requirement book_deposit_requirement VARCHAR(255) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE classes CHANGE session_id session_id INT DEFAULT NULL, CHANGE short_name short_name VARCHAR(30) DEFAULT NULL, CHANGE attendance_type attendance_type INT DEFAULT NULL, CHANGE active active TINYINT(1) DEFAULT NULL, CHANGE no_of_students no_of_students SMALLINT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE class_fee CHANGE amount amount DOUBLE PRECISION DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE class_fee_template CHANGE amount amount DOUBLE PRECISION DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE class_session_enrolment CHANGE user_id_id user_id_id INT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT NULL, CHANGE notes notes VARCHAR(255) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE class_session_enrolment_subjects CHANGE fee fee DOUBLE PRECISION DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE class_subject CHANGE marks marks INT DEFAULT NULL, CHANGE pass_marks pass_marks INT DEFAULT NULL, CHANGE credits credits SMALLINT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT NULL, CHANGE subject_name subject_name VARCHAR(50) DEFAULT NULL, CHANGE short_name short_name VARCHAR(30) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE class_subject_template CHANGE class_template___id class_template___id INT DEFAULT NULL, CHANGE marks marks DOUBLE PRECISION DEFAULT NULL, CHANGE pass_marks pass_marks SMALLINT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT NULL, CHANGE subject_name subject_name VARCHAR(50) DEFAULT NULL, CHANGE short_name short_name VARCHAR(30) DEFAULT NULL, CHANGE credits credits SMALLINT DEFAULT NULL, CHANGE hidden hidden TINYINT(1) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE class_template CHANGE short_name short_name VARCHAR(20) DEFAULT NULL, CHANGE attendance_type attendance_type SMALLINT DEFAULT NULL, CHANGE active active SMALLINT DEFAULT NULL, CHANGE no_of_students no_of_students SMALLINT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT NULL, CHANGE subjectwise_fee subjectwise_fee SMALLINT DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE custom_fields CHANGE custom_field_sections_id custom_field_sections_id INT DEFAULT NULL, CHANGE placeholder placeholder VARCHAR(100) DEFAULT NULL, CHANGE options options LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', CHANGE is_require is_require TINYINT(1) DEFAULT NULL, CHANGE visible_to visible_to VARCHAR(255) DEFAULT NULL, CHANGE visible_to_registration_form_of visible_to_registration_form_of VARCHAR(255) DEFAULT NULL, CHANGE allowed_extension allowed_extension VARCHAR(255) DEFAULT NULL, CHANGE sorting_order sorting_order INT DEFAULT NULL, CHANGE help_message help_message VARCHAR(255) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE custom_field_sections CHANGE description description VARCHAR(255) DEFAULT NULL, CHANGE sorting_order sorting_order INT DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE email_templates CHANGE variables variables LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\'' );
		$this->addSql( 'ALTER TABLE guardian CHANGE roles roles JSON NOT NULL, CHANGE phone phone VARCHAR(20) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE internal_chat CHANGE chat_reply_to chat_reply_to INT DEFAULT NULL, CHANGE chat_message_is_read chat_message_is_read TINYINT(1) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE internal_chat ADD CONSTRAINT FK_891D63618D2A3BF6 FOREIGN KEY (message__to_id) REFERENCES user (id)' );
		$this->addSql( 'ALTER TABLE internal_chat ADD CONSTRAINT FK_891D63615A0FC67 FOREIGN KEY (message__from_id) REFERENCES user (id)' );
		$this->addSql( 'ALTER TABLE library_assigned CHANGE issused_end_datetime issused_end_datetime DATETIME DEFAULT NULL, CHANGE return_date return_date DATETIME DEFAULT NULL' );

		$this->addSql( 'ALTER TABLE session CHANGE description description VARCHAR(255) DEFAULT NULL, CHANGE short_name short_name VARCHAR(47) DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE short_email_templates CHANGE variables variables LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\'' );

		$this->addSql( 'ALTER TABLE student_fee CHANGE recurring recurring TINYINT(1) DEFAULT NULL, CHANGE description description VARCHAR(255) DEFAULT NULL, CHANGE amount amount DOUBLE PRECISION DEFAULT NULL, CHANGE charget_at charget_at SMALLINT DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE subjects CHANGE short_name short_name VARCHAR(45) DEFAULT NULL, CHANGE credits credits INT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT NULL, CHANGE marks marks DOUBLE PRECISION DEFAULT NULL, CHANGE pass_marks pass_marks DOUBLE PRECISION DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE ext_log_entries CHANGE object_id object_id VARCHAR(64) DEFAULT NULL, CHANGE data data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', CHANGE username username VARCHAR(255) DEFAULT NULL' );
	}

	public function down( Schema $schema ): void {
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf( $this->connection->getDatabasePlatform()
		                                 ->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.' );

		$this->addSql( 'ALTER TABLE internal_chat_groups_guardian DROP FOREIGN KEY FK_905C2D227F5A2134' );
		$this->addSql( 'ALTER TABLE internal_chat_group_users DROP FOREIGN KEY FK_787550627F5A2134' );
		$this->addSql( 'DROP TABLE internal_chat_groups' );
		$this->addSql( 'DROP TABLE internal_chat_groups_guardian' );
		$this->addSql( 'DROP TABLE internal_chat_group_users' );
		$this->addSql( 'DROP TABLE student_guardians' );
		$this->addSql( 'ALTER TABLE app_settings CHANGE details details LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:array)\'' );
		$this->addSql( 'ALTER TABLE attendance CHANGE class_session_enrolment_subject_id class_session_enrolment_subject_id INT DEFAULT NULL, CHANGE class_session_enrolment_id class_session_enrolment_id INT DEFAULT NULL, CHANGE comments comments VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE attendance_status_type attendance_status_type SMALLINT DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE attendance_status CHANGE description description VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE type type SMALLINT DEFAULT NULL, CHANGE enable enable TINYINT(1) DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE books_library CHANGE library_sections_id library_sections_id INT DEFAULT NULL, CHANGE book_description book_description VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE book_cost book_cost SMALLINT DEFAULT NULL, CHANGE book_fine_per_hour book_fine_per_hour SMALLINT DEFAULT NULL, CHANGE book_deposit_requirement book_deposit_requirement VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci' );
		$this->addSql( 'ALTER TABLE class_fee CHANGE amount amount DOUBLE PRECISION DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE class_fee_template CHANGE amount amount DOUBLE PRECISION DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE class_session_enrolment CHANGE user_id_id user_id_id INT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT \'NULL\', CHANGE notes notes VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci' );
		$this->addSql( 'ALTER TABLE class_session_enrolment_subjects CHANGE fee fee DOUBLE PRECISION DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE class_subject CHANGE marks marks INT DEFAULT NULL, CHANGE pass_marks pass_marks INT DEFAULT NULL, CHANGE credits credits SMALLINT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT \'NULL\', CHANGE subject_name subject_name VARCHAR(50) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE short_name short_name VARCHAR(30) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci' );
		$this->addSql( 'ALTER TABLE class_subject_template CHANGE class_template___id class_template___id INT DEFAULT NULL, CHANGE marks marks DOUBLE PRECISION DEFAULT \'NULL\', CHANGE pass_marks pass_marks SMALLINT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT \'NULL\', CHANGE subject_name subject_name VARCHAR(50) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE short_name short_name VARCHAR(30) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE credits credits SMALLINT DEFAULT NULL, CHANGE hidden hidden TINYINT(1) DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE class_template CHANGE short_name short_name VARCHAR(20) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE attendance_type attendance_type SMALLINT DEFAULT NULL, CHANGE active active SMALLINT DEFAULT NULL, CHANGE no_of_students no_of_students SMALLINT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT \'NULL\', CHANGE subjectwise_fee subjectwise_fee SMALLINT DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE classes CHANGE session_id session_id INT DEFAULT NULL, CHANGE short_name short_name VARCHAR(30) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE attendance_type attendance_type INT DEFAULT NULL, CHANGE active active TINYINT(1) DEFAULT \'NULL\', CHANGE no_of_students no_of_students SMALLINT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE custom_field_sections CHANGE description description VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE sorting_order sorting_order INT DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE custom_fields CHANGE custom_field_sections_id custom_field_sections_id INT DEFAULT NULL, CHANGE is_require is_require TINYINT(1) DEFAULT \'NULL\', CHANGE placeholder placeholder VARCHAR(100) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE options options LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:array)\', CHANGE visible_to visible_to VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE visible_to_registration_form_of visible_to_registration_form_of VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE allowed_extension allowed_extension VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE sorting_order sorting_order INT DEFAULT NULL, CHANGE help_message help_message VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci' );
		$this->addSql( 'ALTER TABLE email_templates DROP FOREIGN KEY FK_6023E2A5516C3ADF' );
		$this->addSql( 'ALTER TABLE email_templates CHANGE variables variables LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:array)\'' );
		$this->addSql( 'ALTER TABLE ext_log_entries CHANGE object_id object_id VARCHAR(64) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE data data LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:array)\', CHANGE username username VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci' );
		$this->addSql( 'ALTER TABLE guardian CHANGE roles roles LONGTEXT NOT NULL COLLATE utf8mb4_bin, CHANGE phone phone VARCHAR(20) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci' );
		$this->addSql( 'ALTER TABLE internal_chat DROP FOREIGN KEY FK_891D63618D2A3BF6' );
		$this->addSql( 'ALTER TABLE internal_chat DROP FOREIGN KEY FK_891D63615A0FC67' );
		$this->addSql( 'ALTER TABLE internal_chat CHANGE chat_reply_to chat_reply_to INT DEFAULT NULL, CHANGE chat_message_is_read chat_message_is_read TINYINT(1) DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE library_assigned CHANGE issused_end_datetime issused_end_datetime DATETIME DEFAULT \'NULL\', CHANGE return_date return_date DATETIME DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE sanswers_regarding_cf DROP FOREIGN KEY FK_B70F525C666E4E08' );
		$this->addSql( 'ALTER TABLE sanswers_regarding_cf DROP FOREIGN KEY FK_B70F525CA76ED395' );
		$this->addSql( 'ALTER TABLE session CHANGE description description VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE short_name short_name VARCHAR(47) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci' );
		$this->addSql( 'ALTER TABLE short_email_templates DROP FOREIGN KEY FK_A2584F9B8FCD653D' );
		$this->addSql( 'ALTER TABLE short_email_templates CHANGE variables variables LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:array)\'' );
		$this->addSql( 'ALTER TABLE student_fee CHANGE recurring recurring TINYINT(1) DEFAULT \'NULL\', CHANGE description description VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE amount amount DOUBLE PRECISION DEFAULT \'NULL\', CHANGE charget_at charget_at SMALLINT DEFAULT NULL' );
		$this->addSql( 'ALTER TABLE subjects CHANGE short_name short_name VARCHAR(45) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE credits credits INT DEFAULT NULL, CHANGE fee fee DOUBLE PRECISION DEFAULT \'NULL\', CHANGE marks marks DOUBLE PRECISION DEFAULT \'NULL\', CHANGE pass_marks pass_marks DOUBLE PRECISION DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE tanswer_regarding_cf DROP FOREIGN KEY FK_AF35C76A666E4E08' );
		$this->addSql( 'ALTER TABLE tanswer_regarding_cf DROP FOREIGN KEY FK_AF35C76AA76ED395' );
		$this->addSql( 'ALTER TABLE user CHANGE email email VARCHAR(180) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE roles roles LONGTEXT NOT NULL COLLATE utf8mb4_bin, CHANGE lname lname VARCHAR(60) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE is_active is_active TINYINT(1) DEFAULT \'NULL\', CHANGE active_by active_by INT DEFAULT NULL, CHANGE admission_number admission_number INT DEFAULT NULL, CHANGE is_deleted is_deleted TINYINT(1) DEFAULT \'NULL\'' );
		$this->addSql( 'ALTER TABLE who_can_update_custom_field_custom_fields DROP FOREIGN KEY FK_2D28492373013FBE' );
		$this->addSql( 'ALTER TABLE who_can_update_custom_field_custom_fields DROP FOREIGN KEY FK_2D284923666E4E08' );
		$this->addSql( 'ALTER TABLE who_can_update_custom_field_guardian DROP FOREIGN KEY FK_ED4F21C773013FBE' );
		$this->addSql( 'ALTER TABLE who_can_update_custom_field_guardian DROP FOREIGN KEY FK_ED4F21C711CC8B0A' );
		$this->addSql( 'ALTER TABLE who_can_update_custom_field_user DROP FOREIGN KEY FK_28DE1DD573013FBE' );
		$this->addSql( 'ALTER TABLE who_can_update_custom_field_user DROP FOREIGN KEY FK_28DE1DD5A76ED395' );
	}
}
