<?php

namespace App\Entity;

use App\Repository\AttendanceRepository;
use App\Service\Constants;
use App\Service\FileManagment;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Timestampable\Traits\Timestampable;
use Symfony\Component\Security\Core\User\EquatableInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity(repositoryClass="App\Repository\UserRepository")
 */
class User implements UserInterface
{

    use Timestampable;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=180, name="email", nullable=true)
     */
    private $email;

    /**
     * @ORM\Column(type="json", name="roles")
     */
    private $roles = [];

    /**
     * @var string The hashed password
     * @ORM\Column(type="string", name="password")
     * @Assert\NotBlank(message="Please type password")
     */
    private $password;

    /**
     * @ORM\Column(type="string", length=80, name="fname")
     * @Assert\NotBlank(message="Please type first name.")
     */
    private $fName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true, name="lname")
     * @Assert\NotBlank(message="Please type last name")
     */
    private $lName;

    /**
     * @ORM\Column(type="boolean", nullable=true, name="is_active")
     */
    private $is_active = 0;

    /**
     * @ORM\Column(type="string", length=3, name="category")
     * @Assert\NotBlank(message="User's category is required")
     */
    private $category;

    /**
     * @ORM\Column(type="integer", nullable=true, name="active_by")
     */
    private $active_by;

    /**
     * @ORM\Column(type="integer", name="admission_number",nullable=true)
     */
    public $admission_number;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\SAnswersRegardingCF", mappedBy="User")
     */
    private $sAnswersRegardingCFs;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\TAnswerRegardingCF", mappedBy="User")
     */
    private $tAnswerRegardingCFs;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\AAnswerRegardingCF", mappedBy="User")
     */
    private $aAnswerRegardingCFs;

    /**
     * @ORM\Column(type="integer")
     */
    private $gender;

    /**
     * @var \DateTime $registerTime
     *
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(type="datetime", name="register_time")
     *
     */
    private $register_time;

    /**
     * @ORM\ManyToMany(targetEntity="App\Entity\Guardian", mappedBy="student_reference")
     */
    private $guardians;
    private $salt;

    /**
     * @ORM\ManyToMany(targetEntity="App\Entity\WhoCanUpdateCustomField", mappedBy="user_reference")
     */
    private $whoCanUpdateCustomFields;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $is_deleted = 0;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSessionEnrolment", mappedBy="user_id")
     */
    private $classSessionEnrolments;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Attendance", mappedBy="user")
     */
    private $attendances;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Attendance", mappedBy="blame_user")
     */
    private $attendance_did_by;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\LibraryAssigned", mappedBy="book__assigned_to")
     */
    private $library_book_assigned_to;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\LibraryAssigned", mappedBy="book__assigned_by")
     */
    private $library_book_assigned_by;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InternalChat", mappedBy="message__to")
     */
    private $internalChats___to;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InternalChat", mappedBy="message__from")
     */
    private $internalChat___from;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InternalChatGroups", mappedBy="icg_created_by")
     */
    private $internal_chat_group_created_by;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InternalChatGroups", mappedBy="icg_admin")
     */
    private $internal_chat_group_admin;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\InternalChatGroupUsers", mappedBy="involved_users")
     */
    private $internal_chat_group_user__involved;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Invoices", mappedBy="inv_generated_by")
     */
    private $invoices;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Invoices", mappedBy="inv_generated_for")
     */
    private $invoices_generated_for;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Transactions", mappedBy="trans_by")
     */
    private $transactions_by;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Transactions", mappedBy="trans_paid_to")
     */
    private $transaction_paid_to;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClasses", mappedBy="exam_checker")
     */
    private $examsClasses;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Examiners", mappedBy="user")
     */
    private $examiners;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ExamsClassesStudent", mappedBy="exam_did_by")
     */
    private $examsClassesStudents;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\AllocateTeacherToClassAndSubjects", mappedBy="teacher")
     */
    private $allocateTeacherToClassAndSubjects;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ScheduleMessage", mappedBy="sent_to")
     */
    private $schedule_message_receiver;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Tokens", mappedBy="user")
     */
    private $tokens;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassTimeTable", mappedBy="class_ownership")
     */
    private $classTimeTables;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassTimeTable", mappedBy="class_ownership_two")
     */
    private $classTimeTableOwnerShipTow;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassTimeTableSegments", mappedBy="teacher")
     */
    private $classTimeTableSegments;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassTimeTableSegments", mappedBy="teacher_backup")
     */
    private $classTimeTableAllocatedTeacherTwo;

    public function __construct()
    {
        $this->sAnswersRegardingCFs = new ArrayCollection();
        $this->tAnswerRegardingCFs = new ArrayCollection();
        $this->aAnswerRegardingCFs = new ArrayCollection();
        $this->guardians = new ArrayCollection();
        $this->whoCanUpdateCustomFields = new ArrayCollection();
        $this->classSessionEnrolments = new ArrayCollection();
        $this->attendances = new ArrayCollection();
        $this->attendance_did_by = new ArrayCollection();
        $this->library_book_assigned_to = new ArrayCollection();
        $this->library_book_assigned_by = new ArrayCollection();
        $this->internalChats___to = new ArrayCollection();
        $this->internalChat___from = new ArrayCollection();
        $this->internal_chat_group_created_by = new ArrayCollection();
        $this->internal_chat_group_admin = new ArrayCollection();
        $this->internal_chat_group_user__involved = new ArrayCollection();
        $this->invoices = new ArrayCollection();
        $this->invoices_generated_for = new ArrayCollection();
        $this->transactions_by = new ArrayCollection();
        $this->transaction_paid_to = new ArrayCollection();
        $this->examsClasses = new ArrayCollection();
        $this->examiners = new ArrayCollection();
        $this->examsClassesStudents = new ArrayCollection();
        $this->allocateTeacherToClassAndSubjects = new ArrayCollection();
        $this->schedule_message_receiver = new ArrayCollection();
        $this->guardian_token = new ArrayCollection();
        $this->tokens = new ArrayCollection();
        $this->classTimeTables = new ArrayCollection();
        $this->classTimeTableOwnerShipTow = new ArrayCollection();
        $this->classTimeTableSegments = new ArrayCollection();
        $this->classTimeTableAllocatedTeacherTwo = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    /**
     * A visual identifier that represents this user.
     *
     * @see UserInterface
     */
    public function getUsername(): string
    {
        return (string)$this->email;
    }

    public function getFullName(): string
    {
        return $this->getFName().' '.$this->getLName();
    }

    /**
     * @see UserInterface
     */
    public function getRoles(): array
    {
        $roles = $this->roles;
        // guarantee every user at least has ROLE_USER
        $roles[] = 'ROLE_USER';

        return array_unique($roles);
    }

    public function setRoles(array $roles): self
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * @see UserInterface
     */
    public function getPassword(): string
    {
        return (string)$this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;

        return $this;
    }

    /**
     * @see UserInterface
     */
    public function getSalt()
    {
        // not needed when using the "bcrypt" algorithm in security.yaml
        return $this->salt;
    }

    /**
     * @see UserInterface
     */
    public function eraseCredentials()
    {
        // If you store any temporary, sensitive data on the user, clear it here
        $this->plainPassword = null;
    }

    public function getFName(): ?string
    {
        return $this->fName;
    }

    public function setFName(string $fName): self
    {
        $this->fName = $fName;

        return $this;
    }

    public function getLName(): ?string
    {
        return $this->lName;
    }

    public function setLName(?string $LName): self
    {
        $this->lName = $LName;

        return $this;
    }

    public function getIsActive(): ?bool
    {
        return $this->is_active;
    }

    public function setIsActive(?bool $isActive): self
    {
        $this->is_active = $isActive;

        return $this;
    }

    public function getCategory(): ?string
    {
        return $this->category;
    }

    public function setCategory(string $category): self
    {
        $this->category = $category;

        return $this;
    }

    public function getActiveBy(): ?int
    {
        return $this->active_by;
    }

    public function setActiveBy(?int $activeBy): self
    {
        $this->active_by = $activeBy;

        return $this;
    }

    public function getAdmissionNumber(): ?int
    {
        return $this->admission_number;
    }

    public function setAdmissionNumber(int $admissionNumber): self
    {
        $this->admission_number = $admissionNumber;

        return $this;
    }

    /**
     * @return Collection|SAnswersRegardingCF[]
     */
    public function getSAnswersRegardingCFs(): Collection
    {
        return $this->sAnswersRegardingCFs;
    }

    public function addSAnswersRegardingCF(SAnswersRegardingCF $sAnswersRegardingCF): self
    {
        if (!$this->sAnswersRegardingCFs->contains($sAnswersRegardingCF)) {
            $this->sAnswersRegardingCFs[] = $sAnswersRegardingCF;
            $sAnswersRegardingCF->setUser($this);
        }

        return $this;
    }

    public function removeSAnswersRegardingCF(SAnswersRegardingCF $sAnswersRegardingCF): self
    {
        if ($this->sAnswersRegardingCFs->contains($sAnswersRegardingCF)) {
            $this->sAnswersRegardingCFs->removeElement($sAnswersRegardingCF);
            // set the owning side to null (unless already changed)
            if ($sAnswersRegardingCF->getUser() === $this) {
                $sAnswersRegardingCF->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAnswerRegardingCF[]
     */
    public function getTAnswerRegardingCFs(): Collection
    {
        return $this->tAnswerRegardingCFs;
    }

    public function addTAnswerRegardingCF(TAnswerRegardingCF $tAnswerRegardingCF): self
    {
        if (!$this->tAnswerRegardingCFs->contains($tAnswerRegardingCF)) {
            $this->tAnswerRegardingCFs[] = $tAnswerRegardingCF;
            $tAnswerRegardingCF->setUser($this);
        }

        return $this;
    }

    public function removeTAnswerRegardingCF(TAnswerRegardingCF $tAnswerRegardingCF): self
    {
        if ($this->tAnswerRegardingCFs->contains($tAnswerRegardingCF)) {
            $this->tAnswerRegardingCFs->removeElement($tAnswerRegardingCF);
            // set the owning side to null (unless already changed)
            if ($tAnswerRegardingCF->getUser() === $this) {
                $tAnswerRegardingCF->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|AAnswerRegardingCF[]
     */
    public function getAAnswerRegardingCFs(): Collection
    {
        return $this->aAnswerRegardingCFs;
    }

    public function addAAnswerRegardingCF(AAnswerRegardingCF $aAnswerRegardingCF): self
    {
        if (!$this->aAnswerRegardingCFs->contains($aAnswerRegardingCF)) {
            $this->aAnswerRegardingCFs[] = $aAnswerRegardingCF;
            $aAnswerRegardingCF->setUser($this);
        }

        return $this;
    }

    public function removeAAnswerRegardingCF(AAnswerRegardingCF $aAnswerRegardingCF): self
    {
        if ($this->aAnswerRegardingCFs->contains($aAnswerRegardingCF)) {
            $this->aAnswerRegardingCFs->removeElement($aAnswerRegardingCF);
            // set the owning side to null (unless already changed)
            if ($aAnswerRegardingCF->getUser() === $this) {
                $aAnswerRegardingCF->setUser(null);
            }
        }

        return $this;
    }

    public function getGender(): ?int
    {
        return $this->gender;
    }

    public function setGender(int $gender): self
    {
        $this->gender = $gender;

        return $this;
    }

    public function getRegisterTime(): ?\DateTimeInterface
    {
        $newDate = $this->register_time->format('d-m-Y');

        return $this->register_time;
    }

    public function setRegisterTime(\DateTimeInterface $registerTime): self
    {
        $this->register_time = $registerTime;

        return $this;
    }


    /**
     * @return Collection|Guardian[]
     */
    public function getGuardians(): Collection
    {
        return $this->guardians;
    }

    public function addGuardians(Guardian $guardian): self
    {
        if (!$this->guardians->contains($guardian)) {
            $this->guardians[] = $guardian;
            $guardian->addStudentReference($this);
        }

        return $this;
    }

    public function removeGuardians(Guardian $guardian): self
    {
        if ($this->guardians->contains($guardian)) {
            $this->guardians->removeElement($guardian);
            $guardian->removeStudentReference($this);
        }

        return $this;
    }

    /**
     * @return Collection|WhoCanUpdateCustomField[]
     */
    public function getWhoCanUpdateCustomFields(): Collection
    {
        return $this->whoCanUpdateCustomFields;
    }

    public function addWhoCanUpdateCustomField(WhoCanUpdateCustomField $whoCanUpdateCustomField): self
    {
        if (!$this->whoCanUpdateCustomFields->contains($whoCanUpdateCustomField)) {
            $this->whoCanUpdateCustomFields[] = $whoCanUpdateCustomField;
            $whoCanUpdateCustomField->addUserReference($this);
        }

        return $this;
    }

    public function removeWhoCanUpdateCustomField(WhoCanUpdateCustomField $whoCanUpdateCustomField): self
    {
        if ($this->whoCanUpdateCustomFields->contains($whoCanUpdateCustomField)) {
            $this->whoCanUpdateCustomFields->removeElement($whoCanUpdateCustomField);
            $whoCanUpdateCustomField->removeUserReference($this);
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(?bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }

    ## return the user type by the user category
    public function getUserType(): ?string
    {
        $response = 'student';
        if ($this->getCategory() == 'a') {
            $response = 'Admin';
        } elseif ($this->getCategory() == 't') {
            $response = 'Teacher';
        }

        return $response;
    }

    /**
     * @return Collection|ClassSessionEnrolment[]
     */
    public function getClassSessionEnrolments(): Collection
    {
        return $this->classSessionEnrolments;
    }

    public function addClassSessionEnrolment(ClassSessionEnrolment $classSessionEnrolment): self
    {
        if (!$this->classSessionEnrolments->contains($classSessionEnrolment)) {
            $this->classSessionEnrolments[] = $classSessionEnrolment;
            $classSessionEnrolment->setUserId($this);
        }

        return $this;
    }

    public function removeClassSessionEnrolment(ClassSessionEnrolment $classSessionEnrolment): self
    {
        if ($this->classSessionEnrolments->contains($classSessionEnrolment)) {
            $this->classSessionEnrolments->removeElement($classSessionEnrolment);
            // set the owning side to null (unless already changed)
            if ($classSessionEnrolment->getUserId() === $this) {
                $classSessionEnrolment->setUserId(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Attendance[]
     */
    public function getAttendances(): Collection
    {
        return $this->attendances;
    }

    public function addAttendance(Attendance $attendance): self
    {
        if (!$this->attendances->contains($attendance)) {
            $this->attendances[] = $attendance;
            $attendance->setUser($this);
        }

        return $this;
    }

    public function removeAttendance(Attendance $attendance): self
    {
        if ($this->attendances->contains($attendance)) {
            $this->attendances->removeElement($attendance);
            // set the owning side to null (unless already changed)
            if ($attendance->getUser() === $this) {
                $attendance->setUser(null);
            }
        }

        return $this;
    }
    
    /**
     * @return Collection|Attendance[]
     */
    public function getAttendanceDidBy(): Collection
    {
        return $this->attendance_did_by;
    }

    public function addAttendanceDidBy(Attendance $attendanceDidBy): self
    {
        if (!$this->attendance_did_by->contains($attendanceDidBy)) {
            $this->attendance_did_by[] = $attendanceDidBy;
            $attendanceDidBy->setBlameUser($this);
        }

        return $this;
    }

    public function removeAttendanceDidBy(Attendance $attendanceDidBy): self
    {
        if ($this->attendance_did_by->contains($attendanceDidBy)) {
            $this->attendance_did_by->removeElement($attendanceDidBy);
            // set the owning side to null (unless already changed)
            if ($attendanceDidBy->getBlameUser() === $this) {
                $attendanceDidBy->setBlameUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|LibraryAssigned[]
     */
    public function getLibraryBookAssignedTo(): Collection
    {
        return $this->library_book_assigned_to;
    }

    public function addLibraryBookAssignedTo(LibraryAssigned $libraryBookAssignedTo): self
    {
        if (!$this->library_book_assigned_to->contains($libraryBookAssignedTo)) {
            $this->library_book_assigned_to[] = $libraryBookAssignedTo;
            $libraryBookAssignedTo->setBookAssignedTo($this);
        }

        return $this;
    }

    public function removeLibraryBookAssignedTo(LibraryAssigned $libraryBookAssignedTo): self
    {
        if ($this->library_book_assigned_to->contains($libraryBookAssignedTo)) {
            $this->library_book_assigned_to->removeElement($libraryBookAssignedTo);
            // set the owning side to null (unless already changed)
            if ($libraryBookAssignedTo->getBookAssignedTo() === $this) {
                $libraryBookAssignedTo->setBookAssignedTo(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|LibraryAssigned[]
     */
    public function getLibraryBookAssignedBy(): Collection
    {
        return $this->library_book_assigned_by;
    }

    public function addLibraryBookAssignedBy(LibraryAssigned $libraryBookAssignedBy): self
    {
        if (!$this->library_book_assigned_by->contains($libraryBookAssignedBy)) {
            $this->library_book_assigned_by[] = $libraryBookAssignedBy;
            $libraryBookAssignedBy->setBookAssignedBy($this);
        }

        return $this;
    }

    public function removeLibraryBookAssignedBy(LibraryAssigned $libraryBookAssignedBy): self
    {
        if ($this->library_book_assigned_by->contains($libraryBookAssignedBy)) {
            $this->library_book_assigned_by->removeElement($libraryBookAssignedBy);
            // set the owning side to null (unless already changed)
            if ($libraryBookAssignedBy->getBookAssignedBy() === $this) {
                $libraryBookAssignedBy->setBookAssignedBy(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|InternalChat[]
     */
    public function getInternalChats(): Collection
    {
        return $this->internalChats___to;
    }

    public function addInternalChat(InternalChat $internalChat): self
    {
        if (!$this->internalChats___to->contains($internalChat)) {
            $this->internalChats___to[] = $internalChat;
            $internalChat->setMessageTo($this);
        }

        return $this;
    }

    public function removeInternalChat(InternalChat $internalChat): self
    {
        if ($this->internalChats___to->contains($internalChat)) {
            $this->internalChats___to->removeElement($internalChat);
            // set the owning side to null (unless already changed)
            if ($internalChat->getMessageTo() === $this) {
                $internalChat->setMessageTo(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|InternalChat[]
     */
    public function getInternalChatFrom(): Collection
    {
        return $this->internalChat___from;
    }

    public function addInternalChatFrom(InternalChat $internalChatFrom): self
    {
        if (!$this->internalChat___from->contains($internalChatFrom)) {
            $this->internalChat___from[] = $internalChatFrom;
            $internalChatFrom->setMessageFrom($this);
        }

        return $this;
    }

    public function removeInternalChatFrom(InternalChat $internalChatFrom): self
    {
        if ($this->internalChat___from->contains($internalChatFrom)) {
            $this->internalChat___from->removeElement($internalChatFrom);
            // set the owning side to null (unless already changed)
            if ($internalChatFrom->getMessageFrom() === $this) {
                $internalChatFrom->setMessageFrom(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|InternalChatGroups[]
     */
    public function getInternalChatGroupCreatedBy(): Collection
    {
        return $this->internal_chat_group_created_by;
    }

    public function addInternalChatGroupCreatedBy(InternalChatGroups $internalChatGroupCreatedBy): self
    {
        if (!$this->internal_chat_group_created_by->contains($internalChatGroupCreatedBy)) {
            $this->internal_chat_group_created_by[] = $internalChatGroupCreatedBy;
            $internalChatGroupCreatedBy->setIcgCreatedBy($this);
        }

        return $this;
    }

    public function removeInternalChatGroupCreatedBy(InternalChatGroups $internalChatGroupCreatedBy): self
    {
        if ($this->internal_chat_group_created_by->contains($internalChatGroupCreatedBy)) {
            $this->internal_chat_group_created_by->removeElement($internalChatGroupCreatedBy);
            // set the owning side to null (unless already changed)
            if ($internalChatGroupCreatedBy->getIcgCreatedBy() === $this) {
                $internalChatGroupCreatedBy->setIcgCreatedBy(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|InternalChatGroups[]
     */
    public function getInternalChatGroupAdmin(): Collection
    {
        return $this->internal_chat_group_admin;
    }

    public function addInternalChatGroupAdmin(InternalChatGroups $internalChatGroupAdmin): self
    {
        if (!$this->internal_chat_group_admin->contains($internalChatGroupAdmin)) {
            $this->internal_chat_group_admin[] = $internalChatGroupAdmin;
            $internalChatGroupAdmin->setIcgAdmin($this);
        }

        return $this;
    }

    public function removeInternalChatGroupAdmin(InternalChatGroups $internalChatGroupAdmin): self
    {
        if ($this->internal_chat_group_admin->contains($internalChatGroupAdmin)) {
            $this->internal_chat_group_admin->removeElement($internalChatGroupAdmin);
            // set the owning side to null (unless already changed)
            if ($internalChatGroupAdmin->getIcgAdmin() === $this) {
                $internalChatGroupAdmin->setIcgAdmin(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|InternalChatGroupUsers[]
     */
    public function getInternalChatGroupUserInvolved(): Collection
    {
        return $this->internal_chat_group_user__involved;
    }

    public function addInternalChatGroupUserInvolved(InternalChatGroupUsers $internalChatGroupUserInvolved): self
    {
        if (!$this->internal_chat_group_user__involved->contains($internalChatGroupUserInvolved)) {
            $this->internal_chat_group_user__involved[] = $internalChatGroupUserInvolved;
            $internalChatGroupUserInvolved->setInvolvedUsers($this);
        }

        return $this;
    }

    public function removeInternalChatGroupUserInvolved(InternalChatGroupUsers $internalChatGroupUserInvolved): self
    {
        if ($this->internal_chat_group_user__involved->contains($internalChatGroupUserInvolved)) {
            $this->internal_chat_group_user__involved->removeElement($internalChatGroupUserInvolved);
            // set the owning side to null (unless already changed)
            if ($internalChatGroupUserInvolved->getInvolvedUsers() === $this) {
                $internalChatGroupUserInvolved->setInvolvedUsers(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Invoices[]
     */
    public function getInvoices(): Collection
    {
        return $this->invoices;
    }

    public function addInvoice(Invoices $invoice): self
    {
        if (!$this->invoices->contains($invoice)) {
            $this->invoices[] = $invoice;
            $invoice->setInvGeneratedBy($this);
        }

        return $this;
    }

    public function removeInvoice(Invoices $invoice): self
    {
        if ($this->invoices->contains($invoice)) {
            $this->invoices->removeElement($invoice);
            // set the owning side to null (unless already changed)
            if ($invoice->getInvGeneratedBy() === $this) {
                $invoice->setInvGeneratedBy(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Invoices[]
     */
    public function getInvoicesGeneratedFor(): Collection
    {
        return $this->invoices_generated_for;
    }

    public function addInvoicesGeneratedFor(Invoices $invoicesGeneratedFor): self
    {
        if (!$this->invoices_generated_for->contains($invoicesGeneratedFor)) {
            $this->invoices_generated_for[] = $invoicesGeneratedFor;
            $invoicesGeneratedFor->setInvGeneratedFor($this);
        }

        return $this;
    }

    public function removeInvoicesGeneratedFor(Invoices $invoicesGeneratedFor): self
    {
        if ($this->invoices_generated_for->contains($invoicesGeneratedFor)) {
            $this->invoices_generated_for->removeElement($invoicesGeneratedFor);
            // set the owning side to null (unless already changed)
            if ($invoicesGeneratedFor->getInvGeneratedFor() === $this) {
                $invoicesGeneratedFor->setInvGeneratedFor(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Transactions[]
     */
    public function getTransactionsBy(): Collection
    {
        return $this->transactions_by;
    }

    public function addTransactionsBy(Transactions $transactionsBy): self
    {
        if (!$this->transactions_by->contains($transactionsBy)) {
            $this->transactions_by[] = $transactionsBy;
            $transactionsBy->setTransBy($this);
        }

        return $this;
    }

    public function removeTransactionsBy(Transactions $transactionsBy): self
    {
        if ($this->transactions_by->contains($transactionsBy)) {
            $this->transactions_by->removeElement($transactionsBy);
            // set the owning side to null (unless already changed)
            if ($transactionsBy->getTransBy() === $this) {
                $transactionsBy->setTransBy(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Transactions[]
     */
    public function getTransactionPaidTo(): Collection
    {
        return $this->transaction_paid_to;
    }

    public function addTransactionPaidTo(Transactions $transactionPaidTo): self
    {
        if (!$this->transaction_paid_to->contains($transactionPaidTo)) {
            $this->transaction_paid_to[] = $transactionPaidTo;
            $transactionPaidTo->setTransPaidTo($this);
        }

        return $this;
    }

    public function removeTransactionPaidTo(Transactions $transactionPaidTo): self
    {
        if ($this->transaction_paid_to->contains($transactionPaidTo)) {
            $this->transaction_paid_to->removeElement($transactionPaidTo);
            // set the owning side to null (unless already changed)
            if ($transactionPaidTo->getTransPaidTo() === $this) {
                $transactionPaidTo->setTransPaidTo(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ExamsClasses[]
     */
    public function getExamsClasses(): Collection
    {
        return $this->examsClasses;
    }

    public function addExamsClass(ExamsClasses $examsClass): self
    {
        if (!$this->examsClasses->contains($examsClass)) {
            $this->examsClasses[] = $examsClass;
            $examsClass->setExamChecker($this);
        }

        return $this;
    }

    public function removeExamsClass(ExamsClasses $examsClass): self
    {
        if ($this->examsClasses->contains($examsClass)) {
            $this->examsClasses->removeElement($examsClass);
            // set the owning side to null (unless already changed)
            if ($examsClass->getExamChecker() === $this) {
                $examsClass->setExamChecker(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Examiners[]
     */
    public function getExaminers(): Collection
    {
        return $this->examiners;
    }

    public function addExaminer(Examiners $examiner): self
    {
        if (!$this->examiners->contains($examiner)) {
            $this->examiners[] = $examiner;
            $examiner->setUser($this);
        }

        return $this;
    }

    public function removeExaminer(Examiners $examiner): self
    {
        if ($this->examiners->contains($examiner)) {
            $this->examiners->removeElement($examiner);
            // set the owning side to null (unless already changed)
            if ($examiner->getUser() === $this) {
                $examiner->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ExamsClassesStudent[]
     */
    public function getExamsClassesStudents(): Collection
    {
        return $this->examsClassesStudents;
    }

    public function addExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if (!$this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents[] = $examsClassesStudent;
            $examsClassesStudent->setExamDidBy($this);
        }

        return $this;
    }

    public function removeExamsClassesStudent(ExamsClassesStudent $examsClassesStudent): self
    {
        if ($this->examsClassesStudents->contains($examsClassesStudent)) {
            $this->examsClassesStudents->removeElement($examsClassesStudent);
            // set the owning side to null (unless already changed)
            if ($examsClassesStudent->getExamDidBy() === $this) {
                $examsClassesStudent->setExamDidBy(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|AllocateTeacherToClassAndSubjects[]
     */
    public function getAllocateTeacherToClassAndSubjects(): Collection
    {
        return $this->allocateTeacherToClassAndSubjects;
    }

    public function addAllocateTeacherToClassAndSubject(
        AllocateTeacherToClassAndSubjects $allocateTeacherToClassAndSubject
    ): self {
        if (!$this->allocateTeacherToClassAndSubjects->contains($allocateTeacherToClassAndSubject)) {
            $this->allocateTeacherToClassAndSubjects[] = $allocateTeacherToClassAndSubject;
            $allocateTeacherToClassAndSubject->setTeacher($this);
        }

        return $this;
    }

    public function removeAllocateTeacherToClassAndSubject(
        AllocateTeacherToClassAndSubjects $allocateTeacherToClassAndSubject
    ): self {
        if ($this->allocateTeacherToClassAndSubjects->contains($allocateTeacherToClassAndSubject)) {
            $this->allocateTeacherToClassAndSubjects->removeElement($allocateTeacherToClassAndSubject);
            // set the owning side to null (unless already changed)
            if ($allocateTeacherToClassAndSubject->getTeacher() === $this) {
                $allocateTeacherToClassAndSubject->setTeacher(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ScheduleMessage[]
     */
    public function getScheduleMessageReceiver(): Collection
    {
        return $this->schedule_message_receiver;
    }

    public function addScheduleMessageReceiver(ScheduleMessage $scheduleMessageReceiver): self
    {
        if (!$this->schedule_message_receiver->contains($scheduleMessageReceiver)) {
            $this->schedule_message_receiver[] = $scheduleMessageReceiver;
            $scheduleMessageReceiver->setSentTo($this);
        }

        return $this;
    }

    public function removeScheduleMessageReceiver(ScheduleMessage $scheduleMessageReceiver): self
    {
        if ($this->schedule_message_receiver->contains($scheduleMessageReceiver)) {
            $this->schedule_message_receiver->removeElement($scheduleMessageReceiver);
            // set the owning side to null (unless already changed)
            if ($scheduleMessageReceiver->getSentTo() === $this) {
                $scheduleMessageReceiver->setSentTo(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Tokens[]
     */
    public function getTokens(): Collection
    {
        return $this->tokens;
    }

    public function addToken(Tokens $token): self
    {
        if (!$this->tokens->contains($token)) {
            $this->tokens[] = $token;
            $token->setUser($this);
        }

        return $this;
    }

    public function removeToken(Tokens $token): self
    {
        if ($this->tokens->contains($token)) {
            $this->tokens->removeElement($token);
            // set the owning side to null (unless already changed)
            if ($token->getUser() === $this) {
                $token->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassTimeTable[]
     */
    public function getClassTimeTables(): Collection
    {
        return $this->classTimeTables;
    }

    public function addClassTimeTable(ClassTimeTable $classTimeTable): self
    {
        if (!$this->classTimeTables->contains($classTimeTable)) {
            $this->classTimeTables[] = $classTimeTable;
            $classTimeTable->setClassOwnership($this);
        }

        return $this;
    }

    public function removeClassTimeTable(ClassTimeTable $classTimeTable): self
    {
        if ($this->classTimeTables->contains($classTimeTable)) {
            $this->classTimeTables->removeElement($classTimeTable);
            // set the owning side to null (unless already changed)
            if ($classTimeTable->getClassOwnership() === $this) {
                $classTimeTable->setClassOwnership(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassTimeTable[]
     */
    public function getClassTimeTableOwnerShipTow(): Collection
    {
        return $this->classTimeTableOwnerShipTow;
    }

    public function addClassTimeTableOwnerShipTow(ClassTimeTable $classTimeTableOwnerShipTow): self
    {
        if (!$this->classTimeTableOwnerShipTow->contains($classTimeTableOwnerShipTow)) {
            $this->classTimeTableOwnerShipTow[] = $classTimeTableOwnerShipTow;
            $classTimeTableOwnerShipTow->setClassOwnershipTwo($this);
        }

        return $this;
    }

    public function removeClassTimeTableOwnerShipTow(ClassTimeTable $classTimeTableOwnerShipTow): self
    {
        if ($this->classTimeTableOwnerShipTow->contains($classTimeTableOwnerShipTow)) {
            $this->classTimeTableOwnerShipTow->removeElement($classTimeTableOwnerShipTow);
            // set the owning side to null (unless already changed)
            if ($classTimeTableOwnerShipTow->getClassOwnershipTwo() === $this) {
                $classTimeTableOwnerShipTow->setClassOwnershipTwo(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassTimeTableSegments[]
     */
    public function getClassTimeTableSegments(): Collection
    {
        return $this->classTimeTableSegments;
    }

    public function addClassTimeTableSegment(ClassTimeTableSegments $classTimeTableSegment): self
    {
        if (!$this->classTimeTableSegments->contains($classTimeTableSegment)) {
            $this->classTimeTableSegments[] = $classTimeTableSegment;
            $classTimeTableSegment->setTeacher($this);
        }

        return $this;
    }

    public function removeClassTimeTableSegment(ClassTimeTableSegments $classTimeTableSegment): self
    {
        if ($this->classTimeTableSegments->contains($classTimeTableSegment)) {
            $this->classTimeTableSegments->removeElement($classTimeTableSegment);
            // set the owning side to null (unless already changed)
            if ($classTimeTableSegment->getTeacher() === $this) {
                $classTimeTableSegment->setTeacher(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassTimeTableSegments[]
     */
    public function getClassTimeTableAllocatedTeacherTwo(): Collection
    {
        return $this->classTimeTableAllocatedTeacherTwo;
    }

    public function addClassTimeTableAllocatedTeacherTwo(ClassTimeTableSegments $classTimeTableAllocatedTeacherTwo
    ): self {
        if (!$this->classTimeTableAllocatedTeacherTwo->contains($classTimeTableAllocatedTeacherTwo)) {
            $this->classTimeTableAllocatedTeacherTwo[] = $classTimeTableAllocatedTeacherTwo;
            $classTimeTableAllocatedTeacherTwo->setTeacherBackup($this);
        }

        return $this;
    }

    public function removeClassTimeTableAllocatedTeacherTwo(ClassTimeTableSegments $classTimeTableAllocatedTeacherTwo
    ): self {
        if ($this->classTimeTableAllocatedTeacherTwo->contains($classTimeTableAllocatedTeacherTwo)) {
            $this->classTimeTableAllocatedTeacherTwo->removeElement($classTimeTableAllocatedTeacherTwo);
            // set the owning side to null (unless already changed)
            if ($classTimeTableAllocatedTeacherTwo->getTeacherBackup() === $this) {
                $classTimeTableAllocatedTeacherTwo->setTeacherBackup(null);
            }
        }

        return $this;
    }


    /**
     * The equality comparison should neither be done by referential equality
     * nor by comparing identities (i.e. getId() === getId()).
     *
     * However, you do not need to compare every attribute, but only those that
     * are relevant for assessing whether re-authentication is required.
     *
     * @return bool
     */
    /*public function isEqualTo( UserInterface $user ) {
        if ( ! $user instanceof Guardian ) {
            return false;
        }

        if ( $this->password !== $user->getPassword() ) {
            return false;
        }

        if ( $this->salt !== $user->getSalt() ) {
            return false;
        }

        if ( $this->admission_number !== $user->getUsername() ) {
            return false;
        }

        return true;
    }*/
}
