<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InvtStockItemsRepository")
 */
class InvtStockItems {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=15)
	 */
	private $invt_stock_item_serial_num;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\InventoryStock", inversedBy="invtStockItems")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $inventory_stock;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\InventoryStockLocation", inversedBy="invtStockItems")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $inventory_item_location;

	/**
	 * @ORM\OneToMany(targetEntity="App\Entity\InventoryItemsUsage", mappedBy="inventory__stock__item")
	 */
	private $inventoryItemsUsages;

	public function __construct() {
		$this->inventoryItemsUsages = new ArrayCollection();
	}

	public function getId(): ?int {
		return $this->id;
	}

	public function getInvtStockItemSerialNum(): ?string {
		return $this->invt_stock_item_serial_num;
	}

	public function setInvtStockItemSerialNum( string $invt_stock_item_serial_num ): self {
		$this->invt_stock_item_serial_num = $invt_stock_item_serial_num;

		return $this;
	}

	public function getInventoryStock(): ?InventoryStock {
		return $this->inventory_stock;
	}

	public function setInventoryStock( ?InventoryStock $inventory_stock ): self {
		$this->inventory_stock = $inventory_stock;

		return $this;
	}

	public function getInventoryItemLocation(): ?InventoryStockLocation {
		return $this->inventory_item_location;
	}

	public function setInventoryItemLocation( ?InventoryStockLocation $inventory_item_location ): self {
		$this->inventory_item_location = $inventory_item_location;

		return $this;
	}

	/**
	 * @return Collection|InventoryItemsUsage[]
	 */
	public function getInventoryItemsUsages(): Collection {
		return $this->inventoryItemsUsages;
	}

	public function addInventoryItemsUsage( InventoryItemsUsage $inventoryItemsUsage ): self {
		if ( ! $this->inventoryItemsUsages->contains( $inventoryItemsUsage ) ) {
			$this->inventoryItemsUsages[] = $inventoryItemsUsage;
			$inventoryItemsUsage->setInventoryStockItem( $this );
		}

		return $this;
	}

	public function removeInventoryItemsUsage( InventoryItemsUsage $inventoryItemsUsage ): self {
		if ( $this->inventoryItemsUsages->contains( $inventoryItemsUsage ) ) {
			$this->inventoryItemsUsages->removeElement( $inventoryItemsUsage );
			// set the owning side to null (unless already changed)
			if ( $inventoryItemsUsage->getInventoryStockItem() === $this ) {
				$inventoryItemsUsage->setInventoryStockItem( null );
			}
		}

		return $this;
	}
}
