<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ExamsClassesStudentRepository")
 */
class ExamsClassesStudent
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $ecs_gain_marks;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=false)
     */
    private $exam_did_by;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $remarks;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Subjects", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=true)
     * ## Deprecated
     */
    private $subject;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=true)
     * ## Deprecated
     */
    private $classes;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ExamsClasses", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=false)
     */
    private $exams_classes;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassSubject", inversedBy="examsClassesStudents")
     * @ORM\JoinColumn(nullable=true)
     * ## Deprecated
     */
    private $class_subject;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEcsGainMarks(): ?int
    {
        return $this->ecs_gain_marks;
    }

    public function setEcsGainMarks(int $ecs_gain_marks): self
    {
        $this->ecs_gain_marks = $ecs_gain_marks;

        return $this;
    }

    public function getExamDidBy(): ?User
    {
        return $this->exam_did_by;
    }

    public function setExamDidBy(?User $exam_did_by): self
    {
        $this->exam_did_by = $exam_did_by;

        return $this;
    }

    public function getRemarks(): ?string
    {
        return $this->remarks;
    }

    public function setRemarks(?string $remarks): self
    {
        $this->remarks = $remarks;

        return $this;
    }

    public function getSubject(): ?Subjects
    {
        return $this->subject;
    }

    public function setSubject(?Subjects $subject): self
    {
        $this->subject = $subject;

        return $this;
    }

    public function getClasses(): ?Classes
    {
        return $this->classes;
    }

    public function setClasses(?Classes $classes): self
    {
        $this->classes = $classes;

        return $this;
    }

    public function getExamsClasses(): ?ExamsClasses
    {
        return $this->exams_classes;
    }

    public function setExamsClasses(?ExamsClasses $exams_classes): self
    {
        $this->exams_classes = $exams_classes;

        return $this;
    }

    public function getClassSubject(): ?ClassSubject
    {
        return $this->class_subject;
    }

    public function setClassSubject(?ClassSubject $class_subject): self
    {
        $this->class_subject = $class_subject;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
