<?php

/**
 * when data save in it: when we are attaching fees while adding classes in session data will saves here.
 * Session  > addClass >
 *
 * */

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ClassFeeRepository")
 */
class ClassFee
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="float", nullable=true)
     */
    private $amount;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\StudentFee", inversedBy="classFees")
     * @ORM\JoinColumn(nullable=false)
     */
    private $fee;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\ClassFeeTemplate", inversedBy="classFees")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class_fee_template;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Classes", inversedBy="classFees")
     * @ORM\JoinColumn(nullable=false)
     */
    private $class;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassFeeSchedule", mappedBy="classFee")
     */
    private $classFeeSchedules;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\ClassSessionEnrolmentFeeSchedule", mappedBy="fee")
     */
    private $classSessionEnrolmentFeeSchedules;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function __construct()
    {
        $this->classFeeSchedules = new ArrayCollection();
        $this->classSessionEnrolmentFeeSchedules = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getFee(): ?StudentFee
    {
        return $this->fee;
    }

    public function setFee(?StudentFee $fee): self
    {
        $this->fee = $fee;

        return $this;
    }

    public function getClassFeeTemplate(): ?ClassFeeTemplate
    {
        return $this->class_fee_template;
    }

    public function setClassFeeTemplate(?ClassFeeTemplate $class_fee_template): self
    {
        $this->class_fee_template = $class_fee_template;

        return $this;
    }

    public function getClass(): ?Classes
    {
        return $this->class;
    }

    public function setClass(?Classes $class): self
    {
        $this->class = $class;

        return $this;
    }

    /**
     * @return Collection|ClassFeeSchedule[]
     */
    public function getClassFeeSchedules(): Collection
    {
        return $this->classFeeSchedules;
    }

    public function addClassFeeSchedule(ClassFeeSchedule $classFeeSchedule): self
    {
        if (!$this->classFeeSchedules->contains($classFeeSchedule)) {
            $this->classFeeSchedules[] = $classFeeSchedule;
            $classFeeSchedule->setClassFee($this);
        }

        return $this;
    }

    public function removeClassFeeSchedule(ClassFeeSchedule $classFeeSchedule): self
    {
        if ($this->classFeeSchedules->contains($classFeeSchedule)) {
            $this->classFeeSchedules->removeElement($classFeeSchedule);
            // set the owning side to null (unless already changed)
            if ($classFeeSchedule->getClassFee() === $this) {
                $classFeeSchedule->setClassFee(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|ClassSessionEnrolmentFeeSchedule[]
     */
    public function getClassSessionEnrolmentFeeSchedules(): Collection
    {
        return $this->classSessionEnrolmentFeeSchedules;
    }

    public function addClassSessionEnrolmentFeeSchedule(ClassSessionEnrolmentFeeSchedule $classSessionEnrolmentFeeSchedule): self
    {
        if (!$this->classSessionEnrolmentFeeSchedules->contains($classSessionEnrolmentFeeSchedule)) {
            $this->classSessionEnrolmentFeeSchedules[] = $classSessionEnrolmentFeeSchedule;
            $classSessionEnrolmentFeeSchedule->setFee($this);
        }

        return $this;
    }

    public function removeClassSessionEnrolmentFeeSchedule(ClassSessionEnrolmentFeeSchedule $classSessionEnrolmentFeeSchedule): self
    {
        if ($this->classSessionEnrolmentFeeSchedules->contains($classSessionEnrolmentFeeSchedule)) {
            $this->classSessionEnrolmentFeeSchedules->removeElement($classSessionEnrolmentFeeSchedule);
            // set the owning side to null (unless already changed)
            if ($classSessionEnrolmentFeeSchedule->getFee() === $this) {
                $classSessionEnrolmentFeeSchedule->setFee(null);
            }
        }

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
