<?php

namespace App\DataFixtures;

use App\Entity\ClassTemplate;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;

class ClassTemplateFixtures extends Fixture {

	private $faker;
	const ClassTempateFixtures = 'ClassTempateFixtures___';
	const classFixtures = 'classFixtures___';

	public function load( ObjectManager $manager ) {
		$this->faker = Factory::create();

		for ( $x = 0; $x < 10; $x++ ) {

			//$this->user_registration->registerUser();
			$Entity = new ClassTemplate();
			$Entity->setName( $this->faker->name );
			$Entity->setShortName( 'short name' );
			$Entity->setActive( $this->faker->boolean( 60 ) );
			$Entity->setAttendanceType( $this->faker->numberBetween( 1, 10 ) );
			$Entity->setFee( $this->faker->numberBetween( 1000, 25000 ) );
			$Entity->setNoOfStudents( rand( 20, 400 ) );
			$this->addReference( self::ClassTempateFixtures . $x, $Entity );
			$manager->persist( $Entity );
		}

		$manager->flush();
	}
}
