<?php


namespace App\Service\Students\Import;


use App\Entity\User;
use App\Service\FileManagment;
use App\Service\Guardian\Import\ImportGuardianService;
use App\Service\Mics\Import\ImportBasicSettings;
use App\Service\UserRegistration;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bridge\Twig\Extension\CsrfExtension;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Csrf\CsrfToken;
use Symfony\Component\Security\Csrf\CsrfTokenManager;

class ImportStudentService extends ImportBasicSettings
{

    /**
     * @var EntityManagerInterface
     */
    private $entityManager;
    /**
     * @var UserRegistration
     */
    private $userRegistration;
    /**
     * @var ImportGuardianService
     */
    private $importGuardianService;

    public function __construct(
        EntityManagerInterface $entityManager,
        UserRegistration $userRegistration,
        ImportGuardianService $importGuardianService
    ) {
        parent::__construct($entityManager);
        $this->entityManager = $entityManager;
        $this->userRegistration = $userRegistration;
        $this->importGuardianService = $importGuardianService;
    }


    /**
     * @param Request $request
     * @param FileManagment $fileManagement
     * @return array|mixed|string|void|null
     * @purpose: Convert CSV File Data into Array.
     */
    public function getCSVFileDataIntoArray(Request $request, FileManagment $fileManagement)
    {
        $dataArray = parent::getCSVFileDataIntoArray($request, $fileManagement);
        if (empty($dataArray)) {
            return null;
        } else {
            return $this->pushCsvConvertedDataToDB($dataArray);
        }
    }


    /**
     * @param $fileData
     * @return bool
     * @purpose: Validate CSV file data
     */
    public function validateCSVFileData($fileData)
    {

        $response = true;
        if (empty($fileData['Fname']) || empty($fileData['LName']) || empty($fileData['Email']) || empty($fileData['Password'])) {
            $response = 'Its seems, Fname, LName, Email, Password Column has some cell missing';
        }

        return $response;
    }


    /**
     * @param array $StudentData
     * @return array|string
     * @purpose: Method push Array data to Database.
     */
    public function pushCsvConvertedDataToDB(Array $StudentData)
    {
        $returnArray = [];

        if (empty($StudentData)) {
            return 'Invalid data supplied for import';
        }

        ## convert single dimension array into multiple dimension, if single record is given
        if (empty($StudentData[0])) {
            $StudentData = [$StudentData];
        }

        ## over the loop to insert student data into the database.
        foreach ($StudentData as $key => $value) {
            ## validate the data.
            $validationResponse = $this->validateCSVFileData($value);
            $request = new Request();
            if ($validationResponse) {
                try {

                    ## ignore CSRF token
                    $request->request->set('ignoreCsrfToken', 'true09Application');
                    ## put category of user
                    $request->request->set('category', 's');
                    ## put first name of user.
                    $request->request->set('fName', $value['Fname']);
                    $request->request->set('lName', $value['LName']);
                    $request->request->set('password', $value['Password']);
                    $request->request->set('gender', $value['Gender']);
                    $request->request->set('email', $value['Email']);
                    $request->request->set('returnStudentObject', true);
                    ## register user.
                    $studentObject = $this->userRegistration->registerUser($request);

                    ## if student has registered.
                    if ($studentObject instanceof User) {
                        ## try now insert Guardian against the user.
                        $guardianResponse = $this->importGuardianService->extractGuardianFromStudentCSVFile(
                            $value,
                            $studentObject
                        );
                        array_push($returnArray, $guardianResponse);
                    } else {
                        array_push($returnArray, $studentObject);
                    }
                } catch (\Exception $exception) {
                    array_push($returnArray, $exception->getMessage());
                }
            } else {
                array_push($returnArray, $validationResponse);
            }
        }

        return $returnArray;
    }

}