<?php


namespace App\Service;


use App\Entity\Classes;
use App\Entity\ClassFee;
use App\Entity\ClassFeeTemplate;
use App\Entity\ClassTemplate;
use App\Entity\Session;
use App\Entity\StudentFee;
use App\Repository\ClassesRepository;
use App\Repository\ClassTemplateRepository;
use App\Repository\SessionRepository;
use App\Service\Fees\StudentFeeService;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

class StudentSession
{

    private $errorArray = [];
    /**
     * @var DefaultFunction
     */
    private $default_function;
    /**
     * @var ClassTemplateRepository
     */
    private $class_template_repository;
    /**
     * @var EntityManagerInterface
     */
    private $entity_manager;
    /**
     * @var SessionRepository
     */
    private $session_repository;
    /**
     * @var ClassesRepository
     */
    private $classes_repository;
    /**
     * @var StudentClasses
     */
    private $student_classes;
    /**
     * @var StudentFeeService
     */
    private $student_fee_service;
    /**
     * @var AppSettings
     */
    private $appSettings;

    public function __construct(
        StudentFeeService $student_fee_service,
        DefaultFunction $default_function,
        ClassTemplateRepository $class_template_repository,
        EntityManagerInterface $entity_manager,
        SessionRepository $session_repository,
        ClassesRepository $classes_repository,
        StudentClasses $student_classes,
        AppSettings $appSettings
    ) {
        $this->default_function = $default_function;
        $this->class_template_repository = $class_template_repository;
        $this->entity_manager = $entity_manager;
        $this->session_repository = $session_repository;
        $this->classes_repository = $classes_repository;
        $this->student_classes = $student_classes;
        $this->student_fee_service = $student_fee_service;
        $this->appSettings = $appSettings;
    }


    ## save session of academy
    public function saveSession(ParameterBag $request, $classGradeService = null)
    {

        $returnResponse = [];

        ## validate the incoming of the session values.
        if (!empty($returnResponse = $this->saveSessionValidation($request))) {
            return $returnResponse;
        }

        ## create session instance
        $Session = new Session();

        /*
         * == Start == edit process of session
         * */

        ## if user is editing a session then this key have some value
        if (!empty($request->get('___randsection'))) {
            try {
                ## get the full session record when users want to edit a specific sesssion
                $Session = $this->session_repository->find($request->get('___randsection'));
                if (!$Session instanceof Session) {
                    ## if session is not found in the database then create a new session.
                    $Session = new Session();
                }
            } catch (\Exception $exception) {
                $returnResponse = $this->default_function->push_error($returnResponse, $exception->getMessage());
            }
        }

        ## if error exits then return back
        if (!empty($returnResponse)) {
            return $returnResponse;
        }

        ## duplication check.
        $bagDuplication = new ParameterBag();
        $bagDuplication->set('name', trim($request->get('name')));
        $bagDuplication->set('whereNotIn', $Session->getId());
        $duplicaitonResponse = $this->session_repository->duplicationCheck($bagDuplication);
        if (!empty($duplicaitonResponse)) {
            $returnResponse = $this->default_function->push_error(
                $returnResponse,
                $request->get('name').' has already exist with same name'
            );
        }

        if (!empty($returnResponse)) {
            return $returnResponse;
        }

        /*
         * == End == edit process of session
         * */

        ## start saving process.
        try {

            ## save session
            $Session->setName(trim($request->get('name')));
            $Session->setShortName($request->get('short_name'));
            $Session->setStartDate(new \DateTime($request->get('start_date')));
            $Session->setEndDate(new \DateTime($request->get('end_date')));
            $Session->setDescription($request->get('description'));
            if ($request->get('active') == 'on') {
                $Session->setActive(true);
            }

            ## save session in the session table.
            $this->entity_manager->persist($Session);
            $this->entity_manager->flush();

        } catch (\Exception $exception) {
            $returnResponse = $this->default_function->push_error($returnResponse, $exception->getMessage());
        }

        ## sent errors if we've it.
        if (!empty($returnResponse)) {
            return $returnResponse;
        }


        ## get attached classes with session and save them into the classes table.
        $attached_classes = $request->get('classes');
        ## don't remove duplicate attachedClasses Check.
        if (!empty($attached_classes)) {
            $attached_classes = $this->classes_repository->bulkDuplicationCheck($attached_classes, $Session->getId());
        }

        if (!empty($attached_classes)) {
            ## if attached classes is not array then make it.
            if (!is_array($attached_classes)) {
                $attached_classes = explode(' ', $attached_classes);
            }
            ## loop over the attached class to save the session
            foreach ($attached_classes as $key => $value) {
                try {

                    ## get classes template entity
                    $ClassTemplate = $this->class_template_repository->find($value);
                    ## if record found
                    if ($ClassTemplate instanceof ClassTemplate) {
                        ## save classTemplate in class + assign session to the Class + save subjects from classSubjectTemplate to classSubject
                        $returnResponse = $this->student_classes->updateClasses___preCheck(
                            $ClassTemplate,
                            $Session,
                            $classGradeService
                        );
                    }

                } catch (\Exception $exception) {
                    $returnResponse = $this->default_function->push_error($returnResponse, $exception->getMessage());
                }
            }

            ## sent errors if we've it.
            if (!empty($returnResponse)) {
                return $returnResponse;
            }
        }

        return 'OK';

    }

    ## save session validation
    public function saveSessionValidation(ParameterBag $request)
    {
        $returnResponse = [];
        ## validate name.
        if (empty($request->get('name'))) {
            $returnResponse = $this->default_function->push_error($returnResponse, 'Please fill out session name');
        }

        ## validate session start date
        if (empty($request->get('start_date'))) {
            $returnResponse = $this->default_function->push_error(
                $returnResponse,
                'Please fill out session start date'
            );
        }

        ## validate session end date
        if (empty($request->get('end_date'))) {
            $returnResponse = $this->default_function->push_error($returnResponse, 'Please fill out session end date');
        }

        ## sent errors if we've it.
        if (!empty($returnResponse)) {
            return $returnResponse;
        }

        ## session end date will be greater than start date.
        if (strtotime($request->get('start_date')) >= strtotime($request->get('end_date'))) {
            $returnResponse = $this->default_function->push_error(
                $returnResponse,
                'Start date must be smaller than end date'
            );
        }

        ## sent errors if we've it.
        if (!empty($returnResponse)) {
            return $returnResponse;
        } else {
            return [];
        }
    }

    ## delete all email template record against the specific section.
    public function deleteAllClassesAgaintSpecificSession(int $session_id)
    {
        $this->classes_repository->deleteAllClassesAgaintSpecificSession(43);
    }

    ## get session
    public function getSession(int $id = null, string $key = null, string $value = null)
    {
        $response = null;
        try {
            if (!empty($id)) {
                $response = $this->session_repository->find($id);
            } else {
                if (!empty($key) && !empty($value)) {
                    $response = $this->session_repository->findBy([$key => $value]);
                }
            }
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }

    ## get all sessions
    public function getAllSessions()
    {
        ## get details from settings
        $showDeleteRecords = $this->appSettings->getAppSettingsFromSessions('show_deleted_records');

        return $this->session_repository->listOfSession(
            $this->default_function->parse__YesNoToBoolean($showDeleteRecords)
        );
    }

    ## delete session
    public function deleteSession(int $sessionRef, bool $markAsDelete = true)
    {
        $response = [];
        ## get session
        $session = $this->getSession($sessionRef);
        if ($session instanceof Session) {
            try {
                if ($markAsDelete) {

                    ## delete all attached classes.
                    $deleteClasses = $this->student_classes->bulkDeleteClassesBySessionRef($session, true);
                    if ($deleteClasses == 'OK') {
                        $session->setIsDeleted(true);
                        $session->setActive(false);
                        $this->entity_manager->persist($session);
                        $this->entity_manager->flush();
                        $response = 'OK';
                    } else {
                        $response = $deleteClasses;
                    }

                } else {
                    ## check session has attached with the classes or not
                    $classes = count($session->getClasses()->toArray());
                    ## if session has attached classes then throw a notification.
                    if ($classes > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This session has attached with '.$classes.' classes'
                        );
                        $response = $this->default_function->push_error(
                            $response,
                            'Please delete these attached classes before deleting the session'
                        );
                    } else {
                        ## remove from database
                        $this->entity_manager->remove($session);
                        $this->entity_manager->flush();
                        $response = 'OK';
                    }

                }
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        } else {
            $response = $session;
        }

        return $response;
    }
}
