<?php

namespace App\Repository;

use App\Entity\Subjects;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\NonUniqueResultException;
use Doctrine\ORM\NoResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method Subjects|null findOneBy( array $criteria, array $orderBy = null )
 * @method Subjects[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class SubjectsRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, Subjects::class );
	}

	public function baseQueryBuilder() {
		return $this->createQueryBuilder( 'subjects' );
	}

	/**
	 * @param null $id
	 * @param null $lockMode
	 * @param null $lockVersion
	 *
	 * @return mixed|object|null
	 * @throws NoResultException
	 * @throws NonUniqueResultException
	 */
	public function find( $id = null, $lockMode = null, $lockVersion = null ) {
		if ( ! empty( $id ) ) {
			return $this->createQueryBuilder( 'subjects' )
			            ->where( 'subjects.id = :id' )
			            ->setParameter( 'id', $id )
			            ->getQuery()
			            ->getSingleResult();
		}
	}

	public function findAll() {
		return $this->createQueryBuilder( 'class_template' )->getQuery()->getResult();
	}

	## Duplicate check,
	## Before saving into database, verify, has we have entry in database like ths.
	public function duplicationCheck( \Symfony\Component\HttpFoundation\ParameterBag $bagDuplication ) {
		## query Builder
		$queryBuilder = $this->createQueryBuilder( 'subjects' );

		if ( ! empty( $bagDuplication->get( 'name' ) ) ) {
			$queryBuilder->andWhere( 'subjects.subject_name = :name' )
			             ->setParameter( 'name', $bagDuplication->get( 'name' ) );
		}
		if ( ! empty( $bagDuplication->get( 'whereNotIn' ) ) ) {
			$queryBuilder->andWhere( 'subjects.id <> :notCheck' )
			             ->setParameter( 'notCheck', $bagDuplication->get( 'whereNotIn' ) );
		}

		$queryBuilder->andWhere( 'subjects.is_deleted = false' );

		return $queryBuilder->getQuery()->getResult();

	}

	## find all non deleted records
	public function findAllNonDeleted() {
		return $this->createQueryBuilder( 'subjects' )->where( 'subjects.is_deleted = false' )->getQuery()->getResult();
	}

	## list of subjects depends on the user settings.
	public function listOfSubjects( $showDeletedRecords = false ) {
		## subjects query builder
		$queryBuilder = $this->createQueryBuilder( 'subjects' );

		## ignore delete records
		if ( ! $showDeletedRecords ) {
			$queryBuilder = $queryBuilder->andWhere( 'subjects.is_deleted = 0' );
		}

		return $queryBuilder->orderBy( 'subjects.is_deleted', 'ASC' )->getQuery()->getResult();

	}
}
