<?php

namespace App\Repository;

use App\Entity\InternalChat;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * @method InternalChat|null find( $id, $lockMode = null, $lockVersion = null )
 * @method InternalChat|null findOneBy( array $criteria, array $orderBy = null )
 * @method InternalChat[]    findAll()
 * @method InternalChat[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class InternalChatRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, InternalChat::class );
	}

	## load chat of two users.
	public function load_conversation_of_two_users( int $userRef_1, int $userRef_2, int $afterThisMessage = null ) {

		## create query builder
		$queryBuilder = $this->createQueryBuilder( 'internalChat' )## conditions in the query.
		                     ->where( 'internalChat.message__from = :user1 AND  internalChat.message__to = :user2' )
		                     ->orWhere( 'internalChat.message__from = :user2 AND  internalChat.message__to = :user1' ); ## set parameters

		## get the chat message after this message.
		if ( $afterThisMessage ) {
			$queryBuilder->andWhere( 'internalChat.id > :afterMessage' );
			$queryBuilder->setParameter( 'afterMessage', $afterThisMessage );
		}

		return $queryBuilder->setParameter( 'user1', $userRef_1 )
		                    ->setParameter( 'user2', $userRef_2 )## set the order of the query and return the result.
		                    ->orderBy( 'internalChat.id', 'asc' )
		                    ->getQuery()
		                    ->getResult();
	}

	## load chat list of user.
	public function load_chat_list__of_user( int $userRef ) {


		//		$connection                                 = $this->getEntityManager()->getConnection();
		//		$in_date_sub_query                          = null;
		//		$class_session_enrolement_subject_sub_query = null;
		//		$parameters_to_add                          = [];
		//
		//
		//		## sub query to get the attendance status
		//		$attendance_status_sub_query = $connection->createQueryBuilder()->select( 'COUNT(*)' )->from( 'internal_chat' );
		//
		//		## sub query to filter out the date
		//		$in_date_sub_query = $connection->createQueryBuilder()
		//		                                ->select( '*,id as attendance_ref' )
		//		                                ->addSelect( '('.$attendance_status_sub_query->getSQL() . ') as counter' )
		//		                                ->from( 'attendance' );
		//
		//
		//		## filtering attendance type. - ( subject wise attendance or non-subject wise attendance.)
		//		$parameters_to_add['attendance_type'] = 0;
		//
		//
		//		## get the user details which is attached in the class enrolement.
		//		//		$query____ = $connection->createQueryBuilder()
		//		//		                        ->select( '*,c_s.id as class_session_enrolment_ref' )
		//		//		                        ->from( 'class_session_enrolment', 'c_s' )
		//		//		                        ->andWhere( 'c_s.attendance_type = :attendance_type' );
		//
		//
		//		$query____ = $in_date_sub_query;
		//
		//
		//		## set query parameters.
		//		foreach ( $parameters_to_add as $key => $value ) {
		//			$query____->setParameter( $key, $value );
		//		}
		//
		//
		//		return $query____->getSQL();
		//		$s = $query____->execute();
		//
		//		return $s->fetchAll();


		//		return $this->createQueryBuilder( 'internalChat' )## get the unique receiver
		//		            ->select( 'IDENTITY(internalChat.chat_group) AS chat_group' )
		//		            ->distinct( true )
		//		            ->leftJoin( 'internalChat.chat_group', 'internalChatGroup' )
		//		            ->addSelect( 'internalChatGroup.icg_name, internalChatGroup.icg_description' )## get the group details which is used for the chat.
		//
		//		            ->andWhere( 'internalChat.chat_group is not null' )
		//		            ->orderBy( 'internalChat.id', 'desc' )
		//		            ->getQuery()
		//		            ->getResult();


		//		$this->createQueryBuilder( 'internalChat' )## get the unique receiver
		//		     ->select( 'IDENTITY(internalChat.chat_group) AS chat_group' )
		//		     ->distinct( true )
		//		     ->leftJoin( 'internalChat.chat_group', 'internalChatGroup' )
		//		     ->addSelect( 'internalChatGroup.icg_name, internalChatGroup.icg_description' )## get the group details which is used for the chat.
		//
		//		     ->leftJoin( 'internalChatGroup.internalChatGroupUsers', 'internalChatGroupUsers' )
		//		     ->leftJoin( 'internalChatGroupUsers.involved_users', 'involvedUsers' )
		//		     ->addSelect( 'involvedUsers.fName' )
		//
		//
		//
		//		     ->andWhere( 'internalChat.chat_group is not null' )
		//		     ->orderBy( 'internalChat.id', 'desc' )
		//		     ->getQuery()
		//		     ->getResult();


		//$unreadMessage = $this->createQueryBuilder('internalChat')->


		$builder = $this->createQueryBuilder( 'internalChat' )## get the unique receiver
		                ->select( '( IDENTITY(internalChat.message__to) )  AS message__to' )
		                ->distinct( false )
		                ->addSelect(


			                '(' . $this->createQueryBuilder( 'internalChat__inner' )
			                           ->select( 'COUNT(internalChat__inner.id)' )
			                           ->where( 'internalChat__inner.message__to = :user' )
			                           ->andWhere( 'internalChat__inner.chat_message_is_read IS NULL' )
			                           ->andWhere( 'internalChat__inner.message__from = internalChat.message__to' )
			                           ->getQuery()
			                           ->getDQL() . ') as _unread_counter__'


		                );

		## get the columns from the table.
		$builder->addSelect( 'internalChat.created_at' )
		        ->addSelect( '( IDENTITY(internalChat.message__from) )  AS message__from' );


		## get the group details if we've
		$builder->leftJoin( 'internalChat.chat_group', 'internalChatGroup' )
		        ->addSelect( 'internalChatGroup.icg_name, internalChatGroup.icg_description, internalChatGroup.id as internalChatGroup_ref' );

		## get the user details which is in the message_to column
		$builder->leftJoin( 'internalChat.message__to', 'user' )
		        ->addSelect( 'user.fName, user.lName, user.category, user.id as user_ref' );


		## get the user details which is in the message_from column
		$builder->leftJoin( 'internalChat.message__from', 'user_from' )
		        ->addSelect( 'user_from.fName as user_from_fName, user_from.lName user_from_lName, user_from.category user_from_category, user_from.id as user_ref__from' );

		## where condition
		$builder->where( 'internalChat.message__from = :user' )->orWhere( 'internalChat.message__to = :user' );

		## set parameter
		$builder->setParameter( 'user', $userRef );

		## make it unique
		$builder->groupBy( 'internalChat.message__from' )->addGroupBy( 'internalChat.message__to' );

		## order of the table.
		return $builder->orderBy( 'internalChat.id', 'desc' )->getQuery()->getArrayResult();

	}

	## load chat of the group.
	public function load_conversation_of_group( string $group__chat_ref ) {
		return $this->createQueryBuilder( 'internalChat' )
		            ->leftJoin( 'internalChat.message__from', 'messageFrom' )
		            ->addSelect( 'messageFrom' )
		            ->where( 'internalChat.chat_group = :group_ref' )
		            ->setParameter( 'group_ref', $group__chat_ref )
		            ->getQuery()
		            ->getResult();
	}

	## Load all messages in which user involved.
	## I meant, load all those messages where sender and receiver is this user.
	public function loadFullConversationOfUser( ParameterBag $bag ) {

		if ( empty( $bag->get( 'user__ref' ) ) ) {
			$queryBuiler = 'Invalid user reference';
		} else {

			$queryBuiler = $this->createQueryBuilder( 'internalChat' )
			                    ->where( 'internalChat.message__to = :user' )
			                    ->orWhere( 'internalChat.message__from = :user' );

			## get important messages.
			if ( $bag->get( 'imp_message' ) == 1 ) {
				$queryBuiler->andWhere( 'internalChat.is_important = 1' );
			}

			## get draft messages.
			if ( $bag->get( 'draft_message' ) == 1 ) {
				$queryBuiler->andWhere( 'internalChat.is_sent = 0' );
			}

			## get trash messages .
			if ( $bag->get( 'trash_message' ) == 1 ) {
				$queryBuiler->andWhere( 'internalChat.is_sent = 0' );
			}

			## get undeleted messages.
			if ( ! empty( $bag->get( 'deleted_message' ) ) ) {
				$queryBuiler->andWhere( 'internalChat.is_deleted = :deletedMessage' )
				            ->setParameter( 'deletedMessage', $bag->get( 'deleted_message' ) );
			}

			$queryBuiler = $queryBuiler->setParameter( 'user', $bag->get( 'user__ref' ) )
			                           ->orderBy( 'internalChat.id', 'DESC' )
			                           ->getQuery()
			                           ->getResult();
		}

		return $queryBuiler;
	}

	## get reply to messages.
	public function getReplyToMessages() {

	}

	/*
	 * Bulk Operations.
	 * */

	## Delete bulk messages or single message
	public function deleteBulkMessages( $targedRefInArray = [] ) {
		$queryBuilder = $this->createQueryBuilder( 'internalChat' )->delete();

		return $this->doFinalBulkAction( $queryBuilder, $targedRefInArray );
	}

	## mark bulk messages as important or a single message.
	## this is used to mark message as delete, make messaage as important or is read.
	public function updateBulkMessages( $targedRefInArray, $action ) {
		if ( $action == 'tr' ) {
			$columnName = 'is_deleted';
		} else if ( $action == 'mr' ) {
			$columnName = 'chat_message_is_read';
		} else if ( $action == 'mi' ) {
			$columnName = 'is_important';
		} else {
			return [];
		}
		$queryBuilder = $this->createQueryBuilder( 'internalChat' )
		                     ->update()
		                     ->set( 'internalChat.' . $columnName, true );

		return $this->doFinalBulkAction( $queryBuilder, $targedRefInArray );
	}

	## do bulk operation.
	public final function doFinalBulkAction( QueryBuilder $query_builder, $targedRefInArray = [] ) {
		return $query_builder->add( 'where', $query_builder->expr()->in( 'internalChat.id', $targedRefInArray ) )
		                     ->getQuery()
		                     ->execute();
	}

}
