<?php

namespace App\Repository;

use App\Entity\CustomFields;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method CustomFields|null find( $id, $lockMode = null, $lockVersion = null )
 * @method CustomFields|null findOneBy( array $criteria, array $orderBy = null )
 * @method CustomFields[]    findAll()
 * @method CustomFields[]    findBy( array $criteria, array $orderBy = null, $limit = null, $offset = null )
 */
class CustomFieldsRepository extends ServiceEntityRepository {

	public function __construct( RegistryInterface $registry ) {
		parent::__construct( $registry, CustomFields::class );
	}


	/*
	 * Search Custom Fields
	 * */
	public function search( $termToFind ) {
		$queryBuilder = $this->createQueryBuilder( 'cf' );

		if ( $termToFind ) {
			$queryBuilder->andWhere( 'cf.label like :term' )
			             ->orWhere( 'cf.placeholder like :term' )
			             ->orWhere( 'cf.options like :serialize' )
			             ->orWhere( 'cf.options like :term' )
			             ->setParameter( 'term', '%' . $termToFind . '%' )
			             ->setParameter( 'serialize', '%' . serialize( $termToFind ) . '%' )
			             ->orderBy( 'cf.sorting_order', 'asc' );
		}

		return $queryBuilder->getQuery()->getResult();
	}


	/**
	 *
	 * Get unique sections from the field table.
	 *
	 * @return mixed
	 */
	public function getDistinctSections( ?bool $addEmptySection = false ) {
		$result = $this->createQueryBuilder( 'cf' )
		               ->select( 'cf.section' )
		               ->distinct( true )
		               ->orderBy( 'cf.id', 'ASC' )
		               ->getQuery()
		               ->getResult();

		if ( $addEmptySection ) {
			array_unshift( $result, [ '' => '==No Section==' ] );
		}

		return $result;
	}


	/**
	 * Get field based section.
	 *
	 * @return mixed
	 */
	public function sectionBasedFields( ?string $searchTerm = null ) {
		$queryBuilder = $this->createQueryBuilder( 'cf' )->groupBy( 'cf.section' );

		## search according to the
		if ( $searchTerm && $searchTerm == 'student' ) {

			if ( $searchTerm == 'student' ) {
				## only get student'' field
				$term = 'student = 1';
			} else if ( $searchTerm == 'teacher' ) {
				## only get teachers'' field
				$term = 'teacher = 1';
			} else if ( $searchTerm == 'admin' ) {
				## only get admin'' field
				$term = 'admin = 1';
			}

			$queryBuilder->andWhere( 'cf.' . $term );

		}

		return $queryBuilder->getQuery()->getArrayResult();
	}


	/**
	 * 1 = student
	 * 2 = teacher
	 * 3 = guardian
	 * 4 = employee
	 * */
	public function getUserRegistrationField( $term ) {

		$term2 = ',' . $term;
		$term3 = $term . ',';
		$term4 = ',' . $term . ',';

		##
		$queryBuilder = $this->OrderBySortingNumberPatch1();

		##
		$queryBuilder->andWhere( 'cf.visible_to_registration_form_of = ' . $term . ' OR cf.visible_to_registration_form_of like :term2 OR cf.visible_to_registration_form_of like :term3 OR cf.visible_to_registration_form_of like :term4' )
		             ->setParameter( 'term2', '%' . $term2 . '%' )
		             ->setParameter( 'term3', '%' . $term3 . '%' )
		             ->setParameter( 'term4', '%' . $term4 . '%' );
		##
		$queryBuilder = $this->OrderBySortingNumberPatch2( $queryBuilder );

		return $queryBuilder->getQuery()->getResult();
	}


	/**
	 * @param $term
	 *
	 * As we well know, we've four type of user:
	 * This method get the user based custom field with section and feild sorting.
	 *
	 * @return mixed
	 */
	public function getUserBasedCustomField( $term ) {
		$term2 = ',' . $term;
		$term3 = $term . ',';
		$term4 = ',' . $term . ',';

		##
		$queryBuilder = $this->OrderBySortingNumberPatch1();

		##
		$queryBuilder->andWhere( 'cf.visible_to_registration_form_of = :term' )
		             ->orWhere( 'cf.visible_to_registration_form_of like :term2' )
		             ->orWhere( 'cf.visible_to_registration_form_of like :term3' )
		             ->orWhere( 'cf.visible_to_registration_form_of like :term4' )
		             ->orWhere( 'cf.visible_to = :term' )
		             ->orWhere( 'cf.visible_to like :term2' )
		             ->orWhere( 'cf.visible_to like :term3' )
		             ->orWhere( 'cf.visible_to like :term4' )
		             ->setParameter( 'term', $term )
		             ->setParameter( 'term2', '%' . $term2 . '%' )
		             ->setParameter( 'term3', '%' . $term3 . '%' )
		             ->setParameter( 'term4', '%' . $term4 . '%' );

		##
		$this->OrderBySortingNumberPatch2( $queryBuilder );

		## get query get result
		return $queryBuilder->getQuery()->getResult();
	}


	/**
	 * @param $fieldId
	 * @param $userId
	 * @param $FromWhere | sAnswersRegardingCFs | tAnswerRegardingCFs | aAnswerRegardingCFs
	 *                   Search the custom field answer based on the user & custom field and the table.
	 *
	 * @return mixed
	 */
	public function getTheFieldAnswer( $fieldId, $userId, $FromWhere ) {

		try {
			return $this->createQueryBuilder( 'custom_fields' )
			            ->leftJoin( "custom_fields.{$FromWhere}", 'answers' )
			            ->leftJoin( 'answers.User', 'user' )
			            ->andWhere( 'user.id = :userId' )
			            ->andWhere( 'custom_fields.id = :fieldId' )
			            ->setParameter( 'fieldId', $fieldId )
			            ->setParameter( 'userId', $userId )
			            ->getQuery()
			            ->getSingleResult();
		} catch ( \Exception $exception ) {
			return $exception->getMessage();
		}
	}


	public function OrderBySortingNumberPatch1() {
		return $this->createQueryBuilder( 'cf' )
		            ->leftJoin( 'cf.customFieldSections', 'custom_field_sections' )
		            ->andWhere( 'custom_field_sections.id is not null' )
		            ->addSelect( 'custom_field_sections' );
	}

	public function OrderBySortingNumberPatch2( QueryBuilder $queryBuilder ) {
		return $queryBuilder->addOrderBy( 'custom_field_sections.sorting_order', 'asc' )
		                    ->addorderBy( 'cf.sorting_order', 'asc' );
	}

}
