<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\WhoCanUpdateCustomFieldRepository")
 *
 * INFO: This table will those user id who can't update his custom field data.
 *
 */
class WhoCanUpdateCustomField {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\ManyToMany(targetEntity="App\Entity\CustomFields", inversedBy="whoCanUpdateCustomFields")
	 */
	private $custom_field_ref;

	/**
	 * @ORM\ManyToMany(targetEntity="App\Entity\User", inversedBy="whoCanUpdateCustomFields")
	 */
	private $user_reference;

	/**
	 * @ORM\ManyToMany(targetEntity="App\Entity\Guardian", inversedBy="whoCanUpdateCustomFields")
	 */
	private $guardian_ref;

	public function __construct() {
		$this->custom_field_ref = new ArrayCollection();
		$this->user_reference   = new ArrayCollection();
		$this->guardian_ref     = new ArrayCollection();
	}

	public function getId(): ?int {
		return $this->id;
	}

	/**
	 * @return Collection|CustomFields[]
	 */
	public function getCustomFieldRef(): Collection {
		return $this->custom_field_ref;
	}

	public function addCustomFieldRef( CustomFields $customFieldRef ): self {
		if ( ! $this->custom_field_ref->contains( $customFieldRef ) ) {
			$this->custom_field_ref[] = $customFieldRef;
		}

		return $this;
	}

	public function removeCustomFieldRef( CustomFields $customFieldRef ): self {
		if ( $this->custom_field_ref->contains( $customFieldRef ) ) {
			$this->custom_field_ref->removeElement( $customFieldRef );
		}

		return $this;
	}

	/**
	 * @return Collection|User[]
	 */
	public function getUserReference(): Collection {
		return $this->user_reference;
	}

	public function addUserReference( User $userReference ): self {
		if ( ! $this->user_reference->contains( $userReference ) ) {
			$this->user_reference[] = $userReference;
		}

		return $this;
	}

	public function removeUserReference( User $userReference ): self {
		if ( $this->user_reference->contains( $userReference ) ) {
			$this->user_reference->removeElement( $userReference );
		}

		return $this;
	}

	/**
	 * @return Collection|Guardian[]
	 */
	public function getGuardianRef(): Collection {
		return $this->guardian_ref;
	}

	public function addGuardianRef( Guardian $guardianRef ): self {
		if ( ! $this->guardian_ref->contains( $guardianRef ) ) {
			$this->guardian_ref[] = $guardianRef;
		}

		return $this;
	}

	public function removeGuardianRef( Guardian $guardianRef ): self {
		if ( $this->guardian_ref->contains( $guardianRef ) ) {
			$this->guardian_ref->removeElement( $guardianRef );
		}

		return $this;
	}
}
