<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\LibraryBooksAuthorRepository")
 */
class LibraryBooksAuthor
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $auth_name;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $auth_biography;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\BooksLibrary", mappedBy="book_auth")
     */
    private $booksLibraries;

    public function __construct()
    {
        $this->booksLibraries = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAuthName(): ?string
    {
        return $this->auth_name;
    }

    public function setAuthName(string $auth_name): self
    {
        $this->auth_name = $auth_name;

        return $this;
    }

    public function getAuthBiography(): ?string
    {
        return $this->auth_biography;
    }

    public function setAuthBiography(string $auth_biography): self
    {
        $this->auth_biography = $auth_biography;

        return $this;
    }

    /**
     * @return Collection|BooksLibrary[]
     */
    public function getBooksLibraries(): Collection
    {
        return $this->booksLibraries;
    }

    public function addBooksLibrary(BooksLibrary $booksLibrary): self
    {
        if (!$this->booksLibraries->contains($booksLibrary)) {
            $this->booksLibraries[] = $booksLibrary;
            $booksLibrary->setBookAuth($this);
        }

        return $this;
    }

    public function removeBooksLibrary(BooksLibrary $booksLibrary): self
    {
        if ($this->booksLibraries->contains($booksLibrary)) {
            $this->booksLibraries->removeElement($booksLibrary);
            // set the owning side to null (unless already changed)
            if ($booksLibrary->getBookAuth() === $this) {
                $booksLibrary->setBookAuth(null);
            }
        }

        return $this;
    }
}
