<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\InvoiceItemsRepository")
 */
class InvoiceItems {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $inv_item_description;

	/**
	 * @ORM\Column(type="integer")
	 */
	private $inv_item_amount;

	/**
	 * @ORM\Column(type="integer", nullable=true)
	 */
	private $inv_item_discount;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	private $inv_item_discount_description;

	/**
	 * @ORM\Column(type="integer", nullable=true)
	 */
	private $inv_item_fee;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\Invoices", inversedBy="invoiceItems")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $invoice_reference;

	public function getId(): ?int {
		return $this->id;
	}

	public function getInvItemDescription(): ?string {
		return $this->inv_item_description;
	}

	public function setInvItemDescription( ?string $inv_item_description ): self {
		$this->inv_item_description = $inv_item_description;

		return $this;
	}

	public function getInvItemAmount(): ?int {
		return $this->inv_item_amount;
	}

	public function setInvItemAmount( int $inv_item_amount ): self {
		$this->inv_item_amount = $inv_item_amount;

		return $this;
	}

	public function getInvItemDiscount(): ?int {
		return $this->inv_item_discount;
	}

	public function setInvItemDiscount( ?int $inv_item_discount ): self {
		$this->inv_item_discount = $inv_item_discount;

		return $this;
	}

	public function getInvItemDiscountDescription(): ?string {
		return $this->inv_item_discount_description;
	}

	public function setInvItemDiscountDescription( ?string $inv_item_discount_description ): self {
		$this->inv_item_discount_description = $inv_item_discount_description;

		return $this;
	}

	public function getInvItemFee(): ?int {
		return $this->inv_item_fee;
	}

	public function setInvItemFee( ?int $inv_item_fee ): self {
		$this->inv_item_fee = $inv_item_fee;

		return $this;
	}

	public function getInvoiceReference(): ?Invoices {
		return $this->invoice_reference;
	}

	public function setInvoiceReference( ?Invoices $invoice_reference ): self {
		$this->invoice_reference = $invoice_reference;

		return $this;
	}
}
