<?php

namespace App\Controller;

use App\DataFixtures\CustomFieldFixtures;
use App\Entity\CustomFields;
use App\Entity\Guardian;
use App\Entity\User;
use App\Form\AddingCustomFieldsToUserFormType;
use App\Form\UsersProfileCustomFieldsSearchFormType;
use App\Repository\AttendanceRepository;
use App\Repository\ClassesRepository;
use App\Repository\ClassSessionEnrolmentRepository;
use App\Repository\CustomFieldsRepository;
use App\Repository\SAnswersRegardingCFRepository;
use App\Repository\TransactionsRepository;
use App\Repository\UserRepository;
use App\Service\EmailSettings\Base;
use App\Service\FileManagment;
use App\Service\TriggerNotifications;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Snappy\Pdf;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Symfony\Component\PropertyAccess\PropertyAccess;
use Symfony\Component\PropertyAccess\PropertyAccessor;
use Symfony\Component\Routing\Annotation\Route;

/**
 *  #Description: This is is the Default Controller of Application.
 * @IsGranted("ROLE_USER")
 *
 * */
class DefaultController extends AbstractController
{

    /**
     * @var UserRepository
     */
    private $user_repository;
    /**
     * @var ClassesRepository
     */
    private $classes_repository;
    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $class_session_enrolment_repository;
    /**
     * @var AttendanceRepository
     */
    private $attendance_repository;
    /**
     * @var TransactionsRepository
     */
    private $transactions_repository;
    /**
     * @var EntityManager
     */
    private $entityManager;

    public function __construct(
        Base $Emailbase,
        UserController $userController,
        UserRepository $user_repository,
        ClassesRepository $classes_repository,
        ClassSessionEnrolmentRepository $class_session_enrolment_repository,
        AttendanceRepository $attendance_repository,
        TransactionsRepository $transactions_repository,
        EntityManagerInterface $entityManager
    ) {

        $this->user_repository = $user_repository;
        $this->classes_repository = $classes_repository;
        $this->class_session_enrolment_repository = $class_session_enrolment_repository;
        $this->attendance_repository = $attendance_repository;
        $this->transactions_repository = $transactions_repository;
        $this->entityManager = $entityManager;
    }

    /**
     * @Route("{_locale}/dashboard/", name="HomePage")
     * @return Response
     */
    public function index()
    {
        ## if category is student then redirect student to his profile
        if ($this->getUser() instanceof User && $this->getUser()->getCategory() == 's') {
            ## redirect to the user profile is logged in user is student
            return $this->redirectToRoute('filter_my_attendance');
        }elseif($this->getUser() instanceof User && $this->getUser()->getCategory() == 't'){
            return $this->redirectToRoute('add_attendance');
        } else {
            ## get the data on based of the user category
            $response = $this->decideTemplateAccordingToUserCategory();
            ## return the template with the detailed information.
            return $this->render($response['template_path'], $response['data']);
        }
    }

    /**
     * @Route("/{_locale}/dashboard/", name="HomePageWithLocale")
     */
    public function IndexLocale()
    {
        return $this->render(
            'default/index.html.twig',
            [
                'UsersLIst' => $this->user_repository->findAll(),
            ]
        );
    }

    ## dashboard page will be totally different for different user category so i've decided to create different pages for the different users.
    private function decideTemplateAccordingToUserCategory()
    {
        $data = [];
        switch ($this->getUser()->getCategory()) {
            case 'a':
                $pageName = 'admin';
                $data = [

                    ## Attendance Report.
                    'activeClassesWithActiveSession' => $this->class_session_enrolment_repository->get__UniqueEnrolledClassesListInActiveSessionAndClasses(
                    ),
                    'noOfMarkedAttendanceClasses' => $this->attendance_repository->get__attendanceStats__NoOfClassSessionEnrolmentOfActiveClassesAndActiveSession(
                    ),
                    'totalNoOfStudentsInActiveClassesOfActiveSessions' => $this->class_session_enrolment_repository->get__studentsOfActiveClassesOfActiveSession(
                    ),
                    'todayNoOfPresentStudentInTheirClasses' => $this->attendance_repository->get__AttendanceOFPresentStudentAtTheActiveClassesOfActiveSessions(
                    ),
                    ## Revenue generation report.
                    'expenses' => $this->transactions_repository->calculateIncomeOrExpenseAmount(0),
                    'income' => $this->transactions_repository->calculateIncomeOrExpenseAmount(1),
                    'students' => $this->entityManager->getRepository('App:User')->findBy(
                        ['category' => 's'],
                        ['id' => 'desc']
                        ,
                        10
                    ),
                    'guardians' => $this->entityManager->getRepository('App:Guardian')->findBy(
                        ['category' => 'g'],
                        ['id' => 'desc']
                        ,
                        10
                    ),
                    'teachers' => $this->entityManager->getRepository('App:User')->findBy(
                        ['category' => 't'],
                        ['id' => 'desc']
                        ,
                        10
                    ),
                    'dailyStudentRegistrationGraph' => $this->user_repository->getLastSixteenDaysUserRegistration(),
                    'last10MonthIncome' => $this->transactions_repository->last10MonthReport(1),
                    'last10MonthExpense' => $this->transactions_repository->last10MonthReport(0),
                ];
                break;
            case 's':
                $pageName = 'student';
                break;
            case 't':
                $pageName = 'teacher';
                break;
            default:
                $pageName = 'guardian';
                break;
        }

        return [
            'template_path' => 'default/'.$pageName.'.html.twig',
            'data' => $data,
        ];
    }

    /**
     * @Route("{_locale}/faqs/", name="faqs")
     * @return Response
     */
    public function faqs()
    {
        return $this->render('app/faqs.html.twig', []);
    }
}
