<?php


namespace App\Service\SystemServices;


use App\Entity\Options;
use App\Repository\OptionsRepository;
use App\Service\DefaultFunction;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping\Entity;
use Symfony\Component\HttpFoundation\ParameterBag;

class systemOptionsService {

	/**
	 * @var DefaultFunction
	 */
	private $default_function;
	/**
	 * @var OptionsRepository
	 */
	private $options_repository;
	/**
	 * @var EntityManagerInterface
	 */
	private $entity_manager;

	public function __construct( DefaultFunction $default_function, OptionsRepository $options_repository, EntityManagerInterface $entity_manager ) {
		$this->default_function   = $default_function;
		$this->options_repository = $options_repository;
		$this->entity_manager     = $entity_manager;
	}


	## validate options
	public function validateOption( ParameterBag $bag ) {
		$response = [];

		## option name
		if ( empty( $bag->get( 'optNm' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Option name should not be empty' );
		}

		## option value
		if ( empty( $bag->get( 'optVl' ) ) ) {
			$response = $this->default_function->push_error( $response, 'Option value should not be empty' );
		}

		return $response;
	}

	## get the option.
	public function getOption( $optionName, $optionValue = null, $saveInDatabae = null ) {
		$response = null;
		if ( ! empty( $optionName ) ) {
			try {
				## get the option in database
				$response = $this->options_repository->findOneBy( [ 'option_name' => $optionName ] );

				if ( ! $response instanceof Options && $saveInDatabae && ! empty( $optionValue ) ) {
					## if save in database
					$bag = new ParameterBag();
					$bag->set( 'optNm', $optionName );
					$bag->set( 'optVl', $optionValue );
					$response = $this->saveOption( $bag, true );
				} else if ( ! empty( $optionValue ) ) {
					$response = $optionValue;
				}

			} catch ( \Exception $exception ) {
				$response = $exception->getMessage();
			}
		}

		return $response;
	}

	## save the option
	public function saveOption( ParameterBag $bag, $returnObjectAfterSave ) {
		$response = [];

		## validate the response.
		if ( ! empty( $validationResponse = $this->validateOption( $bag ) ) ) {
			return $validationResponse;
		}

		$OptionEntity = null;

		## what you want to do, add or edit.
		if ( ! empty( $bag->get( 'optNm' ) ) ) {
			## check name of this option is exits or not in the database
			$OptionEntity = $this->getOption( $bag->get( 'optNm' ) );
		}

		## if option entity is not in the database then create  a new one.
		if ( ! $OptionEntity instanceof Options ) {
			$OptionEntity = new Options();
		}

		try {

			$OptionEntity->setOptionName( $bag->get( 'optNm' ) );
			$OptionEntity->setOptionValue( $bag->get( 'optVl' ) );
			$this->entity_manager->persist( $OptionEntity );
			$this->entity_manager->flush();

			if ( $returnObjectAfterSave ) {
				$response = $OptionEntity;
			} else {
				$response = 'OK';
			}

		} catch ( \Exception $exception ) {
			$response = $exception->getMessage();
		}

		return $response;

	}
}