<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\ZonesRepository")
 */
class Zones {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="string", length=10)
	 */
	private $country_code;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	private $zone_name;

	public function getId(): ?int {
		return $this->id;
	}

	public function getCountryCode(): ?string {
		return $this->country_code;
	}

	public function setCountryCode( string $country_code ): self {
		$this->country_code = $country_code;

		return $this;
	}

	public function getZoneName(): ?string {
		return $this->zone_name;
	}

	public function setZoneName( string $zone_name ): self {
		$this->zone_name = $zone_name;

		return $this;
	}

}
