<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\LibraryAssignedRepository")
 */
class LibraryAssigned {

	/**
	 * @ORM\Id()
	 * @ORM\GeneratedValue()
	 * @ORM\Column(type="integer")
	 */
	private $id;

	/**
	 * @ORM\Column(type="datetime")
	 */
	private $issue_date;


	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	private $issused_end_datetime;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	private $return_date;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	private $notes;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="library_book_assigned_to")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $book__assigned_to;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\User", inversedBy="library_book_assigned_by")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $book__assigned_by;

	/**
	 * @ORM\ManyToOne(targetEntity="App\Entity\LibraryBookCopies", inversedBy="libraryAssigneds")
	 * @ORM\JoinColumn(nullable=false)
	 */
	private $library_book_copies_ref;

	public function __construct() {
	}


	public function getId(): ?int {
		return $this->id;
	}

	public function getIssueDate(): ?\DateTimeInterface {
		return $this->issue_date;
	}

	public function setIssueDate( \DateTimeInterface $issue_date ): self {
		$this->issue_date = $issue_date;

		return $this;
	}

	public function getIssusedEndDatetime(): ?\DateTimeInterface {
		return $this->issused_end_datetime;
	}

	public function setIssusedEndDatetime( ?\DateTimeInterface $issused_end_datetime ): self {
		$this->issused_end_datetime = $issused_end_datetime;

		return $this;
	}

	public function getReturnDate(): ?\DateTimeInterface {
		return $this->return_date;
	}

	public function setReturnDate( ?\DateTimeInterface $return_date ): self {
		$this->return_date = $return_date;

		return $this;
	}

	public function getNotes(): ?string {
		return $this->notes;
	}

	public function setNotes( string $notes ): self {
		$this->notes = $notes;

		return $this;
	}

	public function setBookAssignedTo( ?User $book__assigned_to ): self {
		$this->book__assigned_to = $book__assigned_to;

		return $this;
	}

	public function setBookAssignedBy( ?User $book__assigned_by ): self {
		$this->book__assigned_by = $book__assigned_by;

		return $this;
	}

	public function getLibraryBookCopiesRef(): ?LibraryBookCopies {
		return $this->library_book_copies_ref;
	}

	public function setLibraryBookCopiesRef( ?LibraryBookCopies $library_book_copies_ref ): self {
		$this->library_book_copies_ref = $library_book_copies_ref;

		return $this;
	}

	/**
	 * @return User
	 */
	public function getBookAssignedTo() {
		return $this->book__assigned_to;
	}
}
