<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\CustomFieldSectionsRepository")
 */
class CustomFieldSections
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=70)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\CustomFields", mappedBy="customFieldSections",fetch="EXTRA_LAZY",
     *                                                        orphanRemoval=false)
     */
    private $custom_field_ref;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $sorting_order;

    /**
     * @ORM\Column(type="boolean")
     */
    private $is_deleted = false;

    public function __construct()
    {
        $this->custom_field_ref = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|CustomFields[]
     */
    public function getCustomFieldRef(): Collection
    {
        return $this->custom_field_ref;
    }

    public function addCustomFieldRef(CustomFields $customFieldRef): self
    {
        if (!$this->custom_field_ref->contains($customFieldRef)) {
            $this->custom_field_ref[] = $customFieldRef;
        }

        return $this;
    }

    public function removeCustomFieldRef(CustomFields $customFieldRef): self
    {
        if ($this->custom_field_ref->contains($customFieldRef)) {
            $this->custom_field_ref->removeElement($customFieldRef);
        }

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getSortingOrder(): ?int
    {
        return $this->sorting_order;
    }

    public function setSortingOrder(?int $sorting_order): self
    {
        $this->sorting_order = $sorting_order;

        return $this;
    }

    public function getIsDeleted(): ?bool
    {
        return $this->is_deleted;
    }

    public function setIsDeleted(bool $is_deleted): self
    {
        $this->is_deleted = $is_deleted;

        return $this;
    }
}
