<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\BooksLibraryRepository")
 */
class BooksLibrary
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=70)
     */
    private $book_name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $book_description;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $book_cost = 0;

    /**
     * @ORM\Column(type="smallint", nullable=true)
     */
    private $book_fine_per_hour = 0;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $book_deposit_requirement;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\LibraryBooksAuthor", inversedBy="booksLibraries")
     * @ORM\JoinColumn(nullable=false)
     */
    private $book_auth;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\LibraryBooksCategory", inversedBy="attached_books")
     * @ORM\JoinColumn(nullable=false)
     */
    private $book_cat_ref;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\LibraryBookCopies", mappedBy="library_book_ref")
     */
    private $libraryBookCopies;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\LibrarySections", inversedBy="library_books")
     */
    private $librarySections;

    public function __construct()
    {
        $this->book_blame_user = new ArrayCollection();
        $this->libraryBookCopies = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getBookName(): ?string
    {
        return $this->book_name;
    }

    public function setBookName(string $book_name): self
    {
        $this->book_name = $book_name;

        return $this;
    }

    public function getBookDescription(): ?string
    {
        return $this->book_description;
    }

    public function setBookDescription(?string $book_description): self
    {
        $this->book_description = $book_description;

        return $this;
    }

    public function getBookCost(): ?int
    {
        return $this->book_cost;
    }

    public function setBookCost(?int $book_cost): self
    {
        $this->book_cost = $book_cost;

        return $this;
    }

    public function getBookFinePerHour(): ?int
    {
        return $this->book_fine_per_hour;
    }

    public function setBookFinePerHour(?int $book_fine_per_hour): self
    {
        $this->book_fine_per_hour = $book_fine_per_hour;

        return $this;
    }

    public function getBookDepositRequirement(): ?string
    {
        return $this->book_deposit_requirement;
    }

    public function setBookDepositRequirement(?string $book_deposit_requirement): self
    {
        $this->book_deposit_requirement = $book_deposit_requirement;

        return $this;
    }

    public function getBookAuth(): ?LibraryBooksAuthor
    {
        return $this->book_auth;
    }

    public function setBookAuth(?LibraryBooksAuthor $books_author): self
    {
        $this->book_auth = $books_author;

        return $this;
    }

    public function setLibraryBookCopies(?LibraryBookCopies $libraryBookCopies): self
    {
        $this->libraryBookCopies = $libraryBookCopies;

        return $this;
    }

    public function getBookCatRef(): ?LibraryBooksCategory
    {
        return $this->book_cat_ref;
    }

    public function setBookCatRef(?LibraryBooksCategory $book_cat_ref): self
    {
        $this->book_cat_ref = $book_cat_ref;

        return $this;
    }

    /**
     * @return Collection|LibraryBookCopies[]
     */
    public function getLibraryBookCopies(): Collection
    {
        return $this->libraryBookCopies;
    }

    public function addLibraryBookCopy(LibraryBookCopies $libraryBookCopy): self
    {
        if (!$this->libraryBookCopies->contains($libraryBookCopy)) {
            $this->libraryBookCopies[] = $libraryBookCopy;
            $libraryBookCopy->setLibraryBookRef($this);
        }

        return $this;
    }

    public function removeLibraryBookCopy(LibraryBookCopies $libraryBookCopy): self
    {
        if ($this->libraryBookCopies->contains($libraryBookCopy)) {
            $this->libraryBookCopies->removeElement($libraryBookCopy);
            // set the owning side to null (unless already changed)
            if ($libraryBookCopy->getLibraryBookRef() === $this) {
                $libraryBookCopy->setLibraryBookRef(null);
            }
        }

        return $this;
    }

    public function getLibrarySections(): ?LibrarySections
    {
        return $this->librarySections;
    }

    public function setLibrarySections(?LibrarySections $librarySections): self
    {
        $this->librarySections = $librarySections;

        return $this;
    }


}
