<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\AccountHeadsRepository")
 */
class AccountHeads
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60)
     */
    private $ah_name;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $ah_desc;

    /**
     * @ORM\Column(type="boolean")
     */
    private $ah_type;

    /**
     * @ORM\OneToMany(targetEntity="App\Entity\Transactions", mappedBy="income_head")
     */
    private $transactions;

    public function __construct()
    {
        $this->transactions = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAhName(): ?string
    {
        return $this->ah_name;
    }

    public function setAhName(string $ah_name): self
    {
        $this->ah_name = $ah_name;

        return $this;
    }

    public function getAhDesc(): ?string
    {
        return $this->ah_desc;
    }

    public function setAhDesc(?string $ah_desc): self
    {
        $this->ah_desc = $ah_desc;

        return $this;
    }

    public function getAhType(): ?bool
    {
        return $this->ah_type;
    }

    public function setAhType(bool $ah_type): self
    {
        $this->ah_type = $ah_type;

        return $this;
    }

    /**
     * @return Collection|Transactions[]
     */
    public function getTransactions(): Collection
    {
        return $this->transactions;
    }

    public function addTransaction(Transactions $transaction): self
    {
        if (!$this->transactions->contains($transaction)) {
            $this->transactions[] = $transaction;
            $transaction->setIncomeHead($this);
        }

        return $this;
    }

    public function removeTransaction(Transactions $transaction): self
    {
        if ($this->transactions->contains($transaction)) {
            $this->transactions->removeElement($transaction);
            // set the owning side to null (unless already changed)
            if ($transaction->getIncomeHead() === $this) {
                $transaction->setIncomeHead(null);
            }
        }

        return $this;
    }
}
