<?php

namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\DependentFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Faker\Factory;

class CustomFieldFixtures extends BaseFixtures implements DependentFixtureInterface {


	const CustomFieldSectionsReference = 'CustomFieldSectionsReference___';
	const CustomFieldRference = 'CustomFieldReference___F';
	private $faker;

	public function load( ObjectManager $manager ) {

		$this->faker = Factory::create();
		for ( $x = 0; $x < 10; $x ++ ) {
			$customFields = new \App\Entity\CustomFields();
			$customFields->setlabel( $this->faker->name() );
			$temp_ar = [
				'text',
				'textarea',
				'file',
				'dropdown',
				'checkbox',
				'radio',
				'datetime',
				'time',
				'date',
				'dropdown',
				'checkbox',
				'radio',
			];
			$customFields->settype( $temp_ar[ rand( 0, 11 ) ] );
			$customFields->setis_require( $this->faker->boolean );
			$customFields->setplaceholder( $this->faker->sentence );
			$customFields->setoptions( $this->faker->shuffleArray( [ 'Option 1 ', 'Option 2', 'Option 3' ] ) );
			$customFields->setVisibleTo( '1,2,3' );
			$customFields->setVisibleToRegistrationFormOf( '1,4,2,3' );
			$customFields->setAllowedExtension( 'jpg,jpeg,xls,pdf' );
			$customFields->setSortingOrder( rand() );
			$customFields->setHelpMessage( $this->faker->sentence );
			$customFields->setCustomFieldSections( $this->getReference( self::CustomFieldSectionsReference . '_' . $x ) );
			$this->addReference( self::CustomFieldRference . '_' . $x, $customFields );

			$manager->persist( $customFields );
		}

		$manager->flush();
	}

	/**
	 * This method must return an array of fixtures classes
	 * on which the implementing class depends on
	 *
	 * @return array
	 */
	public function getDependencies() {
		// TODO: Implement getDependencies() method.
		return [
			CustomFieldSections::class,
		];
	}
}
