<?php


namespace App\Service;


use App\Entity\Classes;
use App\Entity\ClassFeeTemplate;
use App\Entity\ClassSessionEnrolment;
use App\Entity\ClassSubject;
use App\Entity\ClassSubjectTemplate;
use App\Entity\ClassTemplate;
use App\Entity\Session;
use App\Entity\Subjects;
use App\Entity\User;
use App\Repository\ClassesRepository;
use App\Repository\ClassFeeRepository;
use App\Repository\ClassSessionEnrolmentRepository;
use App\Repository\ClassSubjectRepository;
use App\Repository\ClassSubjectTemplateRepository;
use App\Repository\ClassTemplateRepository;
use App\Repository\SessionRepository;
use App\Repository\SubjectsRepository;
use App\Service\accounts\AccountsService;

use App\Service\accounts\InvoiceService;
use App\Service\Fees\StudentFeeService;
use App\Service\Students\Grade\ClassGradeService;
use App\Service\Students\Grade\ClassGradeTemplateService;
use App\Service\Students\Grade\GradeBase;
use App\Service\StudentsEnrollment\Enrollments;
use App\Service\Teacher\teacherAllocationService;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\ORMException;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

class StudentClasses
{

    /**
     * @var DefaultFunction
     */
    private $default_function;
    private $errorArray = [];
    /**
     * @var ClassTemplateRepository
     */
    private $class_template_repository;
    /**
     * @var EntityManager
     */
    private $entity_manager;
    /**
     * @var SubjectsRepository
     */
    private $subjects_repository;
    /**
     * @var ClassSubjectTemplateRepository
     */
    private $class_subject_template_repository;
    /**
     * @var ClassesRepository
     */
    private $classes_repository;
    /**
     * @var ClassSubjectRepository
     */
    private $class_subject_repository;
    /**
     * @var SessionRepository
     */
    private $session_repository;
    /**
     * @var ClassSessionEnrolmentRepository
     */
    private $class_session_enrolment_repository;
    /**
     * @var UserService
     */
    private $user_service;
    /**
     * @var SubjectService
     */
    private $subject_service;
    /**
     * @var StudentFeeService
     */
    private $student_fee_service;
    /**
     * @var ClassFeeRepository
     */
    private $class_fee_repository;
    /**
     * @var AccountsService
     */
    private $accounts_service;
    /**
     * @var StudentSession
     */
    private $student_session;
    /**
     * @var teacherAllocationService
     */
    private $teacherAllocationService;
    /**
     * @var AppSettings
     */
    private $appSettings;

    /**
     * @var ClassGradeTemplateService
     */
    private $classGradeTemplateService;
    /**
     * @var GradeBase
     */
    private $gradeBase;

    public function __construct(
        AccountsService $accounts_service,
        DefaultFunction $default_function,
        StudentFeeService $student_fee_service,
        ClassTemplateRepository $class_template_repository,
        EntityManagerInterface $entity_manager,
        SubjectsRepository $subjects_repository,
        ClassSubjectTemplateRepository $class_subject_template_repository,
        ClassesRepository $classes_repository,
        ClassSubjectRepository $class_subject_repository,
        SessionRepository $session_repository,
        ClassSessionEnrolmentRepository $class_session_enrolment_repository,
        UserService $user_service,
        SubjectService $subject_service,
        ClassFeeRepository $class_fee_repository,
        teacherAllocationService $teacherAllocationService,
        AppSettings $appSettings,
        GradeBase $gradeBase

    ) {
        $this->default_function = $default_function;
        $this->class_template_repository = $class_template_repository;
        $this->entity_manager = $entity_manager;
        $this->subjects_repository = $subjects_repository;
        $this->class_subject_template_repository = $class_subject_template_repository;
        $this->classes_repository = $classes_repository;
        $this->class_subject_repository = $class_subject_repository;
        $this->session_repository = $session_repository;
        $this->class_session_enrolment_repository = $class_session_enrolment_repository;
        $this->class_fee_repository = $class_fee_repository;
        $this->user_service = $user_service;
        $this->subject_service = $subject_service;
        $this->student_fee_service = $student_fee_service;
        $this->accounts_service = $accounts_service;
        $this->teacherAllocationService = $teacherAllocationService;
        $this->appSettings = $appSettings;
        $this->gradeBase = $gradeBase;
    }

    ## save classTemplateTable in the database.
    ## save attached subjects in the Class Subject table.
    ## save attached fees in the class_fee table.
    public function saveClasses(
        ParameterBag $request,
        StudentSession $student_session,
        $classGradeService = null
    ) {
        $returnResponse = [];

        ## validate the incoming of the session values.
        if (!empty($returnResponse = $this->validateSaveClasses($request))) {
            return $returnResponse;
        }

        ## create session instance
        $ClassTemplate = new ClassTemplate();

        ## if user is editing a session then this key have some value
        if (!empty($request->get('___randsection'))) {
            try {
                ## get the full session record when users want to edit a specific sesssion
                $ClassTemplate = $this->class_template_repository->find($request->get('___randsection'));
                if (!$ClassTemplate instanceof ClassTemplate) {
                    ## if session is not found in the database then create a new session.
                    $ClassTemplate = new ClassTemplate();
                }
            } catch (\Exception $exception) {
                $returnResponse = $this->default_function->push_error($returnResponse, $exception->getMessage());
            }
        }

        if (!empty($returnResponse)) {
            return $returnResponse;
        }


        ## duplication Check of ClassTemplate full name
        $bagDuplication = new ParameterBag();
        $bagDuplication->set('name', trim($request->get('name')));
        $bagDuplication->set('whereNotIn', $ClassTemplate->getId());
        $duplicaitonResponse = $this->class_template_repository->duplicationCheck($bagDuplication);
        if (!empty($duplicaitonResponse)) {
            $returnResponse = $this->default_function->push_error(
                $returnResponse,
                $request->get('name').' has already exist with same name'
            );
        }

        if (!empty($returnResponse)) {
            return $returnResponse;
        }

        ## start save process
        try {

            $ClassTemplate->setName($request->get('name'));
            $ClassTemplate->setShortName($request->get('short_name'));
            $ClassTemplate->setActive($this->default_function->parse__boolean($request->get('active')));
            $ClassTemplate->setAttendanceType(
                $this->default_function->parse__boolean($request->get('subject_vise_attendance'))
            );
            $ClassTemplate->setSubjectwiseFee(
                $this->default_function->parse__boolean($request->get('subject_vise_fee'))
            );
            $ClassTemplate->setNoOfStudents((int)$request->get('number_s'));
            $ClassTemplate->setFee((int)$request->get('fee'));


            $this->entity_manager->persist($ClassTemplate);
            $this->entity_manager->flush();

        } catch (\Exception $exception) {
            return $returnResponse = $this->default_function->push_error($returnResponse, $exception->getMessage());
        }


        ## add selected subjects in the class_subject_template table.
        ## get attached subjects with classes
        $attached_subjects = $request->get('subjects');
        $temp_ar = [];
        ## don't remove these duplicate check, there is logic behind it.
        if (!empty($attached_subjects)) {
            $attached_subjects = $this->class_subject_template_repository->bulkDuplicationCheck(
                $attached_subjects,
                $ClassTemplate->getId()
            );
        }
        if (!empty($attached_subjects)) {
            ## if attached classes is not array then make it.
            if (!is_array($attached_subjects)) {
                $attached_subjects = explode(' ', $attached_subjects);
            }

            ## loop over the classs to save the session
            foreach ($attached_subjects as $key => $value) {
                try {
                    ## get classes template entity
                    /** @var Subjects $Subjects */
                    $Subjects = $this->subjects_repository->find($value);

                    ## get class template
                    $ClassSubjectTemplate = new ClassSubjectTemplate();

                    ## if record found
                    if ($Subjects instanceof Subjects) {

                        ## set subject
                        $ClassSubjectTemplate->setSubject($Subjects);
                        $ClassSubjectTemplate->setClassTemplate($ClassTemplate);
                        $ClassSubjectTemplate->setPassMarks($Subjects->getPassMarks());
                        $ClassSubjectTemplate->setMarks($Subjects->getMarks());
                        $ClassSubjectTemplate->setFee($Subjects->getFee());
                        $ClassSubjectTemplate->setSubjectName($Subjects->getSubjectName());
                        $ClassSubjectTemplate->setShortName($Subjects->getShortName());
                        $ClassSubjectTemplate->setCredits($Subjects->getCredits());
                        //$ClassSubjectTemplate->addClassTemplate( $ClassTemplate );
                        $this->entity_manager->persist($ClassSubjectTemplate);
                        $this->entity_manager->flush();

                        ## get the saved subjects
                        array_push($temp_ar, $ClassSubjectTemplate->getId());
                    }
                } catch (\Exception $exception) {
                    return $returnResponse = $this->default_function->push_error(
                        $returnResponse,
                        $exception->getMessage()
                    );
                }
            }
        }


        ## save attached fees in the Student Fee Table.
        if (!empty($request->get('fees_list'))) {
            $returnResponse = $this->student_fee_service->addFeeInClassFeeTemplateTable(
                $request->get('fees_list'),
                $ClassTemplate
            );
        }


        ## assign grades to Class Template
        if (!empty($request->get('gradeCat'))) {
            /** @var ClassGradeService $classGradeService */
            $returnResponse = $classGradeService->copyStudentDefinedGradeToClassTemplateFromStudentGrade(
                (int)$request->get('gradeCat'),
                $ClassTemplate
            );
        }

        ## if response has no errors
        if (empty($returnResponse)) {
            ## saving session
            if (!empty($request->get('seSon'))) {
                if (is_array($request->get('seSon'))) {
                    foreach ($request->get('seSon') as $key => $value2) {
                        ## save classTemplate in class + assign session to the Class + save subjects from classSubjectTemplate to classSubject
                        $returnResponse = $this->updateClasses___preCheck(
                            $ClassTemplate,
                            $student_session->getSession((int)$value2),
                            $classGradeService
                        );
                    }
                } else {
                    ## save classTemplate in class + assign session to the Class + save subjects from classSubjectTemplate to classSubject
                    $returnResponse = $this->updateClasses___preCheck(
                        $ClassTemplate,
                        $student_session->getSession((int)$request->get('seSon')),
                        $classGradeService
                    );
                }


            }
        }

        $returnResponse = empty($returnResponse) ? 'OK' : $returnResponse;

        return $returnResponse;

    }

    ## validate save classTemplateTable
    public function validateSaveClasses(ParameterBag $request)
    {
        ## validate name.
        $return = [];
        if (empty($request->get('name'))) {
            $return = $this->default_function->push_error($return, 'Please fill out session name');
        }

        return $return;
    }

    ## update data in the classes table.
    ## from now, this will also use in saving process.
    public function updateClasses__(
        ParameterBag $request,
        ClassTemplate $class_template = null,
        Session $session = null
    ) {
        $response = [];

        ## validate the incoming of the session values.
        if (!empty($validationResponse = $this->validateSaveClasses($request))) {
            return $validationResponse;
        }

        $Classes = null;
        $Class_edit = false;
        ## if we found an id for update the session
        if (!empty($request->get('___randsection'))) {
            ## get the class which we want to update.
            $Classes = $this->get_the_class($request->get('___randsection'));
        }

        if (!$Classes instanceof Classes) {
            $Classes = new Classes();
        } else {
            $Class_edit = true;
        }

        $Classes->setName(trim($request->get('name')));
        $Classes->setShortName($request->get('short_name'));
        $Classes->setNoOfStudents((int)$request->get('number_s'));
        $Classes->setFee((int)$request->get('fee'));

        ## set subject-wise fee
        $Classes->setSubjectwiseFee($request->get('subjectwise_fee', false));
        if ($request->get('active') == 'on' || $request->get('active') == 1) {
            $Classes->setActive(true);
        } else {
            $Classes->setActive(false);
        }
        ## attendance type of the class
        if (((int)$request->get('subject_vise_attendance') == 1) || ((string)$request->get(
                    'subject_vise_attendance'
                ) === 'on')) {
            ## set attendance type subject wise
            $Classes->setAttendanceType(true);
        } else {
            ## set attendance type class wise
            $Classes->setAttendanceType(false);
        }

        ## save class template
        if ($class_template instanceof ClassTemplate) {
            $Classes->setClassTemplate($class_template);
        }
        ## save in session
        if ($session instanceof Session) {
            $Classes->setSession($session);
        }

        ## save class fee.
        if (!empty($request->get('fee__list'))) {
            $this->student_fee_service->addFeeInClassFeeTable($request->get('fee__list'), $Classes, $Class_edit);
        }

        ## save subjects to class
        if (!empty($request->get('subjects__list'))) {
            $this->subject_service->addSubjectInClassSubjectTable($request->get('subjects__list'), $Classes);
        }

        ## save grade
        if ($request->get('grade')) {
            $this->gradeBase->assignGradesToClass($request->get('grade'), $Classes);
        }

        ## save changes in database
        try {

            $this->entity_manager->persist($Classes);
            $this->entity_manager->flush();

            ## allocate teacher to the Classes
            if (!empty($request->get('teacherList'))) {
                $this->teacherAllocationService->bulk_assign_teacher_to_class($request, $Classes);
            }

            if ($request->has('needReturnBackClassObject')) {
                $response = $Classes;
            } else {
                $response = 'OK';
            }

        } catch (\Exception $exception) {
            $response = $this->default_function->push_error((array)$response, $exception->getMessage());
        }

        return $response;

    }

    ## save classes from by reference of ClassTemplate
    ## preCheck of updateClasses__
    public function updateClasses___preCheck(ClassTemplate $ClassTemplate, Session $Session, $classGradeService = null)
    {
        $returnResponse = null;

        ## duplication check, check this class has been enrolled in the session or not.
        $attached_classes = $this->classes_repository->bulkDuplicationCheck(
            [$ClassTemplate->getId()],
            $Session->getId()
        );
        if (empty($attached_classes)) {
            ## mean this classTemplate has already attached to the session.
            return $returnResponse = 'OK';
        }

        $C_bag = new ParameterBag();
        $C_bag->set('name', $ClassTemplate->getName());
        $C_bag->set('short_name', $ClassTemplate->getShortName());
        $C_bag->set('number_s', $ClassTemplate->getNoOfStudents());
        $C_bag->set('fee', $ClassTemplate->getFee());
        $C_bag->set('active', $ClassTemplate->getActive());
        $C_bag->set('subject_vise_attendance', $ClassTemplate->getAttendanceType());
        $C_bag->set('subjectwise_fee', $ClassTemplate->getSubjectwiseFee());
        $C_bag->set('needReturnBackClassObject', true);

        ## get Class Fee template from the Class Template table.
        $ClassFeeTemplate = $this->student_fee_service->getFeeFromClassFeeTemplateTable(
            null,
            'class_template',
            $ClassTemplate->getId()
        );
        $classFTArray = [];
        if ($ClassFeeTemplate) {
            /** @var ClassFeeTemplate $classFT */
            foreach ($ClassFeeTemplate as $classFT) {
                array_push($classFTArray, $classFT->getId());
            }
            ## save fee in the ClassFee Table.
            $C_bag->set('fee__list', $classFTArray);
        }

        $Classes = null;
        try {
            ## update the class
            $Classes = $this->updateClasses__($C_bag, $ClassTemplate, $Session);
        } catch (\Exception $exception) {
            $returnResponse = $exception->getMessage();
        }

        ## if class has been saved into database -- then save subjects related to class or do other actions.
        if ($Classes instanceof Classes) {
            ## add subject in the class_subject table.
            $P_bag = new ParameterBag();
            $P_bag->set('classes', $Classes);
            $P_bag->set('class_template', $ClassTemplate);
            try {
                $returnResponse = $this->saveClassSubject($P_bag);
            } catch (\Exception $exception) {
                $returnResponse = $exception->getMessage();
            }
        }

        ## save grades when class has saved successfully.
        if ($classGradeService instanceof ClassGradeService) {
            $returnResponse = $classGradeService->copyStudentClassGradeTemplateToClassGrade($ClassTemplate, $Classes);
        }

        ## sent errors if we've it.
        if (!empty($returnResponse)) {
            $returnResponse = 'OK';
        }

        return $returnResponse;
    }

    ## save date in the class_subject table.
    public function saveClassSubject(ParameterBag $bag)
    {
        $this->errorArray = [];
        if (empty($bag->get('__hidefieldid'))) {

            ## save data in the class_subject table.
            $classes = $bag->get('classes', null);
            $class_template = $bag->get('class_template', null);

            ##  if class and class template is not given then return back.
            if (!$classes instanceof Classes || !$class_template instanceof ClassTemplate) {
                $this->errorArray = $this->default_function->push_error(
                    $this->errorArray,
                    'Invalid Arguments supplied'
                );
            }

            ## sent errors if we've it.
            if (!empty($this->errorArray)) {
                return $this->errorArray;
            }

            ## get the related subjects against the subject_template
            $class_subject_template = $class_template->getClassSubjectTemplates()->toArray();

            if (empty($class_subject_template)) {
                ## try yourself to check in database
                $class_subject_template = $this->subject_service->getSubjectFromClassSubjectTemplate(
                    null,
                    'class_template__',
                    $class_template->getId()
                );
            }

            /** @var ClassSubjectTemplate $value */
            foreach ($class_subject_template as $key => $value) {
                $class_subject = new ClassSubject();
                try {
                    $ClassSubjectTemplate = $this->class_subject_template_repository->find($value->getId());
                    $class_subject->setSubjectName($value->getSubjectName());
                    $class_subject->setShortName($value->getShortName());
                    $class_subject->setCredits($value->getCredits());
                    $class_subject->setFee($value->getFee());
                    $class_subject->setMarks($value->getMarks());
                    $class_subject->setPassMarks($value->getPassMarks());
                    $class_subject->setClasses($classes);
                    $class_subject->setClassSubjectTemplate(
                        $ClassSubjectTemplate
                    );
                    $class_subject->setSubject(
                        $ClassSubjectTemplate->getSubject()
                    );
                    $this->entity_manager->persist($class_subject);
                    $this->entity_manager->flush();

                } catch (\Exception $exception) {
                    $this->errorArray = $this->default_function->push_error(
                        $this->errorArray,
                        $exception->getMessage()
                    );
                }

            }

        } else {
            ## update data in the class subject table.
            try {

                $classSubject = $this->class_subject_repository->find($bag->get('__hidefieldid'));

                if ($classSubject instanceof ClassSubject) {
                    $classSubject->setSubjectName($bag->get('subject_name'));
                    $classSubject->setShortName($bag->get('subject_short_name'));
                    $classSubject->setCredits((int)$bag->get('credits', 0));
                    $classSubject->setFee(( float)$bag->get('subject_fee'));
                    $classSubject->setMarks((int)$bag->get('marks'));
                    $classSubject->setPassMarks((int)$bag->get('pass_marks'));

                    $this->entity_manager->persist($classSubject);
                    $this->entity_manager->flush();

                    ## allocate teacher to the Subjects
                    if (!empty($bag->get('teacherList')) && !empty($bag->get('classesRef'))) {
                        $this->teacherAllocationService->bulk_assign_teacher_to_subject(
                            $bag,
                            $this->classes_repository->find($bag->get('classesRef')),
                            $classSubject
                        );
                    }

                } else {
                    $this->errorArray = $this->default_function->push_error(
                        $this->errorArray,
                        'Class subject not found'
                    );
                }

            } catch (\Exception $exception) {
                $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
            }

            ## if error is empty then place OK, that's mean everything works fine.
            empty($this->errorArray) ? $this->errorArray = 'OK' : '';

        }

        ## sent errors if we've it.
        if (!empty($this->errorArray)) {
            return $this->errorArray;
        }

    }

    ## get active classes of active session.
    public function getClassesOfActiveSession()
    {
        return $this->classes_repository->getActiveClassesOfActiveSession();
    }

    ## Student enrollment in the class
    public function student___enrollmentInClasses(ParameterBag $bag, InvoiceService $invoice_service)
    {
        $response = [];
        $User = $this->user_service->pre__userCheck($bag);

        ## sent errors if we've it.
        if (!$User instanceof User) {
            return $User;
        }
        ## remove id form the post array.
        $bag->remove('id');
        ## add enrolled classes in the class_session_enrollment table.
        foreach ($bag as $key => $value) {
            $class = null;
            $duplicationResponse = null;
            $class__ = explode('_', $key);

            ## get the class object
            if (!empty($class__[0])) {
                $class = $this->get_the_class($class__[0]);
            }

            ## if class not found
            if (!$class instanceof Classes) {
                continue;
            } else {
                ## before moving forward, check the user has already enrolled in the class or not.
                $duplicationBag = new ParameterBag();
                $duplicationBag->set('user_id', $User->getId());
                $duplicationBag->set('session_id', $class->getId());
                $duplicationResponse = $this->class_session_enrolment_repository->duplicationCheck($duplicationBag);
            }

            ## if we found the enrolled classes in it then throw an error.
            if (!empty($duplicationResponse)) {
                return $this->default_function->push_error($response, 'User has already enrolled in the class');
            }

            ## Generate invoice while student enrolment.
            try {
                ## save the student class enrolment
                $ClassSessionEnrollment = new ClassSessionEnrolment();
                $ClassSessionEnrollment->setUserId($User);
                $ClassSessionEnrollment->setFee($class->getFee());
                $ClassSessionEnrollment->setNotes('');
                $ClassSessionEnrollment->setClassSession($class);
                $ClassSessionEnrollment->setAttendanceType($class->getAttendanceType());

                $this->entity_manager->persist($ClassSessionEnrollment);
                $this->entity_manager->flush();

                ## generate invoice, when enrolment is done.
                $Bag__ = new ParameterBag();
                $Bag__->set('class', $class->getId());
                $Bag__->set('studentRf', $User->getId());
                $Bag__->set('classSessionEnrolmentRf', $ClassSessionEnrollment);
                $invoiceGenerationResponse = $invoice_service->generateInvoiceWhileStudentEnrolmentInClass($Bag__);
                if ($invoiceGenerationResponse <> 'OK') {
                    if (is_array($invoiceGenerationResponse)) {
                        $response = array_merge($response, $invoiceGenerationResponse);
                    } else {
                        $response = $this->default_function->push_error($response, $invoiceGenerationResponse);
                    }
                    $response = $this->default_function->push_error(
                        $response,
                        'Invoice is not generated due to above mentioned reason'
                    );
                }

                ## subject enrollment
                $subjectEnrolmentResponse = $this->subject_service->student___enrollmentInSubjects(
                    $value,
                    $ClassSessionEnrollment
                );
                if ($subjectEnrolmentResponse <> 'OK') {
                    $response = $this->default_function->push_error($response, $subjectEnrolmentResponse);
                }

            } catch (\Exception $exception) {
                $this->errorArray = $this->default_function->push_error($this->errorArray, $exception->getMessage());
            }

        }
        if (empty($response)) {
            $response = 'OK';
        }

        return $response;

    }

    ## delete student Class subject enrolment
    public function deleteStudentClassSubjectEnrolment(int $classSessionSubjectEnrolmentRef)
    {

    }

    ## delete student enrolment from class
    public function deleteStudentClassEnrolment(
        int $ClassEnrolmentRef,
        Enrollments $enrollments,
        bool $markAsDelete = true
    ) {
        $response = null;
        $ClassEnrolment = $enrollments->get__class_session_enrolment($ClassEnrolmentRef);
        if ($ClassEnrolment instanceof ClassSessionEnrolment) {
            try {
                ## get enrolment subject from Class session enrolment
                //                $ClassSessionSubjectEnrolment = $ClassEnrolment->getClassSessionEnrolmentSubjects()->toArray();
                //
                //                foreach ($ClassSessionSubjectEnrolment as $value) {
                //                }
                $ClassEnrolment->setIsDeleted(true);
                $this->entity_manager->persist($ClassEnrolment);
                //                $this->entity_manager->remove($ClassEnrolment);
                $this->entity_manager->flush();
                $response = 'OK';
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            } catch (\ORMException $exception) {
                $response = $exception->getMessage();
            }
        } else {
            $response = $ClassEnrolment;
        }

        return $response;
    }


    /**
     * BEGIN::
     * Class Template Operations
     * */

    ## get class
    public function getClassTemplate(int $id = null, string $key = null, string $value = null)
    {
        $response = null;
        try {
            if (!empty($id)) {
                $response = $this->class_template_repository->find($id);
            } else {
                if (!empty($key) && !empty($value)) {
                    $response = $this->class_template_repository->findBy([$key => $value]);
                }
            }
        } catch (\Exception $exception) {
            $response = $exception->getMessage();
        }

        return $response;
    }

    ## delete Class
    public function deleteClassTemplate(int $classTemplate, $markAsDelete = true)
    {
        $response = [];
        $classTemplate = $this->getClassTemplate($classTemplate);
        if ($classTemplate instanceof ClassTemplate) {
            try {
                if ($markAsDelete) {
                    ## mark as delete ClassSubjectTemplate table
                    $deleteClassSubjectTemplateResponse = $this->subject_service->deleteClassSubjectTemplateByClassTemplateRef(
                        $classTemplate,
                        true
                    );
                    if ($deleteClassSubjectTemplateResponse == 'OK') {
                        ## mark as delete classFeeTemplate table
                        $deleteClassFeeTemplateResponse = $this->student_fee_service->deleteClassFeeTemplateByClassTemplateRef(
                            $classTemplate,
                            true
                        );
                        if ($deleteClassFeeTemplateResponse == 'OK') {
                            ## mark as delete
                            $classTemplate->setIsDeleted(true);
                            $classTemplate->setActive(false);
                            $this->entity_manager->persist($classTemplate);
                            $this->entity_manager->flush();
                            $response = 'OK';
                        } else {
                            $response = $deleteClassFeeTemplateResponse;
                        }
                    } else {
                        $response = $deleteClassSubjectTemplateResponse;
                    }

                } else {

                    ## check attachment with the classes.
                    $Classes = count($classTemplate->getClasses()->toArray());
                    if ($Classes > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This class has reference with the '.$Classes.' sessions'
                        );
                    } else {
                        $deleteClassSubjectTemplateResponse = $this->subject_service->deleteClassSubjectTemplateByClassTemplateRef(
                            $classTemplate,
                            false
                        );
                        if ($deleteClassSubjectTemplateResponse == 'OK') {
                            ## delete attached class_fee_template
                            $deleteClassFeeTemplateResponse = $this->student_fee_service->deleteClassFeeTemplateByClassTemplateRef(
                                $classTemplate,
                                false
                            );
                            if ($deleteClassFeeTemplateResponse == 'OK') {
                                ## now remove the class template
                                $this->entity_manager->remove($classTemplate);
                                $this->entity_manager->flush();
                                $response = 'OK';
                            } else {
                                ## return the error if exits
                                $response = $deleteClassFeeTemplateResponse;
                            }
                        } else {
                            ## return the error if exits
                            $response = $deleteClassSubjectTemplateResponse;
                        }
                    }
                }
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        } else {
            $response = $classTemplate;
        }

        return $response;
    }

    ## get all classes
    public function getAllClassTemplate()
    {
        ## get details from settings
        $showDeleteRecords = $this->appSettings->getAppSettingsFromSessions('show_deleted_records');

        return $this->class_template_repository->listOfClassTemplate(
            $this->default_function->parse__YesNoToBoolean($showDeleteRecords)
        );
    }

    /**
     * END::
     * Class Template Operations
     * */


    /**
     * BEGIN::
     * Classes Operations
     * */

    ## get the class
    public function get_the_class(int $refernece)
    {
        $response = null;
        if (!empty($refernece)) {
            try {
                $response = $this->classes_repository->find($refernece);
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }
        }

        return $response;
    }

    ## delete the class
    public function deleteClasses(int $classRef, bool $markAsDelete = true)
    {
        $response = [];
        $Class = $this->get_the_class($classRef);
        if ($Class instanceof Classes) {

            try {
                if ($markAsDelete) {

                    $deleteClassSubject = $this->subject_service->bulkDeleteClassSubjectByClassRef($Class, true);
                    if ($deleteClassSubject == 'OK') {
                        $deleteClassFee = $this->student_fee_service->bulkDeleteClassFeeByClassRef($Class, true);
                        if ($deleteClassFee == 'OK') {

                            $Class->setIsDeleted(true);
                            $Class->setActive(false);
                            $this->entity_manager->persist($Class);
                            $this->entity_manager->flush();
                            $response = 'OK';

                        } else {
                            $response = $deleteClassFee;
                        }
                    } else {
                        $response = $deleteClassSubject;
                    }

                } else {


                    $ClassSubject = count($Class->getClassSubject()->toArray());
                    if ($ClassSubject > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This Class has attached with '.$ClassSubject.' subjects'
                        );
                    }

                    $ClassEnrolment = count($Class->getClassSessionEnrolments()->toArray());
                    if ($ClassEnrolment > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This Class has enrol in '.$ClassEnrolment.' classes'
                        );
                    }

                    $ClassFee = count($Class->getClassFees()->toArray());
                    if ($ClassEnrolment > 0) {
                        $response = $this->default_function->push_error($response, 'This Class has '.$ClassFee.' fees');
                    }

                    $ClassExams = count($Class->getExamsClasses()->toArray());
                    if ($ClassExams > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            'This Class has '.$ClassExams.' exams'
                        );
                    }

                    $ClassExamsStudent = count($Class->getExamsClassesStudents()->toArray());
                    if ($ClassExamsStudent > 0) {
                        $response = $this->default_function->push_error(
                            $response,
                            $ClassExamsStudent.' no of students has  pass out these exams'
                        );
                    }

                    if (!empty($response)) {
                        $response = $this->default_function->push_error(
                            $response,
                            'Please delete them before deleting the Class'
                        );
                    } else {
                        $this->entity_manager->remove($Class);
                        $this->entity_manager->flush();
                        $response = 'OK';
                    }

                }
            } catch (\Exception $exception) {
                $response = $exception->getMessage();
            }

        } else {
            $response = $this->default_function->push_error($response, $Class);
            $response = $this->default_function->push_error($response, 'Class not found');
        }

        return $response;

    }

    ## bulk delete
    ## Session has attached with the multiple classes, if we want to delete session then we've to remove the Classes in it.
    public function bulkDeleteClassesBySessionRef(Session $session, bool $markAsDelete = true)
    {
        /** @var Session $session */
        $classes = $session->getClasses()->toArray();
        $response = [];
        /** @var ClassSubjectTemplate $value */
        foreach ($classes as $key => $value) {
            $response = $this->default_function->push_error(
                $response,
                $this->deleteClasses($value->getId(), $markAsDelete)
            );
        }

        return $this->default_function->purify_success_error_response_in_bulk_operation($response);
    }

    ## get all classes
    public function getAllClasses(ParameterBag $bag = null)
    {

        ## get details from settings
        $showDeleteRecords = $this->appSettings->getAppSettingsFromSessions('show_deleted_records');

        return $this->classes_repository->listOfClasses(
            $this->default_function->parse__YesNoToBoolean($showDeleteRecords),
            $bag
        );

    }

    /**
     * END::
     * Classes  Operations
     * */

}
